/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.cel.valang;

import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ResourceLoader;
import org.springmodules.validation.util.cel.valang.ValangConditionExpressionParser;
import org.springmodules.validation.util.condition.AbstractCondition;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.valang.parser.ValangBased;

public class ValangCondition
extends AbstractCondition
implements ValangBased {
    private ValangConditionExpressionParser parser;
    private String expression;
    private Condition compiledExpression;

    public ValangCondition(String expression) {
        this(expression, null, null);
    }

    public ValangCondition(String expression, Map functionsByName, Map parserByRegexp) {
        this.expression = expression;
        this.parser = new ValangConditionExpressionParser();
        this.parser.setCustomFunctions(functionsByName);
        this.parser.setDateParsers(parserByRegexp);
    }

    public boolean doCheck(Object object) {
        if (this.compiledExpression == null) {
            this.compiledExpression = this.parser.parse(this.expression);
        }
        return this.compiledExpression.check(object);
    }

    public void addCustomFunction(String functionName, String functionClassName) {
        this.parser.addCustomFunction(functionName, functionClassName);
    }

    public void setCustomFunctions(Map functionByName) {
        this.parser.setCustomFunctions(functionByName);
    }

    public void setDateParsers(Map parserByRegexp) {
        this.parser.setDateParsers(parserByRegexp);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parser.setApplicationContext(applicationContext);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.parser.setBeanFactory(beanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.parser.setResourceLoader(resourceLoader);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.parser.setMessageSource(messageSource);
    }

    public void setServletContext(ServletContext servletContext) {
        this.parser.setServletContext(servletContext);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.parser.setApplicationEventPublisher(applicationEventPublisher);
    }
}

