#ifndef _FLOOR_H_
#define _FLOOR_H_

struct _floor {
  struct _cave cave;
  int level;
  GList *monster_header;
  GList *object_header;
  GList *stair_header;
};

GList *floor_header;
struct _floor *curf;

gboolean is_map_pass(struct _coord coord);
gboolean is_map_wall(struct _coord coord);
gboolean is_map_waynavi(struct _coord coord);
gboolean is_map_passed(struct _coord coord);
gboolean is_map_disturb(struct _coord coord);
struct _room *at_room(struct _coord coord);
struct _coord rand_coord_on_room();
void floor_init();
void floor_free();
void floor_curf_set(struct _floor *floor);
struct _floor *floor_add();
struct _floor *floor_tutorial_add();
void floor_curf_store();
void floor_curf_restore();
#endif
