#ifndef _MONSTER_H_
#define _MONSTER_H_

struct _monster {
  int id;
  struct _coord coord;
  int direction;
  struct _status status;
  int chp;
  guint damage;
  struct _sprite *sprite;
  struct _task *task;
};

void monster_trans_state(task_func (*fp)(struct _task *task), struct _monster *monster);
void monster_player_trans_state(task_func (*fp)(struct _task *task), struct _monster *monster, struct _player *player);
struct _monster *is_monster(struct _coord coord);
void monster_take_hit(struct _monster *monster, guint damage);
int monster_AI(struct _monster *monster);
int monster_AI_move(struct _monster *monster);
int monster_AI_attack(struct _monster *monster);
task_func monster_turn_start(struct _task *task);
task_func monster_turn_end(struct _task *task);
task_func monster_move(struct _task *task);
task_func move_monster_anime(struct _task *task);
task_func monster_turn_wait_attack(struct _task *task);
task_func monster_turn_attack(struct _task *task);
task_func monster_attack_player(struct _task *task);
task_func monster_dodge_player(struct _task *task);
task_func monster_damage_by_player(struct _task *task);
task_func monster_killed_by_player(struct _task *task);
task_func monster_delete(struct _task *task);
#endif
