#ifndef _MONSTER2_H_
#define _MONSTER2_H_

enum {
  MONSTER_NAME_MAX_LENGTH = 16
};

enum {
  MONSTER_ID_SNAKE,
  MONSTER_ID_BAT,
  MONSTER_ID_ORC,
  MONSTER_ID_ICEMON,
  MONSTER_ID_KOBOLD,
  MONSTER_ID_ZOMBIE,
  MONSTER_ID_HARPY,
  MONSTER_ID_NYMPH,
  MONSTER_ID_CENTAUR,
  MONSTER_ID_AQUATOR,
  MONSTER_ID_GRIFFIN,
  MONSTER_ID_MANDRAGORA,
  MONSTER_ID_TROLL,
  MONSTER_ID_PHANTOM,
  MONSTER_ID_DRAGON,
  MONSTER_ID_MAX
};

enum {
  MONSTER_ACT_BITE,
  MONSTER_ACT_HIT,
  MONSTER_ACT_CRAWL,
  MONSTER_ACT_CAST_SLEEP,
  MONSTER_ACT_CAST_POISON,
  MONSTER_ACT_RUST_SHIELD,
  MONSTER_ACT_STEAL
};

struct _monster_info {
  gchar name[MONSTER_NAME_MAX_LENGTH];
  int mhp;
  int exp;
  int atk;
  int ac;
};

struct _monster_info Monster_info[MONSTER_ID_MAX];
SDL_Surface *surface_monster_idle[MONSTER_ID_MAX][DIRECTION_SUM][ANIME_J];
SDL_Surface *surface_monster_attack[MONSTER_ID_MAX][DIRECTION_SUM][ANIME_J];
SDL_Surface *surface_monster_damage[MONSTER_ID_MAX][DIRECTION_SUM][ANIME_J];

struct _monster *monster_add();
struct _monster *monster_add_monsterhouse(struct _coord c);
gchar *monster_name(struct _monster *monster);
int monster_mhp(struct _monster *monster);
int monster_exp(struct _monster *monster);
int monster_atk(struct _monster *monster);
int monster_ac(struct _monster *monster);
int monster_act(struct _monster *monster);
void monster_init();
void monster_free();
#endif
