#ifndef _OBJECT_H_
#define _OBJECT_H_

struct _object {
  int id;
  struct _coord coord;
  int plus;
  int count;
  struct _sprite *sprite;
  struct _task *task;
};

void object_trans_state(task_func (*fp)(struct _task *task), struct _object *object);
void object_player_trans_state(task_func (*fp)(struct _task *task), struct _object *object, struct _player *player);
void object_player_object_trans_state(task_func (*fp)(struct _task *task), struct _object *object0, struct _player *player, struct _object *object1);
struct _object *is_object(struct _coord coord);
void object_move_to_inventory(struct _object *object);
void object_move_from_inventory(struct _object *object);
task_func object_on_floor(struct _task *task);
task_func object_player_pickup(struct _task *task);
task_func object_player_wield(struct _task *task);
task_func object_player_equip(struct _task *task);
task_func object_player_throw(struct _task *task);
task_func object_player_apply(struct _task *task);
task_func object_player_drop(struct _task *task);
task_func object_player_magic(struct _task *task);
task_func object_player_object2_apply(struct _task *task);
task_func object_in_inventory(struct _task *task);
task_func object_delete(struct _task *task);
#endif
