#ifndef _OBJECT2_H_
#define _OBJECT2_H_

enum {
  OBJECT_NAME_MAX_LENGTH = 32
};

enum {
  OBJECT_TYPE_WEAPON,
  OBJECT_TYPE_SHIELD,
  OBJECT_TYPE_ARROW,
  OBJECT_TYPE_RING,
  OBJECT_TYPE_POTION,
  OBJECT_TYPE_SCROLL,
  OBJECT_TYPE_WAND,
  OBJECT_TYPE_FOOD,
  OBJECT_TYPE_EXTRA,
  OBJECT_TYPE_MAX
};

enum {
  OBJECT_ID_NOWEAPON,
  OBJECT_ID_DAGGER,
  OBJECT_ID_MACE,
  OBJECT_ID_LONGSWORD,
  OBJECT_ID_TWOHSWORD,
  OBJECT_ID_NOSHIELD,
  OBJECT_ID_SMALL_SHIELD,
  OBJECT_ID_ORCISH_SHIELD,
  OBJECT_ID_ELVEN_SHIELD,
  OBJECT_ID_LARGE_SHIELD,
  OBJECT_ID_DWARVISH_SHIELD,
  OBJECT_ID_NOARROW,
  OBJECT_ID_WOOD_ARROW,
  OBJECT_ID_IRON_ARROW,
  OBJECT_ID_NORING,
  OBJECT_ID_SLOWDIGEST_RING,
  OBJECT_ID_FASTDIGEST_RING,
  OBJECT_ID_STRENGTH_RING,
  OBJECT_ID_SLEEPLESS_RING,
  OBJECT_ID_ADORNMENT_RING,
  OBJECT_ID_HEAL_POTION,
  OBJECT_ID_INCSTR_POTION,
  OBJECT_ID_RESSTR_POTION,
  OBJECT_ID_POISON_POTION,
  OBJECT_ID_EXHEAL_POTION,
  OBJECT_ID_BLINDNESS_POTION,
  OBJECT_ID_RAISELEV_POTION,
  OBJECT_ID_IDENT_SCROLL,
  OBJECT_ID_RMCURSE_SCROLL,
  OBJECT_ID_ENCWEAPON_SCROLL,
  OBJECT_ID_ENCSHIELD_SCROLL,
  OBJECT_ID_EXPLOSION_SCROLL,
  OBJECT_ID_MONDETECT_SCROLL,
  OBJECT_ID_OBJDETECT_SCROLL,
  OBJECT_ID_CREATE_MON_SCROLL,
  OBJECT_ID_TELEPORT_SCROLL,
  OBJECT_ID_MAP_SCROLL,
  OBJECT_ID_TELEPORT_WAND,
  OBJECT_ID_CONFUSE_WAND,
  OBJECT_ID_MMISSILE_WAND,
  OBJECT_ID_SLEEP_WAND,
  OBJECT_ID_RATION,
  OBJECT_ID_SLIMEMOLD,
  OBJECT_ID_AMUYENDOR,
  OBJECT_ID_MAX
};

struct _object Noweapon;
struct _object Noshield;
struct _object Noarrow;
struct _object Noring;
SDL_Surface *surface_object_on_floor[OBJECT_TYPE_MAX];
SDL_Surface *surface_magic[2];

guint damage_calc_wielded(struct _monster *monster, struct _object *object, struct _player *player);
guint damage_calc_throwed(struct _monster *monster, struct _object *object, struct _player *player);
guint damage_calc_attacked_by_monster(struct _monster *monster, struct _object *object, struct _player *player);
gboolean can_takeoff(struct _object *object, struct _player *player);
void takeoff(struct _object *object, struct _player *player);
void equip(struct _object *object, struct _player *player);
struct _object *object_add();
struct _object *object_add_monsterhouse(struct _coord c);
struct _object *noweapon_add();
struct _object *noshield_add();
struct _object *noarrow_add();
struct _object *noring_add();
struct _object *arrow_add_from_quiver(struct _object *arrow_src);
struct _object *magic_add_from_wand(struct _object *wand);
struct _object *object_add_specify_id(int id);
void set_object_ident(struct _object *object, gboolean ident);
int object_type(struct _object *object);
gchar *object_name(struct _object *object);
gboolean object_ident(struct _object *object);
int object_atk(struct _object *object);
int object_ac(struct _object *object);
gboolean object_cursed(struct _object *object);
void object_init();
void object_free();
#endif
