#ifndef _STAIR_H_
#define _STAIR_H_

enum {
  STAIR_TYPE_DOWN,
  STAIR_TYPE_UP
};

struct _stair {
  struct _coord coord;
  int type;
  gboolean tutorial_floor;
  struct _floor *root_floor;
  struct _stair *dest_stair;
  struct _sprite *sprite;
  struct _task *task;
};

SDL_Surface *surface_stair_idle[2];

void stair_trans_state(task_func (*fp)(struct _task *task), struct _stair *stair);
struct _stair *is_stair(struct _coord coord);
void stair_init();
void stair_free();
struct _stair *stair_add(int type);
task_func stair_idle(struct _task *task);
#endif
