#ifndef _VIDEO_H_
#define _VIDEO_H_

enum {
  DISPLAY_W = 640,
  DISPLAY_H = 480,
  DISPLAY_BPP = 16,
  SPRITE_W = 64,
  SPRITE_H = 64,
  ANIME_J = 4,
  Z_ORDER = 5,
};

struct _sprite {
  int x, y;
  gboolean abs;
  gboolean alive;
  SDL_Surface *surface;
};

Uint32 transparent;
SDL_Surface *screen;

void SDL_init();
void loopwait();
void video_sprite_init();
void video_sprite_free();
struct _sprite *video_sprite_add(int z_order);
SDL_Surface *video_bmp_load(char *file);
SDL_Surface *video_crop(SDL_Surface *s, SDL_Rect *r);
SDL_Surface* video_crop_alpha(SDL_Surface *s, SDL_Rect *r, int alpha);
void video_display();
void video_fade();
void video_flamme_init();
void video_flamme(gboolean flag);
void video_flamme_draw();
void video_flamme_free();
#endif

