#ifndef CCONFIGMODE_H_INCLUDED
#define CCONFIGMODE_H_INCLUDED

#include "CStaticCtrl.h"
#include "CEditCtrl.h"
#include "CGroupBox.h"
#include "CCheckBox.h"
#include "CRadioButton.h"
#include "CInterfaceMode.h"

const int RES_MODE_NUM = 4;			//	𑜓x^Cv
const int MIPMAP_NUM = 4;			//	~bv}bv敪
const int PISND_NUM = 4;			//	vOCTEh敪
const int STEREO_METHOD_NUM = 2;	//	XeI@
/*
 *	ݒ胂[h
 */
class CConfigMode: public CInterfaceMode{
private:
	CWindowCtrl m_ConfigWindow1;		//	 1

	CGroupBox m_InterfaceGroup;			//	C^[tFCX
	CCheckBox m_HideTopPanel;			//	plB
	CCheckBox m_HideRightPanel;			//	EplB
	CCheckBox m_WindowShadow;			//	EBhẺe

	CGroupBox m_DeviceGroup;			//	foCX
	CStaticCtrl m_NeedRestart;			//	vċN
	CCheckBox m_FullScreen;				//	tXN[
	CStaticCtrl m_ResLabel;				//	𑜓x
	CRadioButton m_Resolution[RES_MODE_NUM];	//	𑜓x`FbN
	CStaticCtrl m_MipMapLabel;			//	~bv}bv
	CCheckBox m_MipMap[MIPMAP_NUM];		//	~bv}bv`FbN

	CGroupBox m_AccessoryGroup;			//	ANZT
	CCheckBox m_Compass;				//	RpX
	CCheckBox m_WindMeter;				//	͌v
	CCheckBox m_ShowMap;				//	n}

	CGroupBox m_EffectGroup;			//	o
	CCheckBox m_Shadow;					//	e
	CCheckBox m_LinearFilter;			//	eNX`tB^
	CCheckBox m_EnvMap;					//	}bsO
	CCheckBox m_SpecularLight;			//	ʔˌ
	CCheckBox m_SunLensFlare;			//	zYtA
	CCheckBox m_SunWhiteout;			//	zzCgAEg
	CCheckBox m_MiscLensFlare;			//	̑YtA
	CCheckBox m_MiscParticle;			//	p[eBN
	CCheckBox m_Wind;					//	
	CGroupBox m_SoundGroup;				//	TEh
	CCheckBox m_InterfaceSound;			//	C^[tFCX
	CCheckBox m_PluginSound[PISND_NUM];	//	vOCTEh

	CGroupBox m_MiscGroup;				//	̑
	CCheckBox m_UseUndo;				//	AhDgp

	CWindowCtrl m_ConfigWindow2;		//	 2
	CGroupBox m_StereoGroup;			//	XeI
	CCheckBox m_StereoEnabled;			//	XeIL
	CStaticCtrl m_StereoMethodLabel;	//	XeI@
	CRadioButton m_StereoMethod[STEREO_METHOD_NUM];	//	XeI@
	CStaticCtrl m_StereoIntervalLabel;	//	XeI@
	CEditCtrl m_StereoIntervalEdit;		//	_Ԋu
public:
	CConfigMode();
	~CConfigMode(){}
	void EnterInterface();
	void ScanInputInterface();
	void RenderInterface();
	bool Load();
	bool Save();
	int GetHideTopPanel(){ return m_HideTopPanel.GetCheck(); }
	int GetHideRightPanel(){ return m_HideRightPanel.GetCheck(); }
	int GetWindowShadow(){ return m_WindowShadow.GetCheck(); }
	int GetCompass(){ return m_Compass.GetCheck(); }
	int GetWindMeter(){ return m_WindMeter.GetCheck(); }
	int GetShowMap(){ return m_ShowMap.GetCheck(); }
	void SetShowMap(int s){ m_ShowMap.SetCheck(s); }
	int GetShadow(){ return m_Shadow.GetCheck(); }
	void SetShadow(int s){ m_Shadow.SetCheck(s); }
	void SetTexFilter();
	int GetEnvMap(){ return m_EnvMap.GetCheck(); }
	void SetSpecularLight(){ devSetSpecular(m_SpecularLight.GetCheck()); }
	int GetSunLensFlare(){ return m_SunLensFlare.GetCheck(); }
	int GetSunWhiteout(){ return m_SunWhiteout.GetCheck(); }
	int GetMiscLensFlare(){ return m_MiscLensFlare.GetCheck(); }
	int GetMiscParticle(){ return m_MiscParticle.GetCheck(); }
	int GetWind(){ return m_Wind.GetCheck(); }
	int GetInterfaceSound(){ return m_InterfaceSound.GetCheck(); }
	int GetRailSound(){ return m_PluginSound[0].GetCheck(); }
	int GetTrainSound(){ return m_PluginSound[1].GetCheck(); }
	int GetStructSound(){ return m_PluginSound[2].GetCheck(); }
	int GetSurfaceSound(){ return m_PluginSound[3].GetCheck(); }
	int GetUseUndo(){ return m_UseUndo.GetCheck(); }
	int GetStereo(){ return m_StereoEnabled.GetCheck(); }
	void SetStereo(int s){ m_StereoEnabled.SetCheck(s); }
	int GetStereoMethod(){ return m_StereoMethod->GetNumber(); }
	float GetStereoInterval();
	void CheckHardware();
};

//	OO[o
extern char *g_ConfigBuffer;
extern char *g_ConfigScript;
extern float g_ConfigVersion;
extern bool g_RailMipMap;
extern bool g_TrainMipMap;
extern bool g_StructMipMap;
extern bool g_SurfaceMipMap;
extern bool g_NamedObjectMipMap;
extern CConfigMode *g_ConfigMode;

#endif
