#include "stdafx.h"
#include "CCustomizerMover.h"
#include "CSaveFile.h"
#include "CConfigMode.h"

//	O[o
bool g_PreviewAnimation = true;	//	vr[Aj[VtO (Ґvr[ł false)
bool g_MoverEnabled = true;		//	[o[LtO (|[YXCb`Kpł false)

/*
 *	Ǎ
 */
char *CMoverState::Read(
	char *str	//	Ώە
){
	char *eee;
	if(!(str = Assignment(eee = str, "MoverState"))) return NULL;
	if(!(str = Vector3D(eee = str, &m_Pos))) throw CSynErr(eee);
	if(!(str = Character2(eee = str, ','))) throw CSynErr(eee);
	if(!(str = Vector3D(eee = str, &m_Dir))) throw CSynErr(eee);
	if(!(str = Character2(eee = str, ';'))) throw CSynErr(eee);
	return str;
}

/*
 *	ۑ
 */
void CMoverState::Save(
	FILE *df,	//	t@C
	char *ind	//	Cfg
){
	fprintf(df, "%sMoverState = ", ind);
	V3Save(df, m_Pos, ", ");
	V3Save(df, m_Dir, ";\n");
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
void CMoverBase::InitMover(
	CModelPlugin *mpi	//	Ăяo
){
	m_State = mpi->AddMover();
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	KptOZbg
 */
void CDynamicMoverBase::ResetOffCustomizer(
	int v	//	ݒl
){
	/*
	 *	m_ApplyFlag ̈Ӗ
	 *	0: Kp
	 *	1: XCb`^œKpς
	 *	2: XCb`UŖKp
	 */
	m_ApplyFlag = v ? (m_ApplyFlag ? m_ApplyFlag : v) : 0;
}

/*
 *	펞KpXg쐬
 */
void CDynamicMoverBase::SetOffListCustomizer(
	CNamedObject *nobj	//	Ăяo
){
	nobj->AddOffList(this);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CStaticMoverBase::ReadTimingInfo(
	char *str	//	Ώە
){
	char *tmp, *eee;
	char *timinglabel[6] = {
		"PreAnimationDelay", "AnimationTime", "PostAnimationDelay",
		"PreReverseDelay", "ReverseTime", "PostReverseDelay"};
	int i;
	for(i = 0; i<6; i++){
		if(tmp = AsgnFloat(eee = str, timinglabel[i], &m_AnimationTime[i])) str = tmp;
		else m_AnimationTime[i] = i<3 ? 0.0f : m_AnimationTime[5-i];
		if(m_AnimationTime[i]<0.0f) m_AnimationTime[i] = 0.0f;
	}
	return str;
}

/*
 *	Ox
 *
 *	߂l: NWbg
 */
float CStaticMoverBase::ProcDelay(){
	if(!g_PreviewAnimation) return m_ApplyFlag ? 0.0f : 1.0f;
	CMoverState *mstate = GetState();
	VEC3 pos = mstate->GetPos();
	float *timing = m_AnimationTime, credit = 1.0f;
	if(m_ApplyFlag){	//	t
		pos.x = 3.0f-pos.x;
		timing += 3;
	}
	int i;
	for(i = 0; i<3; i++){
		float th = i+1.0f;
		if(pos.x<th){
			if(timing[i]){
				float tmp = 1.0f/(timing[i]*MAXFPS);
				if(g_MoverEnabled) pos.x += credit*tmp;
				credit = (pos.x-th)/tmp;
				ValueArea(&pos.x, i, th);
				if(credit<=0.0f) break;
				if(credit>1.0f) credit = 1.0f;
			}else{
				pos.x = th;
			}
		}
	}
	if(m_ApplyFlag) pos.x = 3.0f-pos.x;
	if(g_MoverEnabled) mstate->SetPos(pos);
	pos.x -= 1.0f;
	ValueArea(&pos.x, 0.0f, 1.0f);
	return pos.x;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CStaticRotator::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	Ăяo
){
	char *tmp, *eee;
	if(!(str = BeginBlock(eee = str, "StaticRotation"))) return NULL;
	if(tmp = AsgnVector3D(eee = str, "RotationAxis", &m_RotationAxis)) str = tmp;
	else m_RotationAxis = V3DIR;
	if(!(str = AsgnFloat(eee = str, "RotationAngle", &m_RotationAngle))) throw CSynErr(eee);
	m_RotationAngle = D3DXToRadian(m_RotationAngle);
	if(!(str = ReadTimingInfo(str))) throw CSynErr(eee);
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	InitMover(mpi);
	return str;
}

/*
 *	pKp
 */
void CStaticRotator::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	if(m_ApplyFlag==1) return;
	float ratio = ProcDelay();
	if(ratio) obj->RotAxis(m_RotationAxis, ratio*m_RotationAngle);
	if(!m_ApplyFlag) m_ApplyFlag = 1;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CStaticMover::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	Ăяo
){
	char *eee;
	if(!(str = BeginBlock(eee = str, "StaticMove"))) return NULL;
	if(!(str = AsgnVector3D(eee = str, "Displacement", &m_Displacement))) throw CSynErr(eee);
	if(!(str = ReadTimingInfo(str))) throw CSynErr(eee);
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	InitMover(mpi);
	return str;
}

/*
 *	pKp
 */
void CStaticMover::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	if(m_ApplyFlag==1) return;
	float ratio = ProcDelay();
	if(ratio) obj->Move(ratio*m_Displacement);
	if(!m_ApplyFlag) m_ApplyFlag = 1;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CDynamicRotator::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	Ăяo
){
	char *tmp, *eee;
	if(!(str = BeginBlock(eee = str, "DynamicRotation"))) return NULL;
	if(tmp = AsgnVector3D(eee = str, "RotationAxis", &m_RotationAxis)) str = tmp;
	else m_RotationAxis = V3DIR;
	if(!(str = AsgnFloat(eee = str, "RotationSpeed", &m_RotationSpeed))) throw CSynErr(eee);
	m_RotationSpeed *= 2.0f*D3DX_PI/MAXFPS;
	if(tmp = AsgnFloat(eee = str, "Acceleration", &m_Acceleration)){
		str = tmp;
		if(m_Acceleration<0.0f) m_Acceleration = m_RotationSpeed;
		else m_Acceleration *= 2.0f*D3DX_PI/(MAXFPS*MAXFPS);
	}else{
		m_Acceleration = m_RotationSpeed;
	}
	if(tmp = AsgnFloat(eee = str, "Deceleration", &m_Deceleration)){
		str = tmp;
		if(m_Deceleration<0.0f) m_Deceleration = m_Deceleration;
		else m_Deceleration *= 2.0f*D3DX_PI/(MAXFPS*MAXFPS);
	}else{
		m_Deceleration = m_RotationSpeed;
	}
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	InitMover(mpi);
	return str;
}

/*
 *	pKp
 */
void CDynamicRotator::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	if(m_ApplyFlag==1 || !g_PreviewAnimation) return;
	CMoverState *mstate = GetState();
	VEC3 pos = mstate->GetPos();	//	x: phase, y: speed
	if(g_MoverEnabled){
		if(m_RotationSpeed<0.0f){
			pos.y -= (m_ApplyFlag ? -m_Deceleration : m_Acceleration);
			ValueArea(&pos.y, m_RotationSpeed, 0.0f);
		}else{
			pos.y += (m_ApplyFlag ? -m_Deceleration : m_Acceleration);
			ValueArea(&pos.y, 0.0f, m_RotationSpeed);
		}
		pos.x += pos.y;
	}
	ValueCircular(&pos.x, 0.0f, 2.0f*D3DX_PI);
	mstate->SetPos(pos);
	obj->RotAxis(m_RotationAxis, pos.x);
	if(!m_ApplyFlag) m_ApplyFlag = 1;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CWindTracker::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	Ăяo
){
	char *tmp, *eee;
	if(!(str = BeginBlock(eee = str, "TrackWind"))) return NULL;
	if(!(str = AsgnFloat(eee = str, "TrackSpeed", &m_TrackSpeed))) throw CSynErr(eee);
	if(tmp = AsgnVector3D(eee = str, "FixAxis", &m_FixAxis)){
		str = tmp;
		V3Norm(&m_FixAxis, &m_FixAxis);
		m_FixAxisFlag = true;
	}else{
		m_FixAxisFlag = false;
	}
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	InitMover(mpi);
	return str;
}

/*
 *	pKp
 */
void CWindTracker::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	CMoverState *mstate = GetState();
	VEC3 tr = obj->GetRight(), tu = obj->GetUp(), td = obj->GetDir();
	VEC3 odir = V3LocalToWorld(&mstate->GetDir(), &tr, &tu, &td);
	if(g_MoverEnabled){
		VEC3 wind = g_ConfigMode->GetWind() ? g_WindDir : V3ZERO;
		VEC3 pos = obj->GetPos();
		wind += mstate->GetPos()-pos;
		mstate->SetPos(pos);
		VEC3 ndir = odir+m_TrackSpeed*wind;
		V3Norm(&ndir, &ndir);
		if(m_FixAxisFlag){
			VEC3 axis = V3LocalToWorld(&m_FixAxis, obj);
			V3Norm(&ndir, &(ndir-V3Dot(&ndir, &axis)*axis));
		}
		obj->SetDir(ndir, obj->GetUp());
		mstate->SetDir(*V3Norm(&ndir, &V3WorldToLocal(&obj->GetDir(), &tr, &tu, &td)));
	}else{
		obj->SetDir(odir, obj->GetUp());
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CWindmill::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	Ăяo
){
	char *tmp, *eee;
	if(!(str = BeginBlock(eee = str, "Windmill"))) return NULL;
	if(tmp = AsgnYesNo(eee = str, "Directional", &m_Directional)) str = tmp;
	else m_Directional = true;
	if(tmp = AsgnVector3D(eee = str, "RotationAxis", &m_RotationAxis)) str = tmp;
	else m_RotationAxis = V3DIR;
	if(!(str = AsgnFloat(eee = str, "RotationSpeed", &m_RotationSpeed))) throw CSynErr(eee);
	m_RotationSpeed *= 2.0f*D3DX_PI;
	if(!(str = AsgnInteger(eee = str, "Symmetric", &m_Symmetric))) throw CSynErr(eee);
	if(m_Symmetric<1) m_Symmetric = 1;
	m_MaxRotation = SYMMETRIC_ROTATION_MAX/m_Symmetric;
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	InitMover(mpi);
	return str;
}

/*
 *	pKp
 */
void CWindmill::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	CMoverState *mstate = GetState();
	VEC3 odir = mstate->GetDir();
	if(g_MoverEnabled){
		VEC3 wind = g_ConfigMode->GetWind() ? g_WindDir : V3ZERO;
		VEC3 pos = obj->GetPos();
		wind += mstate->GetPos()-pos;
		mstate->SetPos(pos);
		float rot = m_RotationSpeed;
		if(m_Directional){
			VEC3 axis = V3LocalToWorld(&m_RotationAxis, obj);
			rot *= V3Dot(V3Norm(&axis, &axis), &wind);
		}else{
			rot *= V3Len(&wind);
		}
		float tmp = m_MaxRotation*(1.0f-expf(-fabsf(rot)/m_MaxRotation));
		odir.x += rot<0.0f ? -tmp : tmp;
		ValueCircular(&odir.x, 0.0f, 2.0f*D3DX_PI);
		obj->RotAxis(m_RotationAxis, odir.x);
		mstate->SetDir(odir);
	}else{
		obj->RotAxis(m_RotationAxis, odir.x);
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CAnalogClock::Read(
	char *str	//	Ώە
){
	char *eee;
//	if(!(str = BeginBlock(eee = str, "AnalogClock"))) return NULL;
	string handtype;
	if(!(str = AsgnIdentifier(eee = str, "AnalogClock", &handtype))) return NULL;
	if(handtype=="Hour") m_HandType = 0;
	else if(handtype=="Minute") m_HandType = 1;
	else if(handtype=="Second") m_HandType = 2;
	else throw CSynErr(eee, "%s: \"%s\"", lang(InvalidHandType), handtype.c_str());
//	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	return str;
}

/*
 *	pKp
 */
void CAnalogClock::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	double theta = 2.0f*D3DX_PI;
	double time = g_RSPV ? 0.0 : g_SaveFile->GetAbsTime();
	switch(m_HandType){
	case 0: theta *= 2.0*fmod(time, 1.0/2.0); break;
	case 1: theta *= 24.0*fmod(time, 1.0/24.0); break;
	case 2: theta *= 24.0*60.0*fmod(time, 1.0/(24.0*60.0)); break;
	}
	obj->RotZ((float)theta);
}
