#ifndef CFILEMODE_H_INCLUDED
#define CFILEMODE_H_INCLUDED

#include "CStaticCtrl.h"
#include "CEditCtrl.h"
#include "CPushButton.h"
#include "CCheckBox.h"
#include "CListView.h"
#include "CInterfaceMode.h"

class CYesNoDialog;
class CInputDialog;
class CMultiInputDialog;

/*
 *	Z[ut@CXgvf
 */
class CLayoutInfo{
	friend class CFileMode;
private:
	float m_Version;	//	Ήo[W
	string m_FileName;	//	t@C
	string m_FileDate;	//	XV
	string m_FileNote;	//	l
public:
	CLayoutInfo(char *fname){ m_FileName = fname; }
	bool PreLoadSF(FILE *file);
	bool operator<(const CLayoutInfo &rhs){ return m_FileName<rhs.m_FileName; }
};

//	q
typedef list<CLayoutInfo>::iterator ILayoutInfo;

/*
 *	t@CXgr[
 */
class CFileListView: public CIconListView{
public:
	bool ConfirmRename(CListElement *, string &);
	void EndRename(CListElement *);
	void DoubleClick();
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	t@C[h
 */
class CFileMode: public CInterfaceMode, public CWindowResizer, public CMenuCommander{
private:
	int m_ModalState;						//	[_
	int m_RedoNum;							//	hD
	int m_UndoNum;							//	AhD
	int m_UndoPos;							//	AhDʒu
	bool m_NetworkMode;						//	lbg[N[h
	DPNID m_DeletingMemberID;				//	폜Ώۃo[ID
	string m_NewFileName;					//	VKt@C
	string m_NetworkFileName;				//	lbg[hŎgpt@C
	CYesNoDialog *m_YesNoDialog;			//	yes/no _CAO
	CInputDialog *m_InputDialog;			//	̓_CAO
	CMultiInputDialog *m_MultiInputDialog;	//	ړ̓_CAO
	CPopMenu *m_FileMenu;					//	t@Cj[
	list<CLayoutInfo> m_LayoutInfoList;		//	t@CXg
	CWindowCtrl m_FileWindow;				//	
	CStaticCtrl m_FileLabel;				//	t@Cx
	CStaticCtrl m_NoteLabel;				//	lx
	CEditCtrl m_NoteEdit;					//	lGfBbg
	CPushButton m_NewButton;				//	VK쐬
	CPushButton m_OpenButton;				//	J
	CPushButton m_SaveButton;				//	㏑ۑ
	CPushButton m_SaveAsButton;				//	ʖŕۑ
	CPushButton m_NetworkButton;			//	lbg[N
	CFileListView m_FileListView;			//	t@CXgr[
	CCheckBox m_AutoLoadCheck;				//	Ǎ
	CWindowCtrl m_NetworkWindow;			//	
	CStaticCtrl m_NetworkLabel;				//	t@Cx
	CPushButton m_CloseEntryButton;			//	tI{^
	CPushButton m_DeleteMemberButton;		//	o폜{^
	CPushButton m_DisconnectButton;			//	VK쐬
	CListView m_NetworkListView;			//	oXgr[
public:
	CFileMode();
	~CFileMode();
	void WindowResized(int, int, CWindowCtrl *);
	CPopMenu *Dispatch(CMDTYPE, DWORD);
	char *LoadInterfaceSetting(char *);
	void SaveInterfaceSetting(FILE *);
	void EnterInterface();
	void ModalFuncInterface();
	void ScanInputInterface();
	void ListFile();
	void BeginNetworkHost(char *);
	void BeginNetworkJoin(char *);
	void SwitchNetwork(bool, bool);
	void OpenFile(char *);
	void SaveFile(char *);
	void UpdateFileName();
	void UpdateFileNote();
	void ResetUndo();
	void PushUndo();
	void LoadUndo();
	void LoadRedo();
};

//	OO[o
extern CFileMode *g_FileMode;

#endif
