#ifndef CLINE_H_INCLUDED
#define CLINE_H_INCLUDED

class CPole;
class CLine;
class CScene;
class CLinePlugin;
class CPolePlugin;

/*
 *	ːN
 */
class CPoleLink{
public:
	int m_Side;		//	TCh
	int m_Track;	//	Oԍ
	CPole *m_Link;	//	N
public:
	CPoleLink(){ m_Side = m_Track = NULL; m_Link = NULL; }
	CPoleLink(int, int, CPole *);
	bool IsValid(){ return !!m_Link; }
	void Connect(CLine *);
	void Disconnect(CLine *);
	VEC3 GetPos();
	VEC3 GetOrigPos();
	VEC3 GetRight();
	VEC3 GetUp();
	VEC3 GetDir();
	VEC3 GetOrigDir();
	void Render(D3DCOLOR);
	void RestoreAddress();
	char *Read(char *, char *);
	void Save(FILE *, char *);
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	ːCX^X
 */
class CPole{
	friend class CPoleLink;
private:
	static CPole **ms_Root;		//	ڑ[g
	static float ms_MinDist;	//	ŏo
	static CPoleLink ms_Detect;	//	o
	int m_Selected;				//	ItO
	VEC3 m_Pos;					//	ʒu
	VEC3 m_Right;				//	E
	VEC3 m_Up;					//	
	VEC3 m_Dir;					//	
	VEC3 m_OrigDir;				//	 dir
	CObject m_Object;			//	IuWFNg
	list<CLine *> m_LineList;	//	ːXg
	CPolePlugin *m_PolePlugin;	//	ːvOC
	CPole *m_Next;				//	Xg
public:
	static void SetRoot(CPole **r){ ms_Root = r; }
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool RenderLink();
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static CPoleLink &GetDetect(){ return ms_Detect; }
	CPole();
	CPole(const VEC3 &, const VEC3 &, CPolePlugin *);
	~CPole();
	void Delete(CScene *);
	CPole *Next(){ return m_Next; }
	CPole **NextAdr(){ return &m_Next; }
	CPoleLink CreateLink(int s, int t){ return CPoleLink(s, t, this); }
	void AddLine(CLine *line){ m_LineList.push_back(line); }
	void DeleteLine(CLine *line){ m_LineList.remove(line); }
	VEC3 GetJointPos(int);
	VEC3 GetOrigPos(){ return m_Pos; }
	int GetSelectFlag(){ return m_Selected; }
	void AddSelectFlag(int s){ m_Selected |= s; }
	void ScanInput(int, VEC3 &, VEC3 &);
	void Render();
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

/*
 *	ːCX^X
 */
class CLine{
private:
	static CLine **ms_Root;		//	ڑ[g
	static float ms_MinDist;	//	ŏo
	static CLine *ms_Detect;	//	o
	int m_Selected;				//	ItO
	vector<float> m_LineMapV;	//	ː}bsO V W
	VEC3 m_Right;				//	right
	VEC3 m_Dir;					//	dir
	CPoleLink m_Link[2];		//	ڑː
	CLinePlugin *m_LinePlugin;	//	ːvOC
	CLine *m_Next;				//	Xg
public:
	static void SetRoot(CLine **r){ ms_Root = r; }
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static CLine *GetDetect(){ return ms_Detect; }
	CLine();
	CLine(CPoleLink, CPoleLink, CLinePlugin *);
	~CLine();
	void Delete();
	CLine *Next(){ return m_Next; }
	CLine **NextAdr(){ return &m_Next; }
	CPoleLink GetLink(int s){ return m_Link[s]; }
	int GetSelectFlag(){ return m_Selected; }
	void AddSelectFlag(int s){ m_Selected |= s; }
	void ScanInput(int, VEC3 &, VEC3 &);
	void Dump();
	void Render();
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

//	q
typedef list<CLine *>::iterator IPLine;

/*
 *	ːɐڑ
 */
inline void CPoleLink::Connect(
	CLine *line	//	ːCX^X
){
	m_Link->AddLine(line);
}

/*
 *	ː̐ڑ
 */
inline void CPoleLink::Disconnect(
	CLine *line	//	ːCX^X
){
	m_Link->DeleteLine(line);
}

/*
 *	ڑW߂
 */
inline VEC3 CPoleLink::GetPos(){
	return m_Link->GetJointPos(m_Track);
}

/*
 *	ڑW߂
 */
inline VEC3 CPoleLink::GetOrigPos(){
	return m_Link->GetOrigPos();
}

/*
 *	ڑ right xNg߂
 */
inline VEC3 CPoleLink::GetRight(){
	return m_Side ? -m_Link->m_Right : m_Link->m_Right;
}

/*
 *	ڑ up xNg߂
 */
inline VEC3 CPoleLink::GetUp(){
	return m_Link->m_Up;
}

/*
 *	ڑ dir xNg߂
 */
inline VEC3 CPoleLink::GetDir(){
	return m_Side ? -m_Link->m_Dir : m_Link->m_Dir;
}

/*
 *	ڑ dir xNg߂
 */
inline VEC3 CPoleLink::GetOrigDir(){
	return m_Side ? -m_Link->m_OrigDir : m_Link->m_OrigDir;
}

//	OO[o
extern vector<CPoleLink> g_LastPole;
extern vector<CPoleLink> g_FinishPole;

#endif
