#ifndef CNAMEDOBJECT_H_INCLUDED
#define CNAMEDOBJECT_H_INCLUDED

#include "CModelSwitch.h"
#include "CPartsInst.h"

class CModelInst;
class CNamedObject;
class CModelPlugin;

const float SYMMETRIC_ROTATION_MAX = 0.45f;	//	ōΏ̉]x

//	VXeIuWFNgԍ
extern enum{
	SYS_OBJ_WORLD = 0,
	SYS_OBJ_LOCAL,
	SYS_OBJ_CAMERA,
	SYS_OBJ_LIGHT,
	SYS_OBJ_FORCE_DWORD = 0xffffffff
} SYS_OBJ_ID;

/*
 *	OtIuWFNgAt^[_
 */
class CNamedObjectAfterRenderer{
private:
	static CModelInst *ms_CurrentInst;		//	݂̃CX^X
	static CModelPlugin *ms_CurrentPlugin;	//	݂̃fvOC
	int m_InstSwitch[INSTANCE_SWITCH_NUM];	//	CX^XXCb`
	CModelInst *m_ModelInst;				//	݂̃CX^X
	CModelPlugin *m_ModelPlugin;			//	݂̃fvOC
	CNamedObject *m_NamedObject;			//	OtIuWFNg
	CPartsInst *m_PartsInst;				//	p[cCX^X
	bool m_PartsInstCreation;				//	p[cCX^X쐬tO
public:
	static void SetCurrentInst(CModelInst *inst){ ms_CurrentInst = inst; }
	static void SetCurrentPlugin(CModelPlugin *mpi){ ms_CurrentPlugin = mpi; }
	CNamedObjectAfterRenderer(CNamedObject *, CPartsInst *);
	CNamedObjectAfterRenderer(const CNamedObjectAfterRenderer &);
	~CNamedObjectAfterRenderer();
	void Render(int);
};

//	q
typedef list<CNamedObjectAfterRenderer>::iterator INamedObjectAfterRenderer;

/*
 *	OtIuWFNg
 */
class CNamedObject{
	friend class CNamedObjectAfterRenderer;
protected:
	static int ms_AfterMode;				//	At^[_O[h
	static int ms_AfterRender;				//	At^[_OtO
											//	(1: noshadow, 2: transparent)
	static bool ms_CastShadowDefault;		//	e`tOftHgl
	static bool ms_SetMaterial;				//	}eAύXtO
	static bool ms_PartsInstValid;			//	p[cCX^XgptO
	static IPartsInst ms_PartsInst;			//	p[cCX^Xq
	static list<CNamedObjectAfterRenderer> ms_AfterRenderList;	//	At^[_
	static list<CNamedObjectAfterRenderer> ms_TransRenderList;	//	|_
	float m_ModelScale;						//	fXP[
	bool m_Turn;							//	]tO
	bool m_CastShadow;						//	eLXgtO
	string m_ModelFileName;					//	ft@C
	string m_ObjectName;					//	IuWFNg
	CMesh *m_Mesh;							//	bV
	CObject *m_LastObject;					//	ŌɎgpIuWFNg
	CObject m_PreviewObject;				//	vr[pIuWFNg
	list<CCustomizerBase *> m_OffList;		//	펞KpJX^}CUGg
	CCustomizerSwitchEntry m_Customizer;	//	[gJX^}CU
public:
	static void SetCastShadowDefault(bool s){ ms_CastShadowDefault = s; }
	static void SetSetMaterial(bool s){ ms_SetMaterial = s; }
	static void SetPartsInst(list<CPartsInst> *);
	static CPartsInst *GetParts(){ return ms_PartsInstValid ? &*(ms_PartsInst++) : NULL; }
	static void SetRenderAfter(int m){ ms_AfterRender |= m; }
	static int GetAfterRender(){ return ms_AfterMode; }
	static void InitAfterRenderList();
	static void AfterRenderAll();
	CNamedObject();
	virtual int GetType(){ return 0; }
	void Init(char *name){ m_ObjectName = name; }
	char *ReadModelInfo(char *, CModelPlugin *);
	char *GetName(){ return (char *)m_ObjectName.c_str(); }
	CNamedObject *Check(const string &name){ return m_ObjectName==name ? this : NULL; }
	CObject *GetObject(){ return m_LastObject; }
	CObject *GetPreviewObject(){ return &m_PreviewObject; }
	void LoadModel(CModelPlugin *);
	void AddOffList(CCustomizerBase *cb){ m_OffList.push_back(cb); }
	void SetMesh(CObject *);
	bool GetTurn(){ return m_Turn; }
	void SetPreviewPosture(VEC3, VEC3, VEC3);
	CObject *GetPartsObject(){
		//Debug("&*ms_PartsInst = %p\n", &*ms_PartsInst);
		return m_LastObject = ms_PartsInstValid
			? (ms_PartsInst++)->GetObject() : &m_PreviewObject;
	}
	void CheckDetect();
	void Render();
	void RenderAfter(CPartsInst *, int);
	void SetMaterial(CMesh *mesh){ m_Customizer.Apply(mesh); }
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	IuWFNgWCg{NX
 */
class CObjectJoint{
public:
	CNamedObject *m_Link;	//	ڑIuWFNg
public:
	CObjectJoint(){ m_Link = NULL; }
	char *Read(char *, CModelPlugin *);
	bool IsLinked(){ return !!m_Link; }
	VEC3 GetRight(){ return m_Link->GetObject()->GetRight(); }
	VEC3 GetUp(){ return m_Link->GetObject()->GetUp(); }
	VEC3 GetDir(){ return m_Link->GetObject()->GetDir(); }
};

/*
 *	IuWFNgWCg pos, dir, up w
 */
class CObjectJoint3D: public CObjectJoint{
public:
	bool m_FixCenter;			//	SCtO
	VEC3 m_AttachCoord;			//	ڑ惍[JW
	VEC3 m_LocalCoord;			//	ڑ[JW
	VEC3 m_AttachDir;			//	ڑ惍[J dir
	VEC3 m_AttachUp;			//	ڑ惍[J up
	CNamedObject *m_DirLink;	//	dir IuWFNg
	CNamedObject *m_UpLink;		//	up IuWFNg
public:
	CObjectJoint3D(){ m_DirLink = m_UpLink = NULL; }
	char *Read(char *, CModelPlugin *);
	void SetTurnLocal();
	VEC3 GetPos(){
		VEC3 ret;
		CObject *obj = m_Link->GetObject();
		return *D3DXVec3TransformCoord(
			&ret, &(m_AttachCoord/obj->GetScale()), &obj->GetMatrix());
	}
	VEC3 GetDir(){
		VEC3 ret;
		return *D3DXVec3TransformNormal(
			&ret, &m_AttachDir, &m_DirLink->GetObject()->GetMatrix());
	}
	VEC3 GetUp(){
		VEC3 ret;
		return *D3DXVec3TransformNormal(
			&ret, &m_AttachUp, &m_UpLink->GetObject()->GetMatrix());
	}
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	t[IuWFNg{NX
 */
class CFreeObjectBase{
protected:
public:
	virtual ~CFreeObjectBase(){}
	virtual CFreeObjectBase *Duplicate() = 0;
	virtual void SetPostureFreeObject() = 0;
	virtual CNamedObject *CheckFreeObject(const string &) = 0;
	virtual void LoadModelFreeObject(CModelPlugin *) = 0;
	virtual void AttachPartsFreeObject() = 0;
	virtual void ScanInputFreeObject() = 0;
	virtual void RenderFreeObject() = 0;
};

/*
 *	xNgzu
 */
class CFreeObject3D: public CNamedObject, public CFreeObjectBase{
	friend class CTrainPlugin;
private:
	CObjectJoint3D m_Joint;	//	ڑ
public:
	CFreeObject3D(){}
	CFreeObject3D(char *, char *, float);
	CFreeObjectBase *Duplicate(){ return new CFreeObject3D(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureFreeObject();
	CNamedObject *CheckFreeObject(const string &name){ return Check(name); }
	void LoadModelFreeObject(CModelPlugin *mpi){ LoadModel(mpi); }
	void AttachPartsFreeObject(){ GetPartsObject(); }
	void ScanInputFreeObject(){ CheckDetect(); }
	void RenderFreeObject(){ Render(); }
};

//	q
typedef list<CFreeObject3D>::iterator IFreeObject3D;

//	֐錾
void InitSystemObject();
CNamedObject *FindSystemObject(const string &);
CNamedObject *FindObjectHybrid(CModelPlugin *, const string &);
void CheckObjectHybrid(char *, CModelPlugin *, const string &);

//	OO[o
extern bool g_PreSimulationFlag;
extern CNamedObject g_SystemObject[];

#endif
