#ifndef CPLUGINTREE_H_INCLUDED
#define CPLUGINTREE_H_INCLUDED

#include "CInterface.h"
#include "CScrollBarV.h"
#include "CDragContainer.h"
#include "CPopMenu.h"
#include "CTreeFileElement.h"
#include "CTreeDirElement.h"

class CPluginMode;

/*
 *	vOCc[
 */
class CPluginTree: public CInterface, public CDragInterface{
	friend class CTreeElement;
	friend class CTreeFileElement;
	friend class CTreeDirElement;
private:
	int m_State;					//	
	int m_Rows;						//	ő\
	bool m_Focused;					//	tH[JXǉtO
	CTreeElement *m_PushedItem;		//	ꂽACe
	CTreeElement *m_FocusItem;		//	tH[JX
	CTreeDirElement *m_DropItem;	//	tH[JX
	CTreeDirElement *m_Root;		//	f[^[g
	CScrollBarV m_ScrollV;			//	XN[o[
	CPluginListView *m_SyncList;	//	tXgr[
	CMenuCommander *m_Commander;	//	R}_
public:
	CPluginTree();
	~CPluginTree();
	void Init(int, int, int, int, char *, CInterface *, CPluginListView *, CMenuCommander *);
	CTreeElement *GetPushedItem(){ return m_PushedItem; }
	CTreeElement *GetFocusItem(){ return m_FocusItem; }
	void SetFocusItem(CTreeElement *);
	CTreeDirElement *GetRoot(){ return m_Root; }
	CTreeDirElement *GetDropItem(){ return m_DropItem; }
	void SetDropItem(CTreeDirElement *);
	void SelectPlugin(CPlugin *);
	void EnsureVisible();
	void SetScroll();
	void GiveFocus(bool snd = true);
	void RenderDragItem();
	char *Load(char *, char *, CPluginMode *);
	void Save(FILE *, char *);
	bool ScanInput();
	void Render();
};

#endif
