#ifndef CSIMULATIONMODE_H_INCLUDED
#define CSIMULATIONMODE_H_INCLUDED

#include "CStaticCtrl.h"
#include "CGroupBox.h"
#include "CRadioButton.h"
#include "CCheckBox.h"
#include "CInterfaceMode.h"

const int TIME_SCALE_NUM = 10;
const int SIM_SPEED_NUM = 5;

/*
 *	V~[Vݒ胂[h
 */
class CSimulationMode: public CInterfaceMode{
	friend class CSaveFile;
private:
	int m_OldSpeed;								//	|[YȎx
	CWindowCtrl m_SimulationWindow;				//	
	CGroupBox m_ScaleGroup;						//	XP[O[v
	CRadioButton m_TimeScale[TIME_SCALE_NUM];	//	ԎXP[
	CGroupBox m_SpeedGroup;						//	xO[v
	CRadioButton m_SimSpeed[SIM_SPEED_NUM];		//	V~[Vx
	CGroupBox m_TimeGroup;						//	Ԍo
	CStaticCtrl m_RotLabel;						//	n̎]
	CRadioButton m_EarthRotation[3];			//	]`FbN
	CStaticCtrl m_RevLabel;						//	ň]
	CRadioButton m_EarthRevolution[5];			//	]`FbN
	CGroupBox m_MiscGroup;						//	Ԍo
	CCheckBox m_ManualControl;					//	}jA
	CCheckBox m_IgnoreAcceleration;				//	x𖳎
	CStaticCtrl m_NoteLabel;					//	ӏ
public:
	CSimulationMode();
	~CSimulationMode(){}
	void EnterInterface();
	void ScanInputInterface();
	void InitTimeOption();
	int GetEarthRotation(){ return m_EarthRotation->GetNumber(); }
	int GetEarthRevolution(){ return m_EarthRevolution->GetNumber(); }
	int GetTimeScale();
	int GetSimSpeed();
	int GetOldSpeed(){ return m_OldSpeed; }
	void SetSimSpeed(int);
	void TogglePause();
	int GetManualControl(){ return m_ManualControl.GetCheck(); }
	int GetIgnoreAcceleration(){ return m_IgnoreAcceleration.GetCheck(); }
};

//	OO[o
extern CSimulationMode *g_SimulationMode;

#endif
