#ifndef CTRAIN_H_INCLUDED
#define CTRAIN_H_INCLUDED

#include "CTrainSetBuffer.h"

class CScene;
class CTrainGroup;
class CTrainPlugin;
class CListElement;

#include "CModelInst.h"

/*
 *	qCX^X
 */
class CTrain: public CModelInst{
	friend class CTrainGroup;
private:
	bool m_Reverse;					//	]
	bool m_Setting;					//	zuƒ
	bool m_Warping;					//	[v
	bool m_WarpingOld;				//	[vtO
	VEC3 m_OldPos[2];				//	W
	VEC3 m_TiltDir;					//	UqxNg
	CTrainGroup *m_Group;			//	Ґ
	CTrainPlugin *m_TrainPlugin;	//	qvOC
	CListElement *m_ListElement;	//	Xgvf
	list<CAxlePosture> m_AxleList;	//	ԎXg
	CTrain *m_Next;					//	
public:
	CTrain(CTrainGroup *);
	CTrain(CTrainPlugin *, CTrainGroup *, bool);
	~CTrain();
	CTrain *Next(){ return m_Next; }
	CTrain **NextAdr(){ return &m_Next; }
	CTrainGroup *GetTrainGroup(){ return m_Group; }
	bool IsReverse(){ return m_Reverse; }
	void Reverse();
	void ToggleSetting(){ m_Setting = !m_Setting; }
	void NotifyWarp(){ if(m_Setting) m_Warping = true; }
	bool IsWarping(){ return m_Warping; }
	void SetListElement(CListElement *le){ m_ListElement = le; }
	float GetLength();
	float SetSetBuffer(float, list<CTrainSetBuffer> *);
	CScene *GetScene();
	bool CheckScene();
	void PushAxle(CAxlePosture &a){ m_AxleList.push_back(a); }
	void ApplyAxle(bool);
	void ResetTilt();
	void PrintInfo();	
	CModelInst *Control();
	void SetCabinView(bool, VEC3, VEC3);
	void ScanInput(int, VEC3 &, VEC3 &);
	void Render();
	void SimulateModelInst();
	char *Read(char *, CTrain ***);
	void Save(FILE *);
};

#endif
