#ifndef CTRAINGROUPTEMPLATE_H_INCLUDED
#define CTRAINGROUPTEMPLATE_H_INCLUDED

#include "CWindowCtrl.h"
#include "CListView.h"
#include "CPlugin.h"

class CTrainPlugin;
class CTrainGroup;

/*
 *	qev[g
 *
 *	XCb`tqvOC|C^
 */
class CTrainTemplate{
	friend class CTrainGroupTemplate;
private:
	bool m_Reverse;					//	]tO
	vector<int> m_SwitchOption;		//	XCb`ݒl
	string m_TrainID;				//	q ID
	CTrainPlugin *m_TrainPlugin;	//	qvOC
public:
	CTrainTemplate(){
		Init(NULL, false, R2L(vector<int>()));
	}
	CTrainTemplate(const CTrainTemplate &rhs){
		Init(rhs.m_TrainPlugin, rhs.m_Reverse, R2L(vector<int>(rhs.m_SwitchOption)));
		m_TrainID = rhs.m_TrainID;
	}
	CTrainTemplate(CTrainPlugin *tpi, bool turn, vector<int> &sopt){
		Init(tpi, turn, sopt);
	}
	void Init(CTrainPlugin *, bool, vector<int> &);
	char *Read(char *);
	void Save(FILE *);
	void LoadTrainPlugin();
	void AddToGroup(CTrainGroup *);
};

//	q
typedef list<CTrainTemplate>::iterator ITrainTemplate;

/*
 *	Ґev[g
 */
class CTrainGroupTemplate: public CPlugin{
private:
	list<CTrainTemplate> m_TrainList;	//	qXg
	CTreeFileElement *m_TreeElement;	//	c[vf
public:
	CTrainGroupTemplate(char *);
	void PushTrain(CTrainTemplate &t){ m_TrainList.push_back(t); }
	void SetLoaded(){ m_State = 2; }
	char *DirName(){ return "TrainGroupTemplate"; }
	char *TextName2(){ return FlashIn("%s.txt", m_Name.c_str()); }
	char *SaveString(){ return GetName(); }
	bool PreLoadTGT(FILE *);
	bool Load();
	void Save(FILE *);
	string &GetNameRef(){ return m_Name; }
	CTreeFileElement *GetTreeElement(){ return m_TreeElement; }
	void SetTreeElement(CTreeFileElement *);
	bool IsRenamable(){ return true; }
	bool ConfirmRename(string &);
	bool IsDeletable();
	void DeleteFromTree();
	bool DeleteFromDisk();
	bool Rename(string &);
	void AddToGroup(CTrainGroup *);
	void SetPreview();
};

//	q
typedef list<CTrainGroupTemplate>::iterator ITrainGroupTemplate;

//	֐錾
void LoadTrainGroupTemplateList();
ITrainGroupTemplate FindTrainGroupTemplate(CTrainGroupTemplate *);
ITrainGroupTemplate FindTrainGroupTemplate(string);
void SetTemplateMenu(CPopMenu *, CTrainGroupTemplate *, CListElement *);
CMenuCommand *MakeGroupSaver(CTrainGroup *);
void AddTrainGroupTemplate();
void ListTrainGroupTemplate();
void ModalFuncTrainGroupTemplate();

//	OO[o
extern CTrainGroupTemplate *g_TrainGroupTemplate;
extern list<CTrainGroupTemplate> g_TrainGroupTemplateList;

#endif
