#ifndef CTRAINPLUGIN_H_INCLUDED
#define CTRAINPLUGIN_H_INCLUDED

#include "CModelPlugin.h"
#include "CTrainSetBuffer.h"

/*
 *	IuWFNgWCg ZY w
 */
class CObjectJointZY: public CObjectJoint{
public:
	VEC2 m_AttachCoord;	//	ڑ惍[J ZY W
	VEC2 m_LocalCoord;	//	[J ZY W
public:
	char *Read(char *, CModelPlugin *);
	VEC3 GetPos(){
		VEC3 ret(0.0f, m_AttachCoord.y, m_AttachCoord.x);
		CObject *obj = m_Link->GetObject();
		return *D3DXVec3TransformCoord(
			&ret, &(ret/obj->GetScale()), &obj->GetMatrix());
	}
	VEC3 GetRight(){
		CObject *obj = m_Link->GetObject();
		return m_Link->GetTurn() ? -obj->GetRight() : obj->GetRight();
	}
};

/*
 *	IuWFNgWCg ZY + X w
 */
class CObjectJointZYX: public CObjectJointZY{
public:
	float m_AttachX;	//	ڑ惍[J X W
public:
	char *Read(char *, CModelPlugin *);
	VEC3 GetPos(){
		VEC3 ret(m_AttachX, m_AttachCoord.y, m_AttachCoord.x);
		CObject *obj = m_Link->GetObject();
		return *D3DXVec3TransformCoord(
			&ret, &(ret/obj->GetScale()), &obj->GetMatrix());
	}
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ԏ
 */
class CAxleObject: public CNamedObject{
	friend class CAxlePosture;
	friend class CTrainPlugin;
private:
	int m_Symmetric;		//	Ώ̃JEg
	float m_Diameter;		//	a
	float m_MaxRotation;	//	t[]ʍől
	bool m_WheelSound;		//	ԗ։tO
	VEC2 m_Coord;			//	W
public:
	bool operator<(const CAxleObject &rhs) const{ return m_Coord.x<rhs.m_Coord.x; }
	virtual int GetType(){ return 1; }
	char *Read(char *, CModelPlugin *);
	float CalcRotation(float);
	void SetPreview(float, bool);
	void SetPosture(VEC3, VEC3, VEC3, float);
};

//	q
typedef list<CAxleObject>::iterator IAxleObject;

/*
 *	ԑ
 */
class CBodyObject: public CNamedObject{
	friend class CTrainPlugin;
private:
	static VEC3 ms_TiltDir;				//	UqxNg
	float m_TiltRatio;					//	UqW
	float m_TiltMaxAngle;				//	Uqőpx
	float m_TiltBaseAlt;				//	Uq
	CObjectJointZY m_Joint1, m_Joint2;	//	ڑ
public:
	static void SetTiltDir(VEC3 &td){ ms_TiltDir = td; }
	char *Read(char *, CModelPlugin *);
	void SetPosture();
};

//	q
typedef list<CBodyObject>::iterator IBodyObject;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	t[IuWFNgRei
 */
class CFreeObjectContainer{
private:
	CFreeObjectBase *m_FreeObject;	//	t[IuWFNg
public:
	CFreeObjectContainer();
	CFreeObjectContainer(const CFreeObjectContainer &);
	~CFreeObjectContainer();
	char *Read(char *, CModelPlugin *);
	void SetPosture(){ m_FreeObject->SetPostureFreeObject(); }
	CNamedObject *Check(const string &name){ return m_FreeObject->CheckFreeObject(name); }
	void LoadModel(CModelPlugin *mpi){ m_FreeObject->LoadModelFreeObject(mpi); }
	void AttachPartsObject(){ m_FreeObject->AttachPartsFreeObject(); }
	void ScanInput(){ m_FreeObject->ScanInputFreeObject(); }
	void Render(){ m_FreeObject->RenderFreeObject(); }
};

//	q
typedef list<CFreeObjectContainer>::iterator IFreeObjectContainer;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	2 _zu
 */
class CFreeObjectZY: public CNamedObject, public CFreeObjectBase{
	friend class CTrainPlugin;
private:
	float m_FixPosition;				//	pos Œʒu
	float m_FixRight;					//	right Œʒu
	CObjectJointZYX m_Joint1, m_Joint2;	//	ڑ
public:
	CFreeObjectBase *Duplicate(){ return new CFreeObjectZY(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureFreeObject();
	CNamedObject *CheckFreeObject(const string &name){ return Check(name); }
	void LoadModelFreeObject(CModelPlugin *mpi){ LoadModel(mpi); }
	void AttachPartsFreeObject(){ GetPartsObject(); }
	void ScanInputFreeObject(){ CheckDetect(); }
	void RenderFreeObject(){ Render(); }
};

/*
 *	Op`
 */
class CTriangleLinkZY: public CNamedObject{
	friend class CFreeTriangleZY;
	friend class CFreeCrankZY;
	friend class CFreePistonZY;
private:
	VEC2 m_LinkCoord;			//	Op`NW
	CObjectJointZYX m_Joint;	//	ڑ
public:
	char *Read(char *, CModelPlugin *);
};

/*
 *	Op`IuWFNg
 */
class CFreeTriangleZY: public CFreeObjectBase{
	friend class CTrainPlugin;
private:
	CTriangleLinkZY m_Link1, m_Link2;	//	
public:
	CFreeObjectBase *Duplicate(){ return new CFreeTriangleZY(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureFreeObject();
	CNamedObject *CheckFreeObject(const string &name){
		return m_Link1.Check(name) ? &m_Link1
			: (m_Link2.Check(name) ? &m_Link2 : NULL);
	}
	void LoadModelFreeObject(CModelPlugin *mpi){
		m_Link1.LoadModel(mpi); m_Link2.LoadModel(mpi);
	}
	void AttachPartsFreeObject(){ m_Link1.GetPartsObject(); m_Link2.GetPartsObject(); }
	void ScanInputFreeObject(){ m_Link1.CheckDetect(); m_Link2.CheckDetect(); }
	void RenderFreeObject(){ m_Link1.Render(); m_Link2.Render(); }
};

/*
 *	sXgXC_
 */
class CCrankSlideZY: public CNamedObject{
	friend class CFreeCrankZY;
private:
	VEC2 m_Direction;			//	Op`NW
	CObjectJointZYX m_Joint;	//	ڑ
public:
	char *Read(char *, CModelPlugin *);
};

/*
 *	sXgIuWFNg
 */
class CFreeCrankZY: public CFreeObjectBase{
	friend class CTrainPlugin;
private:
	CTriangleLinkZY m_Link;	//	
	CCrankSlideZY m_Slide;	//	XC_
public:
	CFreeObjectBase *Duplicate(){ return new CFreeCrankZY(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureFreeObject();
	CNamedObject *CheckFreeObject(const string &name){
		return m_Link.Check(name) ? (CNamedObject *)&m_Link
			: (m_Slide.Check(name) ? (CNamedObject *)&m_Slide : NULL);
	}
	void LoadModelFreeObject(CModelPlugin *mpi){
		m_Link.LoadModel(mpi); m_Slide.LoadModel(mpi);
	}
	void AttachPartsFreeObject(){ m_Link.GetPartsObject(); m_Slide.GetPartsObject(); }
	void ScanInputFreeObject(){ m_Link.CheckDetect(); m_Slide.CheckDetect(); }
	void RenderFreeObject(){ m_Link.Render(); m_Slide.Render(); }
};

/*
 *	sXgIuWFNg
 */
class CFreePistonZY: public CFreeObjectBase{
	friend class CTrainPlugin;
private:
	CTriangleLinkZY m_Link1, m_Link2;	//	
public:
	CFreeObjectBase *Duplicate(){ return new CFreePistonZY(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureFreeObject();
	CNamedObject *CheckFreeObject(const string &name){
		return m_Link1.Check(name) ? &m_Link1
			: (m_Link2.Check(name) ? &m_Link2 : NULL);
	}
	void LoadModelFreeObject(CModelPlugin *mpi){
		m_Link1.LoadModel(mpi); m_Link2.LoadModel(mpi);
	}
	void AttachPartsFreeObject(){ m_Link1.GetPartsObject(); m_Link2.GetPartsObject(); }
	void ScanInputFreeObject(){ m_Link1.CheckDetect(); m_Link2.CheckDetect(); }
	void RenderFreeObject(){ m_Link1.Render(); m_Link2.Render(); }
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	qvOC
 */
class CTrainPlugin: public CModelPlugin{
	friend class CTrain;
	friend class CTrainGroup;
private:
	float m_FrontLimit;							//	OAʒu
	float m_TailLimit;							//	㕔Aʒu
	float m_Length;								//	
	float m_MaxVelocity;						//	ōx
	float m_MaxAcceleration;					//	ōx
	float m_MaxDeceleration;					//	ōx
	float m_TiltSpeed;							//	Uq쑬x
	float m_DoorClosingTime;					//	hAߏv
	list<CAxleObject> m_AxleObject;				//	Ԏ
	list<CBodyObject> m_BodyObject;				//	ԑ
	list<CFreeObjectContainer> m_FreeObject;	//	t[IuWFNg
	CObjectJoint3D m_FrontCabin;				//	O^]Ȉʒu
	CObjectJoint3D m_TailCabin;					//	㕔^]Ȉʒu
public:
	static void RenderPreview();
	CTrainPlugin(char *id): CModelPlugin(id){}
	~CTrainPlugin();
	char *DirName(){ return "Train"; }
	char *TextName(){ return "Train.txt"; }
	char *TextName2(){ return "Train2.txt"; }
	bool Load();
	bool LoadOldForm();
	void SetPreview();
	void Preview(float, bool);
	CNamedObject *FindObject(const string &);
	bool IsSoundEnabled();
	void SetAxleList(CTrain *);
	void SetPosture();
	void AttachPartsObject();
	void ScanInput(CTrain *);
	void Render(CTrain *);
	void Simulate(CTrain *);
	CPLUGIN_CASTFUNC(CTrainPlugin);
};

/*
 *	qvOCXg
 */
class CTrainPluginList: public CModelPluginList{
private:
public:
	char *DirName(){ return "Train"; }
	char *TextName(){ return "Train.txt"; }
	char *TextName2(){ return "Train2.txt"; }
	char *Default(){ return "Aizentranza01"; }
	CPlugin *NewEntry(char *id){ return new CTrainPlugin(id); }
	CPLUGINLIST_CASTFUNC(CTrainPlugin);
};

//	OO[o
extern CTrainPlugin *g_Train;
extern CTrainPluginList *g_TrainPluginList;

#endif
