//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "graphic.h"
#include "font.h"

/*
 *	tHg쐬
 *
 *	size	: cTCY
 *	c		: F
 *	weight	: (FW_NORMAL, FW_BOLD, FW_HEAVY...)
 */
void CreateFont(int size, D3DCOLOR c, LONG weight){
	FreeFont();

	LOGFONT logFont = {
		size, 0, 0, 0,
		weight,
		FALSE, FALSE, FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY,
		DEFAULT_PITCH|FF_DONTCARE,
		"lr SVbN"
	};

	D3DXCreateFontIndirect(sv3.pDev, &logFont, &svf.pFont);
	svf.size = size;
	svf.color = c;
}

/*
 *	tHg
 */
void FreeFont(){
	RELEASE(svf.pFont);
}

/*
 *	tHggpJn
 */
void BeginFont(){
	svf.pFont->Begin();
}

/*
 *	tHggpI
 */
void EndFont(){
	svf.pFont->End();
}

/*
 *	eLXg`
 *
 *	x	: X W
 *	y	: Y W
 *	str	: 
 *
 *	ׂ̂ł܂pɂɎgpȂ悤ɁB
 *	ÓIȕ̕`CTexture: :CreateText()𗘗pgB
 */
void Text(int x, int y, D3DCOLOR c, const char *str){
	RECT rect = {x, y, sv3.width, sv3.height};

	svf.color = c;
	svf.pFont->DrawTextA(str, -1, &rect, DT_LEFT|DT_EXPANDTABS|DT_NOPREFIX, svf.color);
}

/*
 *	eLXg`itj
 *
 *	x	: X W
 *	y	: Y W
 *	str	: 
 */
void TextF(int x, int y, D3DCOLOR c, const char *str, ...){
	char buf[4096];

	va_list	vl;

	va_start(vl, str);
	vsprintf(buf, str, vl);
	va_end(vl);

	Text(x, y, c, buf);
}
