//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "window.h"
#include "graphic.h"
#include "input.h"
#include "wave_stream.h"

unsigned int __stdcall InputPollingThread(void* lpThreadParameter);
void InputPollOnce();

CCrtThread g_InputPollingThread;

bool g_FinishInputThread = false;
int g_InputPollCount = 0;
CRITICAL_SECTION g_InputPollCriticalSection;

/*
 *	DirectInput̏
 */
BOOL InitDirectInput(){
	DebugHL();
	Debug("InitDirectInput\n");

	FAILED_ASSERT(
		"DirectInputł܂ł.",
		DirectInput8Create(
			GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput8,
			(void **)&svi.pDI, NULL
		));
	if(!InitKeyboard()) return FALSE;
	if(!InitMouse()) return FALSE;
	if(!InitJoyStick()) return FALSE;
	FlushInputDevice();
	InitializeCriticalSection(&g_InputPollCriticalSection);
	g_InputPollingThread.begin(InputPollingThread, NULL);
	//SetThreadPriority(g_InputPollingThread.getHandle(), THREAD_PRIORITY_ABOVE_NORMAL);
	SetThreadPriority(g_InputPollingThread.getHandle(), THREAD_PRIORITY_HIGHEST);

	return TRUE;
}

/*
 *	DirectInput̉
 */
void FreeDirectInput(){
	if(!svi.pDI) return;

	DebugHL();
	Debug("FreeInput\n");

	g_FinishInputThread = true;
	g_InputPollingThread.end();
	DeleteCriticalSection(&g_InputPollCriticalSection);
	FreeJoyStick();
	FreeMouse();
	FreeKeyboard();

	RELEASE(svi.pDI);
}

/*
 *	L[{[h̏
 */
BOOL InitKeyboard(){
	//	foCX쐬
	FAILED_ASSERT(
		"L[{[hfoCX쐬ł܂.",
		svi.pDI->CreateDevice(GUID_SysKeyboard, &svi.pKey, NULL));

	//	̓f[^tH[}bgw
	FAILED_ASSERT(
		"L[{[htH[}bgݒł܂.",
		svi.pKey->SetDataFormat(&c_dfDIKeyboard));

	//	xw
	FAILED_ASSERT(
		"L[{[h̋xݒł܂.",
		svi.pKey->SetCooperativeLevel(svw.hWnd, DISCL_BACKGROUND|DISCL_NONEXCLUSIVE));

	//	ANZX𓾂
	svi.pKey->Acquire();

	//	IL[̐ݒ
	//SetExitKey(DIK_F9);

	return TRUE;
}

/*
 *	L[{[h̉
 */
void FreeKeyboard(){
	if(svi.pKey) svi.pKey->Unacquire();
	RELEASE(svi.pKey);
}

/*
 *	}EX̏
 */
BOOL InitMouse(){
	FAILED_ASSERT(
		"}EXfoCX쐬ł܂.",
		svi.pDI->CreateDevice(GUID_SysMouse, &svi.pMouse, NULL));

	FAILED_ASSERT(
		"L[{[htH[}bgݒł܂.",
		svi.pMouse->SetDataFormat(&c_dfDIMouse));

	FAILED_ASSERT(
		"}EX̋xݒł܂.",
		svi.pMouse->SetCooperativeLevel(svw.hWnd, DISCL_BACKGROUND|DISCL_NONEXCLUSIVE));

	svi.pMouse->Acquire();

	//	tXN[̓J[\\
	/*if(!sv3.fWindowed)*/ ShowCursor(FALSE);

	//	J[\Z^O
	SetCursor(svw.winW/2, svw.winH/2);

	return TRUE;
}

/*
 *	}EX̉
 */
void FreeMouse(){
	if(svi.pMouse) svi.pMouse->Unacquire();
	RELEASE(svi.pMouse);
}

/*
 *	WCXeBbN̏
 */
BOOL InitJoyStick(){
	//	foCX̗
	svi.numJoy = 0;

	svi.pDI->EnumDevices(
		DI8DEVCLASS_GAMECTRL, EnumJoyCallback, NULL, DIEDFL_ATTACHEDONLY);

	if(svi.numJoy==0) return TRUE;	//	Ȃd
	else Debug("WCXeBbN = %d\n", svi.numJoy);

	HRESULT hr;

	for(int i = 0; i<svi.numJoy; i++){
		hr = svi.pJoy[i]->SetDataFormat(&c_dfDIJoystick2);

		if(hr!=DI_OK){
			Debug("WCXeBbN[%d]̃tH[}bgwł܂.\n", i);
			continue;
		}
		hr = svi.pJoy[i]->SetCooperativeLevel(
			svw.hWnd, DISCL_BACKGROUND|DISCL_NONEXCLUSIVE);

		if(hr!=DI_OK){
			Debug("WCXeBbN[%d]̋xݒł܂.\n", i);
			continue;
		}

		//	͈͂̎w
		hr = svi.pJoy[i]->EnumObjects(EnumAxisCallback, (VOID *)i, DIDFT_AXIS);

		if(hr!=DI_OK){
			Debug("WCXeBbN[%d]̗̎񋓂ł܂.\n", i);
			continue;
		}

		svi.pJoy[i]->Acquire();
	}
	return TRUE;
}

/*
 *	WCXeBbN̉
 */
void FreeJoyStick(){
	for(int i = 0; i<svi.numJoy; i++){
		if(svi.pJoy[i]) svi.pJoy[i]->Unacquire();
		RELEASE(svi.pJoy[i]);
	}
}

/*
 *	WCXeBbN񋓎̃R[obN
 */
BOOL CALLBACK EnumJoyCallback(const DIDEVICEINSTANCE *pInst, VOID *pContext){
	HRESULT hr = svi.pDI->CreateDevice(
		pInst->guidInstance, &svi.pJoy[svi.numJoy], NULL);

	if(hr!=DI_OK){
		Debug("WCXeBbN[%d]ł܂.\n", svi.numJoy);
	}
	if(++svi.numJoy==MAX_JOYSTICK) return DIENUM_STOP;

	return DIENUM_CONTINUE;
}

/*
 *	WCXeBbN񋓎̃R[obN
 */
BOOL CALLBACK EnumAxisCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef){
	int i = (int)pvRef;

	DIPROPRANGE diprg;

	diprg.diph.dwSize = sizeof(DIPROPRANGE);
	diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diprg.diph.dwHow = DIPH_BYID;
	diprg.diph.dwObj = lpddoi->dwType;
	diprg.lMin = -1000;
	diprg.lMax = +1000;

	svi.pJoy[i]->SetProperty(DIPROP_RANGE, &diprg.diph);

	return DIENUM_CONTINUE;
}

/*
 *	̓foCX̃XL
 */
void ScanInputDevice(){
	EnterCriticalSection(&g_InputPollCriticalSection);
	
	if(!g_InputPollCount){
		InputPollOnce();
		//static int once = 0;
		//char *FlashIn(char *, ...);
		//SetWindowText(svw.hWnd, FlashIn("input poll skip %d", ++once));
	}
	g_InputPollCount = 0;

	ScanKeyboard();
	ScanMouse();
	ScanJoyStick();

	//	IL[
	//if(svi.key[svi.exitKey]&0x80) SendWM_CLOSE();

	LeaveCriticalSection(&g_InputPollCriticalSection);
}

/*
 *	̓obt@NA
 */
void FlushInputDevice(){
	memset(svi.key, 0, sizeof(svi.key));
	memset(svi.keyPoll, 0, sizeof(svi.keyPoll));
	memset(svi.keyOld, 0, sizeof(svi.keyOld));

	memset(svi.btn, 0, sizeof(svi.btn));
	memset(svi.btnPoll, 0, sizeof(svi.btnPoll));
	memset(svi.btnOld, 0, sizeof(svi.btnOld));

	memset(svi.joy, 0, sizeof(svi.joy));
	memset(svi.joyOld, 0, sizeof(svi.joyOld));

	svi.wheel = svi.wheelPoll = 0;
}

void InputPollOnce(){
	int i;
	BYTE keyTemp[256];
	HRESULT hr;

	//	foCX̏Ԃ𓾂
	hr = svi.pKey->GetDeviceState(sizeof(keyTemp), &keyTemp);
	if(FAILED(hr)){
		memset(svi.key, 0, 256);	//	NA
		//	ANZXĎ擾
		if(hr==DIERR_INPUTLOST) {
			Debug("L[{[h̃ANZX܂.\n");
			svi.pKey->Acquire();
		}
	}else{
		for(i = 0; i<256; ++i) svi.keyPoll[i] |= keyTemp[i];
	}

	//	NbŇo
	DIMOUSESTATE ms;
	hr = svi.pMouse->GetDeviceState(sizeof(ms), &ms);
	if(hr==DIERR_INPUTLOST){
		Debug("}EX̃ANZX܂.\n");
		svi.pMouse->Acquire();
	}else{
		svi.wheelPoll += ms.lZ;
		for(i = 0; i<4; ++i) svi.btnPoll[i] |= ms.rgbButtons[i];
	}
	++g_InputPollCount;
}

/*
 *	DirectInput̏
 */
unsigned int __stdcall InputPollingThread(void* lpThreadParameter){
	while(!g_FinishInputThread){
		while(!svw.fActive) Sleep(100);
		Sleep(10);
		EnterCriticalSection(&g_InputPollCriticalSection);
		InputPollOnce();
		LeaveCriticalSection(&g_InputPollCriticalSection);
	}
	//Dialog("manual finish");
	return 0;
}

/*
 *	L[{[h̃XL
 */
void ScanKeyboard(){
	//	ȌԂۑ
	memcpy(svi.keyOld, svi.key, 256);
	memcpy(svi.key, svi.keyPoll, 256);
	memset(svi.keyPoll, 0, sizeof(svi.key));
}

POINT GetCursorPosClient(){
	POINT cur;
	GetCursorPos(&cur);
	//	EChE[h͍Wnϊ
	if(sv3.fWindowed) ScreenToClient(svw.hWnd, &cur);
	return cur;
}

/*
 *	}EX̃XL
 */
void ScanMouse(){
	//	J[\ʒǔo

	//	DirectInput͍W̃}bsO܂łȂ߁A
	//	J[\ʒǔoɂ Win32 API gpB
	svi.cur = GetCursorPosClient();

	//	EChE
	if(sv3.fWindowed){
		svi.inside = 0<=svi.cur.x && svi.cur.x<svw.winW
			&& 0<=svi.cur.y && svi.cur.y<svw.winH ? TRUE : FALSE;
	}else{
		svi.inside = TRUE;
	}

	//	ȌԂۑ
	memcpy(svi.btnOld, svi.btn, 4);
	memcpy(svi.btn, svi.btnPoll, 4);
	memset(svi.btnPoll, 0, sizeof(svi.btnPoll));

	svi.wheel = svi.wheelPoll;
	svi.wheelPoll = 0;
}

/*
 *	WCXeBbÑXL
 */
void ScanJoyStick(){
	if(!svi.fJoy) return;

	//	ȌԂۑ
	memcpy(svi.joyOld, svi.joy, MAX_JOYSTICK*(MAX_BUTTON+6));

	HRESULT hr;
	DIJOYSTATE2 js;

	for(int i = 0; i<svi.numJoy; i++){
		hr = svi.pJoy[i]->Poll();

		if(hr==DIERR_INPUTLOST){
			Debug("WCXeBbN[%d]̃ANZX܂.\n", i);
			svi.pMouse->Acquire();
			continue;
		}

		hr = svi.pJoy[i]->GetDeviceState(sizeof(DIJOYSTATE2), &js);

		if(hr!=DI_OK){
			Debug("WCXeBbN[%d]̏Ԃ擾ł܂.\n", i);
			continue;
		}

		memset(&svi.joy[i][0], 0, 6);

		if(js.lY<-500)		svi.joy[i][DIJ_UP	] = 0x80;
		else if(js.lY>500)	svi.joy[i][DIJ_DOWN ] = 0x80;

		if(js.lX<-500)		svi.joy[i][DIJ_LEFT ] = 0x80;
		else if(js.lX>500)	svi.joy[i][DIJ_RIGHT ] = 0x80;

		if(js.lZ<-500)		svi.joy[i][DIJ_TOP ] = 0x80;
		else if(js.lZ>500)	svi.joy[i][DIJ_BOTTOM] = 0x80;

		memcpy(&svi.joy[i][6], js.rgbButtons, MAX_BUTTON);
	}
}

/*
 *	L[̏Ԏ擾
 *
 *	id	: DIK_UP, DIK_SPACE Ȃ
 */
int GetKey(int id){
	return ((svi.key[id]&0x80)>>6)|((svi.keyOld[id]&0x80)>>7);
}

/*
 *	ǂꂩL[ꂽiuԁj𔻒
 *	ꂽuԂȂΉĂ̂Ԃ
 */
int CheckKeyDown(){
	int i, s, t = -1;
	for(i = 0; i<256; i++){
		//	ŏɌoL[Ԃ
		s = GetKey(i);
		if(s==S_PUSH) return i;
		if(t<0 && s>S_PUSH) t = i;
	}
	return t;
}

/*
 *	L[obt@̃NA
 */
void FlushKey(){
	memset(svi.key, 0, sizeof(svi.key));
}

/*
 *	ꂽL[擾
 */
int DequeueChar(){
	if(!svi.charKey.size()) return 0;
	int key = *svi.charKey.begin();
	svi.charKey.pop_front();
	return key;
}

/*
 *	WM_CHARbZ[Wւ̃nh
 */
void OnChar(WPARAM wParam){
	svi.charKey.push_back((TCHAR)wParam);
}

/*
 *	IL[̐ݒ
 *
 *	id	: L[ID
 */
void SetExitKey(int id){
	svi.exitKey = id;
}

/*
 *	}EX{^̏Ԏ擾
 *
 *	id	: DIM_LEFT, DIM_RIGHT, DIM_MIDDLE
 */
int GetButton(int id){
	return ((svi.btn[id]&0x80)>>6)|((svi.btnOld[id]&0x80)>>7);
}

/*
 *	J[\W̎擾
 */
POINT GetCursorXY(){
	return svi.cur;
}

/*
 *	J[\XW̎擾
 */
int GetCursorX(){
	return svi.cur.x;
}

/*
 *	J[\YW̎擾
 */
int GetCursorY(){
	return svi.cur.y;
}

/*
 *	J[\EBhEׂ
 */
BOOL IsCursorInside(){
	return svi.inside;
}

/*
 *	zC[ʒu̎擾
 */
LONG GetWheel(){
	return svi.wheel;
}

/*
 *	J[\W̐ݒ
 *
 *	x, y	FEChEW
 */
void SetCursor(int x, int y){
	POINT cur = {x, y};

	//	EChE[h͍Wnϊ
	if(sv3.fWindowed) ClientToScreen(svw.hWnd, &cur);

	SetCursorPos(cur.x, cur.y);
}

/*
 *	WCXeBbNgp̗Lw
 *
 *	f		: TRUELɂAFALSEɂ
 */
void EnableJoyStick(BOOL f){
	svi.fJoy = f;

	if(!f) memset(svi.joy, FALSE, sizeof(svi.joy));
}

/*
 *	WCXeBbN{^̏Ԏ擾
 *
 *	n		: WCXeBbNID
 *	id	: DIJ_UP, DIJ_BT1 Ȃ
 */
int GetJoy(int n, int id){
	return ((svi.joy[n][id]&0x80)>>6)|((svi.joyOld[n][id]&0x80)>>7);
}

/*
 *	bZ[W{bNX\
 */
void MsgBox(char *msg){
	MessageBox(svw.hWnd, msg, "", MB_OK);
	FlushInputDevice();
}

/*
 *	bZ[W{bNX\(Yes/No)
 *
 *	msg	: 
 */
int MsgYesNo(char *msg){
	int ret = MessageBox(
		svw.hWnd, msg, "", MB_YESNO|MB_SYSTEMMODAL|MB_ICONQUESTION);
	FlushInputDevice();
	return ret==IDYES;
}
