//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "graphic.h"
#include "vertex.h"

/*
 *	Rp`̖@xNgvZ
 */
void CalcNormal(VEC3 t[3], VEC3 *n){
	VEC3 u = t[1]-t[0];
	VEC3 v = t[2]-t[0];
	VEC3 tmp;

	D3DXVec3Cross(&tmp, &u, &v); 
	D3DXVec3Normalize(n, &tmp);
}

/*
 *	VTX_LXɋ`gCAOXgŃZbg
 *
 *	vt		: _e[ũAhX
 *	x1, y1	: n_
 *	x2, y2	: I_
 */
void SetRectTL_LX(VTX_LX *vt, int x1, int y1, int x2, int y2, int z, D3DCOLOR c){
	SetVTX_LX(vt , x1, y1, z, c, 0, 1);
	SetVTX_LX(vt+1, x1, y2, z, c, 0, 0);
	SetVTX_LX(vt+2, x2, y1, z, c, 1, 1);
	SetVTX_LX(vt+3, x2, y2, z, c, 1, 0);
	SetVTX_LX(vt+4, x2, y1, z, c, 1, 1);
	SetVTX_LX(vt+5, x1, y2, z, c, 0, 0);
}

/*
 *	RXgN^
 */
CVertex::CVertex(){
	m_pVB = NULL;
	m_fvf = 0;
	m_stride = 0;
	m_num = 0;
}

/*
 *	fXgN^
 */
CVertex::~CVertex(){
	Free();
}

/*
 *	_obt@쐬
 *
 *	pSrc	: _i[ꂽz
 *	fvf		: _tH[}bg
 *	size	: z̃TCY
 */
BOOL CVertex::Create(LPVOID pSrc, DWORD fvf, UINT size){
	HRESULT hr;

	Free();	//	Ȃobt@
	m_fvf = fvf;

	switch(m_fvf){
	case FVF_TL:	m_stride = sizeof(VTX_TL);	m_num = size/sizeof(VTX_TL);	break;
	case FVF_TLX:	m_stride = sizeof(VTX_TLX);	m_num = size/sizeof(VTX_TLX);	break;
	case FVF_L:		m_stride = sizeof(VTX_L);	m_num = size/sizeof(VTX_L);		break;
	case FVF_LX:	m_stride = sizeof(VTX_LX);	m_num = size/sizeof(VTX_LX);	break;
	case FVF_LX2:	m_stride = sizeof(VTX_LX2);	m_num = size/sizeof(VTX_LX2);	break;
	case FVF_N:		m_stride = sizeof(VTX_N);	m_num = size/sizeof(VTX_N);		break;
	case FVF_NX:	m_stride = sizeof(VTX_NX);	m_num = size/sizeof(VTX_NX);	break;
	case FVF_NX2:	m_stride = sizeof(VTX_NX2);	m_num = size/sizeof(VTX_NX2);	break;
	default:		return FALSE;
	}	//	D3DXGetFVFVertexSize()

	//	obt@̍쐬
	hr = sv3.pDev->CreateVertexBuffer(
		size, 0, fvf, D3DPOOL_MANAGED, &m_pVB);
	if(FAILED(hr)) return FALSE;

	//	bNď
	LPVOID pDst;

	hr = m_pVB->Lock(0, size, (BYTE **)&pDst, 0);

	if(FAILED(hr)) return FALSE;

	memcpy(pDst, pSrc, size);
	m_pVB->Unlock();

	return TRUE;
}

/*
 *	_obt@
 */
void CVertex::Free(){
	RELEASE(m_pVB);
}

/*
 *	_obt@bN
 *
 *	bN͕KAbN邱ƁB
 */
BOOL CVertex::Lock(LPVOID *ppBuf){
	if(FAILED(m_pVB->Lock(0, 0/*S*/, (BYTE **)ppBuf, 0)))
		return FALSE;
	else
		return TRUE;
}

/*
 *	_obt@AbN
 */
void CVertex::Unlock(){
	m_pVB->Unlock();
}

/*
 *	ȉ̃\bh̓CgA}eAAeNX`A[h}gNX
 *	e󂯂܂B
 *	
 *	BeBOςݒ_gpꍇ̓CeBO𖳌ɂĂA
 *	eNX`Ȃ_gpꍇ̓eNX`NULLɂĂsĂB
 */
/*
 *	|CgXg
 */
void CVertex::RenderPL(){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(D3DPT_POINTLIST, 0, m_num);
}

/*
 *	CXg
 */
void CVertex::RenderLL(){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(D3DPT_LINELIST, 0, m_num/2);
}

/*
 *	CXgbv
 *
 *	count	: ̐
 */
void CVertex::RenderLS(UINT count){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(D3DPT_LINESTRIP, 0, count);
}

/*
 *	gCAOXg
 */
void CVertex::RenderTL(){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(D3DPT_TRIANGLELIST, 0, m_num/3);
}

/*
 *	gCAOXgbv
 *
 *	count	: 3p`̐
 */
void CVertex::RenderTS(UINT count){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, count);
}

/*
 *	gCAOt@
 *
 *	count	: 3p`̐
 */
void CVertex::RenderTF(UINT count){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(D3DPT_TRIANGLEFAN, 0, count);
}

/*
 *	^Cvw
 *
 *	type	: v~eBu^Cv
 *	count	: 3p`̐
 */
void CVertex::Render(PRIMTYPE type, UINT count){
	sv3.pDev->SetStreamSource(0, m_pVB, m_stride);
	sv3.pDev->SetVertexShader(m_fvf);
	sv3.pDev->DrawPrimitive(type, 0, count);
}
