//	Copyright (c) 2002 Midikyou

#include <windows.h>
#include <windowsx.h>

#include "headers.h"
#include "debug.h"
#include "graphic.h"	//	sv3.fWindowes
#include "window.h"

#if defined(__BORLANDC__)	//	for BC++
	#define IDI_ICON1 1001
#else
	#include "..\resource.h"
#endif

void AdjustMovieLayer();	//	movie.cpp

//	OO[o
extern int g_DispWidth;
extern int g_DispHeight;

/*
 *	CEChE̍쐬
 *
 *	hInst	: CX^Xnh
 */
BOOL CreateMainWindow(HINSTANCE hInst){
	//	EChENX̓o^
	WNDCLASSEX wc = {
		sizeof(WNDCLASSEX),	//	TCY
		0,					//	X^C
		MessageProc,		//	bZ[Wnh
		0L,					//	gNX
		0L,					//	gEChE
		hInst,				//	CX^Xnh
		LoadIcon(hInst, MAKEINTRESOURCE(IDI_ICON1)),	//	ACRw
		LoadCursor(NULL, IDC_ARROW),			//	WJ[\
		(HBRUSH)GetStockObject(BLACK_BRUSH),	//	EChẺn
		NULL,				//	j[Ȃ
		CLASSNAME,			//	EChENX
		NULL				//	X[ACRȂikĎgpj
	};
	RegisterClassEx(&wc);

	//	EChE̍쐬
	HWND hWnd = CreateWindow(
		CLASSNAME,			//	NX
		WINDOWNAME,			//	^Cg
		WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,	//	X^Cij
		//WS_OVERLAPPEDWINDOW,	//	X^Cij
		0,					//	\ʒu
		0,					//	
		g_DispWidth,		//	()
		g_DispHeight,		//	c()
		GetDesktopWindow(),	//	eEChEfXNgbv
		NULL,				//	j[iȂj
		wc.hInstance,		//	CX^X
		NULL				//	ǉp[^iȂj
	);
	if(!hWnd) return FALSE;

	//	O[oϐɑޔ
	svw.hWnd = hWnd;
	svw.winW = g_DispWidth;
	svw.winH = g_DispHeight;

	//	EChEglɂāATCYĐݒ
	AdjustWindow();

	//	ANeButO𗧂Ă
	svw.fActive = TRUE;

	return TRUE;
}

/*
 *	NCAg̈̃TCYɃEChETCY
 */
void AdjustWindow(){
	RECT r = {0, 0, svw.winW, svw.winH}, d;
	GetWindowRect(GetDesktopWindow(), &d);
	AdjustWindowRectEx(
		&r,
		GetWindowStyle(svw.hWnd),
		!!GetMenu(svw.hWnd),
		GetWindowExStyle(svw.hWnd));
	int dw = d.right-d.left, dh = d.bottom-d.top;
	int cw = r.right-r.left, ch = r.bottom-r.top;
	SetWindowPos(
		svw.hWnd, NULL, (dw-cw)/2, (dh-ch)/2, cw, ch,
		SWP_NOZORDER|SWP_NOACTIVATE);
}

/*
 *	bZ[W
 */
BOOL PeekAllMessage(){
	static MSG msg;

	//	ɂȂ܂Ń[v
	while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
		//	IbZ[WH
		if(msg.message==WM_QUIT) return FALSE;

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return TRUE;
}

/*
 *	EChEbZ[W
 *
 *	̐ȗ
 */
LRESULT WINAPI MessageProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam){
	switch(msg){
	//	ANeBu^ANeBu؂ւ
	case WM_ACTIVATEAPP:
		OnActivateApp(wParam);
		break;

	//	TCYύXꂽ
	case WM_SIZE:
		OnSize(wParam);
		break;

	//	ړ
	case WM_MOVE:
		OnMove(wParam);
		break;

	//	fBXvC[hύXꂽ
	case WM_DISPLAYCHANGE:
		Debug("<fBXvC[h̕ύX>\n");
		break;

	//	ĕ`v
	case WM_PAINT:
		OnPaint(wParam);
		break;

	//	VXebZ[W
	case WM_SYSCOMMAND:
		//	XN[Z[o[̔j~
		if(wParam==SC_SCREENSAVE || wParam==SC_MONITORPOWER) return 1;
		else return DefWindowProc(hWnd, msg, wParam, lParam);

	//	IMEEChEN
	case WM_IME_SETCONTEXT:
		//	FEP(IME)̃EChEIɕ
		SendMessage(ImmGetDefaultIMEWnd(hWnd), WM_CLOSE, 0, 0);
		break;

	//	L[ꂽ
	case WM_CHAR:
		OnChar(wParam);	//	input.cpp
		break;

	//	Disable Alt & F10
	case WM_SYSKEYDOWN:
		break;

	//	DirectShowbZ[W
#ifdef UDX_USE_MOVIE
	case WM_GRAPHNOTIFY:
		OnGrapNotify();	//	movie.cpp
		break;
#endif // #ifdef UDX_USE_MOVIE

	//	EChE悤Ƃ
	case WM_CLOSE:
		//	DestoryWindow()Direct3D̉ɍs
		PostQuitMessage(0);
		break;

	//	c̓ftHg
	default:
		return DefWindowProc(hWnd, msg, wParam, lParam);
	}
	return 0;
}

/*
 *	ANeBuAANeBuւ̉
 */
void OnActivateApp(WPARAM wParam){
	svw.fActive = (BOOL)wParam;
	Debug(svw.fActive ? "<ANeBu>\n" : "<ANeBu>\n");
}

/*
 *	TCYύXւ̉
 */
void OnSize(WPARAM wParam){
	//	tXN[[hł̓TCYύXȂ
	if(!sv3.fWindowed) return;
	/*
	 *	9xnŃtXN[[hڍsOɃEChETCYύXA
	 *		EChETCY𑜓xȏɂȂ̂@
	 */

	//	NCAg̈TCY̎擾
	RECT rect;
	GetClientRect(svw.hWnd, &rect);

	svw.winW = rect.right-rect.left;
	svw.winH = rect.bottom-rect.top;

	Debug("<NCAg̈ %d x %d>\n", svw.winW, svw.winH);

#ifdef UDX_USE_MOVIE
	//	[r[C[̃TCY
	AdjustMovieLayer();
#endif // #ifdef UDX_USE_MOVIE
}

/*
 *	EChEړւ̉
 */
void OnMove(WPARAM wParam){
#ifdef UDX_USE_MOVIE
	//	[r[C[̈ړ
	AdjustMovieLayer();
#endif // #ifdef UDX_USE_MOVIE
}

/*
 *	ĕ`vւ̉
 */
void OnPaint(WPARAM wParam){
	//	荇̈NA
	PAINTSTRUCT ps;
	HDC hDC;

	hDC = BeginPaint(svw.hWnd, &ps);
	EndPaint(svw.hWnd, &ps);
}

/*
 *	EChE^Cg̐ݒ
 *
 *	str	: 
 */
void SetCaption(char *str){
	SetWindowText(svw.hWnd, str);
}

/*
 *	Iv
 *
 *	bZ[W܂ŃvO͏I܂B
 */
void SendWM_CLOSE(){
	SendMessage(svw.hWnd, WM_CLOSE, 0, 0);
}