﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;

namespace 電子文書toNextFolder
{
    public partial class Folder : Form
    {
        DataView dv;
        DataSet datasetInfoSave = new DataSet();
        public Folder()
        {
            InitializeComponent();

            //移動指示パラメータの読み込み
            dataSet1.Clear();
            try
            {
                dataSet1.ReadXml(Path.Combine( sequenceParameterFolder , "文書移動指示パラメータ.xml"));
            }
            catch (Exception)
            {
                MessageBox.Show("文書移動指示パラメータ.xmlが見つかりません。パラメータ登録し保存して下さい。", "エラー", MessageBoxButtons.OK);
            }
            if (dataSet1.Tables["フォルダ順序"] == null)
            {
                //無い場合、作る
                DataTable t = dataSet1.Tables.Add("フォルダ順序");
                t.Columns.Add().ColumnName = "文書種類";
                t.Columns.Add().ColumnName = "フォルダ";
                t.Columns.Add().ColumnName = "ID";
                t.Columns.Add().ColumnName = "移動先ID";
                t.Columns.Add().ColumnName = "オプション";
                t.Columns.Add().ColumnName = "コメント";
            }
            //ソートする
            dataSet1.Tables["フォルダ順序"].DefaultView.Sort = "文書種類 ASC,ID ASC";
            dv = dataSet1.Tables["フォルダ順序"].DefaultView;
            //グリッド表示
            this.dataGridView1.DataSource = dv;
            //手動でのソート操作を不可にする＆表示列順
            foreach (DataGridViewColumn c in dataGridView1.Columns)
            {
                c.SortMode = DataGridViewColumnSortMode.Programmatic;
                if(c.Name == "文書種類") c.DisplayIndex = 0;
                if(c.Name == "フォルダ") c.DisplayIndex = 1;
                if(c.Name == "ID") c.DisplayIndex = 2;
                if(c.Name == "移動先ID") c.DisplayIndex = 3;
                if(c.Name == "オプション") c.DisplayIndex = 4;
                if(c.Name == "コメント") c.DisplayIndex = 5;
            }

            //保存情報の読み込み
            try
            {
                datasetInfoSave.ReadXml(Path.Combine( parameterFolder,"TransToolInfoSave.xml"));
            }
            catch
            {
            }

            if (datasetInfoSave.Tables["設定情報"] != null)
            {
                chk確認msg.Checked = (datasetInfoSave.Tables["設定情報"].Rows[0][0].ToString() == "1" ? true : false);
                更新秒数updown.Value = Convert.ToDecimal(datasetInfoSave.Tables["設定情報"].Rows[0][2]);
            }
            else
            {
                //無い場合、作る
                DataTable newtable = new DataTable("設定情報");
                datasetInfoSave.Tables.Add(newtable);
                DataRow newrow = newtable.NewRow();
                newtable.Rows.Add(newrow);
                newtable.Columns.Add("確認msg");
                newtable.Columns.Add("エクスプローラClose");
                newtable.Columns.Add("予備2");
                newrow["確認msg"] = "0";
                newrow["エクスプローラClose"] = "0";
                newrow["予備2"] = "0";
            }
        }

        //構成情報入手
        public static string parameterFolder;
        public static string sequenceParameterFolder;
        static public void 構成入手(out string server, out int port)
        {
            DataSet datasetcommon = new DataSet();
            try
            {
                datasetcommon.ReadXml(System.AppDomain.CurrentDomain.BaseDirectory + "CachedCommonParameter.xml");
            }
            catch (Exception)
            {
                MessageBox.Show("CachedCommonParameter.xmlの読み込みでエラーが発生しました。終了します。回覧監視ツール、または回覧追跡ツールと同じフォルダにこのツールを置いて下さい。", "エラー", MessageBoxButtons.OK);
                Environment.Exit(100);
            }
            server = datasetcommon.Tables["構成"].Rows[0]["管理サーバ"].ToString();
            port = Convert.ToInt32(datasetcommon.Tables["構成"].Rows[0]["ポート"]);
            //パラメータの置き場所考慮
            try
            {
                parameterFolder = datasetcommon.Tables["構成"].Rows[0]["パラメータフォルダ"].ToString();
                if (parameterFolder.Trim() == "") parameterFolder = System.AppDomain.CurrentDomain.BaseDirectory;
            }
            catch
            {
                parameterFolder = System.AppDomain.CurrentDomain.BaseDirectory;
            }
            try {
                sequenceParameterFolder = datasetcommon.Tables["構成"].Rows[0]["順序パラメータフォルダ"].ToString();
                if(sequenceParameterFolder.Trim() == "") sequenceParameterFolder = parameterFolder;
            }
            catch {
                sequenceParameterFolder = parameterFolder;
            }


        }


        //送り元格納フォルダ名を得る
        int datarowindex = 0;
        string fromDirectory = "";
        public string getFromfolder(string filename)
        {
            int i = 0;
            foreach (DataRowView rv in dv)
            {
                if (filename.StartsWith(rv.Row["フォルダ"].ToString(),StringComparison.OrdinalIgnoreCase))
                {
                    if (fromDirectory.Length < rv.Row["フォルダ"].ToString().Length) //一番長いパスを選ぶ
                    {
                        fromDirectory = rv.Row["フォルダ"].ToString();
                        //Debug.WriteLine("i=" + i);
                        datarowindex = i;
                    }
                }
                i++;
            }
            return fromDirectory;
        }

        //投入先格納フォルダを得る
        public String getStartFolder(string filename) {
            //表示の為の文書名を得る
            string docName = filename.Substring(filename.LastIndexOf('\\') + 1);

            List<string> Paths = new List<string>();
            foreach(DataRowView rv in dv) {
                if(rv["オプション"].ToString().Contains("Start")) {
                    Paths.Add(rv["フォルダ"].ToString());
                }
            }
            if(Paths.Count != 0) {
                //選択メニューを表示
                using(SelectForm frm = new SelectForm(Paths, "文書名【" + docName + "】", "回覧先選択")) {
                    DialogResult ans;
                    do {
                        frm.ShowDialog();
                        if(frm.getSelectedToフォルダ() == "キャンセル") {
                            //キャンセルが選択された
                            ans = DialogResult.Cancel;
                        }
                        else {
                            //どれかのパスが選択された
                            if(chk確認msg.Checked == false) {
                                //確認MSG表示モード
                                ans = MessageBox.Show(String.Format("{1}{0}を選択しました。ここに回覧してよいですか？", Environment.NewLine, frm.getSelectedToフォルダ()), "確認", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Asterisk, MessageBoxDefaultButton.Button1);
                            }
                            else {
                                ans = DialogResult.Yes;
                            }
                        }
                    }
                    while(ans == DialogResult.No);

                    if(ans == DialogResult.Yes) {
                        int i;
                        for(i = 0; i < dv.Count; i++) {
                            if(dv[i]["フォルダ"].ToString() == frm.getSelectedToフォルダ()) break;
                        }
                        datarowindex = i;
                        return frm.getSelectedToフォルダ();
                    }
                    else {
                        return "/CANCEL";
                    }
                }
            }
            else {
                return "";
            }
        }


        //送り先先格納フォルダ名を得る
        public string getTofolder(string filename)
        {
            //表示の為の文書名を得る
            string docName = filename.Substring(fromDirectory.Length).Split('\\')[1];
            //
            string toDirectory = "";
            if (dv[datarowindex]["移動先ID"].ToString() != "")
            {
                //移動先ＩＤ欄に指定あり
                List<string> Paths = new List<string>();
                string 種類 = dv[datarowindex][0].ToString();
                string 移動先ＩＤ列 = dv[datarowindex]["移動先ID"].ToString();
                string[] 移動先ＩＤs = 移動先ＩＤ列.Split(new char[]{'/','／'});
                int i = 0;
                foreach (string id in 移動先ＩＤs)
                {
                    string[] key = new string[] { 種類, id };
                    int rowno = dv.Find(key);
                    if (rowno != -1)
                    {
                        Paths.Add(dv[rowno]["フォルダ"].ToString());
                        i++;
                    }
                }
                if (Paths.Count == 0)
                {
                    //有効なパスが無い
                    if(移動先ＩＤs[0].ToLower() == "end") {
                        //先頭にENDはある
                        MessageBox.Show("現在、最終格納フォルダに有り、この先回覧することは出来ません。尚、選択モードで回覧すれば可能な場合があります。");
                        return "/END";
                    }
                    else {
                        MessageBox.Show("回覧先フォルダが不明です（パラメータ指定において、「移動先ID」に指定しているすべてのIDが存在しないIDです）");
                        return "";
                    }
                }
                else
                {
                    //有効なパスがある
                    string 見出し = "";
                    if(dv[datarowindex]["オプション"].ToString() == "Ctrl不要") {
                        見出し = "移動先選択 [常に選択する指定がパラメータに有り]";
                    }
                    if (Program.selectMode  || 移動先ＩＤs.Length > 1 && dv[datarowindex]["オプション"].ToString() == "Ctrl不要")
                    {
                        //選択メニューを表示
                        using(SelectForm frm = new SelectForm(Paths, "文書名【" + docName + "】", 見出し)) {
                            DialogResult ans;
                            do
                            {
                                frm.ShowDialog();
                                if (frm.getSelectedToフォルダ() == "キャンセル")
                                {
                                    //キャンセルが選択された
                                    ans = DialogResult.Cancel;
                                }
                                else
                                {
                                    //どれかのパスが選択された
                                    if (chk確認msg.Checked == false)
                                    {
                                        ans = MessageBox.Show(String.Format("{1}{0}が選択されました。ここへ回覧してよいですか？", Environment.NewLine, frm.getSelectedToフォルダ()), "確認", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1);
                                    }
                                    else
                                    {
                                        ans = DialogResult.Yes;
                                    }
                                }
                            }
                            while (ans == DialogResult.No);
                            if(ans == DialogResult.Yes){
                                return frm.getSelectedToフォルダ(); 
                            }else{
                                return "/CANCEL";
                            }
                        }
                    }
                    else
                        //無条件で先頭のパスに決める
                        {
                            if(移動先ＩＤs[0].ToLower() == "end") {
                                //先頭がENDであった場合は終了
                                MessageBox.Show("最終格納フォルダのため、この先回覧出来ません。選択モードで回覧すれば可能な場合があります。");
                                return "/END";
                            }
                            else {
                                return Paths[0];
                            }
                        }
                }
            }
            else
            //次の行を移動先とする
            {
                if (datarowindex + 1 < dv.Count && dv[datarowindex + 1]["文書種類"].ToString() == dv[datarowindex]["文書種類"].ToString())
                {
                    if (filename.StartsWith(dv[datarowindex]["フォルダ"].ToString(), StringComparison.OrdinalIgnoreCase))
                    {
                        toDirectory = dv[datarowindex + 1]["フォルダ"].ToString();
                    }
                }
                return toDirectory;
            }
        }


        public string getDocumentKind()
        {
            //DataRowCollection rows = dataSet1.Tables["フォルダ順序"].Rows;
            return dv[datarowindex]["文書種類"].ToString();
        }

        private void btn再読込_Click(object sender, EventArgs e)
        {
            //移動指示パラメータ入力
            dataSet1.Clear();
            dataSet1.ReadXml(Path.Combine(sequenceParameterFolder, "文書移動指示パラメータ.xml"));
            this.dataGridView1.DataSource = dataSet1.Tables["フォルダ順序"];

            //保存情報入力
            datasetInfoSave.Clear();
            datasetInfoSave.Tables.Clear();
            try
            {
                datasetInfoSave.ReadXml(Path.Combine( parameterFolder , "TransToolInfoSave.xml"));
            }
            catch
            {
            }
            if (datasetInfoSave.Tables["設定情報"] != null)
            {
                chk確認msg.Checked = (datasetInfoSave.Tables["設定情報"].Rows[0][0].ToString() == "1" ? true : false);
                更新秒数updown.Value = Convert.ToDecimal(datasetInfoSave.Tables["設定情報"].Rows[0][2]);
            }
            else
            {
                //設定情報の初期パラメータが無ければ作る
                DataTable newtable = new DataTable("設定情報");
                datasetInfoSave.Tables.Add(newtable);
                DataRow newrow = newtable.NewRow();
                newtable.Rows.Add(newrow);
                newtable.Columns.Add("確認msg");
                newtable.Columns.Add("エクスプローラClose");
                newtable.Columns.Add("予備2");
                newrow["確認msg"] = "0";
                newrow["エクスプローラClose"] = "";
                newrow["予備2"] = "0";
            }
        }

        private void btn保存_Click(object sender, EventArgs e)
        {
            datasetInfoSave.Tables["設定情報"].Rows[0]["確認msg"] = this.chk確認msg.Checked ? 1 : 0;
            datasetInfoSave.Tables["設定情報"].Rows[0]["エクスプローラClose"] = "未使用";
            datasetInfoSave.Tables["設定情報"].Rows[0]["予備2"] = 更新秒数updown.Value;
            System.IO.StreamWriter strm;
            try {
                strm = new System.IO.StreamWriter(Path.Combine(sequenceParameterFolder, "文書移動指示パラメータ.xml"), false, System.Text.Encoding.UTF8);
                dataSet1.WriteXml(strm);
                strm.Close();
                strm = new System.IO.StreamWriter(Path.Combine(parameterFolder, "TransToolInfoSave.xml"), false, System.Text.Encoding.UTF8);
                datasetInfoSave.WriteXml(strm);
                strm.Close();
                MessageBox.Show("文書移動指示パラメータとその他指示を保存しました");
            }
            catch(Exception ex) {
                MessageBox.Show("文書移動指示パラメータとその他指示の保存でエラーが発生しました　:　" + ex.Message);
            }
        }

        private void btn閉じる_Click(object sender, EventArgs e)
        {
            this.Close();

        }

        private void btn追加_Click(object sender, EventArgs e)
        {
            if(txt種類.Text == "" || txtＩＤ.Text=="" || txtパス.Text == "") {
                lblErrorMessage.Text = "種類、ＩＤ、フォルダのどれかが空白です";
                return;
            }
            DataTable t = dataSet1.Tables["フォルダ順序"];
            for(int i = 0; i < t.Rows.Count; i++) {
                if (t.Rows[i]["フォルダ"].ToString().ToLower() == txtパス.Text.ToLower())
                {
                    lblErrorMessage.Text = "パスは、既に登録されています";
                    return;
                }
            }
            lblErrorMessage.Text = "";
            DataRow r = t.NewRow();
            r["文書種類"] = this.txt種類.Text;
            r["コメント"] = this.txtコメント.Text;
            r["ID"] = this.txtＩＤ.Text;
            r["移動先ID"] = this.txt移動先ＩＤ.Text;
            r["オプション"] = this.cboxオプション.Text;
            r["フォルダ"] = this.txtパス.Text.ToLower();
            t.Rows.Add(r);
            txt種類.Clear();
            txtコメント.Clear();
            txtＩＤ.Clear();
            txt移動先ＩＤ.Clear();
            cboxオプション.ResetText();
            txtパス.Clear();

        }

        private void btn参照_Click(object sender, EventArgs e) {
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if(result == System.Windows.Forms.DialogResult.OK) {
                txtパス.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void dataGridView1_UserDeletingRow(object sender, DataGridViewRowCancelEventArgs e) {
            if(MessageBox.Show("削除しますか？", "行の削除", MessageBoxButtons.YesNo) == DialogResult.No) {
                e.Cancel = true;     // 削除をキャンセル
            }
        }

        private void Folder_Load(object sender, EventArgs e)
        {
            lblErrorMessage.Text = "";
            txt種類.Text = txtコメント.Text = txtＩＤ.Text = txtパス.Text = "";
            cboxオプション.ResetText();
            txt順序パラ.Text = Path.Combine(sequenceParameterFolder, "文書移動指示パラメータ.xml");
        }

        private void btn確認_Click(object sender, EventArgs e)
        {
            btn確認.Enabled = false;
            this.Cursor = Cursors.WaitCursor;
            bool existerror = false;
            string msg = "";
            foreach (DataRowView rv in dv)
            {
                if(!System.IO.Directory.Exists(rv.Row["フォルダ"].ToString())){
                    msg += rv.Row["フォルダ"].ToString() + Environment.NewLine;
                    existerror = true;
                }
            }
            if (existerror)
            {
                MessageBox.Show("以下のフォルダは存在しません。" + Environment.NewLine + msg);
            }
            else
            {
                MessageBox.Show("確認が取れました。");
            }
            this.Cursor = Cursors.Default;
            btn確認.Enabled = true;
        }

        private void btnCSV_Click(object sender, EventArgs e)
        {
            string prpath = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            System.IO.StreamWriter csvpr;
            try
            {
                csvpr = new System.IO.StreamWriter(prpath + @"\文書移動指示パラメータ.CSV", false, Encoding.GetEncoding("Shift_JIS"));
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString());
                return;
            }
            string[] str = new string[dataSet1.Tables["フォルダ順序"].Columns.Count]; //カラム数以上を指定する
            int i = 0;
            foreach (DataColumn c in dataSet1.Tables["フォルダ順序"].Columns)
            {
                str[i++] = "'" + c.ColumnName.ToString();
            }
            csvpr.WriteLine(string.Join(",", str));

            foreach (DataRow r in dataSet1.Tables["フォルダ順序"].Rows)
            {
                i = 0;
                foreach (DataColumn c in dataSet1.Tables["フォルダ順序"].Columns)
                {
                    str[i] = "'" + r[i++].ToString();
                }
                csvpr.WriteLine(string.Join(",", str));
            }
            csvpr.Close();
            MessageBox.Show("デスクトップに「文書移動指示パラメータ.CSV」の名で出力しました。");
        }

        //印書ボタン押下
        private void 印刷PToolStripButton_Click(object sender, EventArgs e)
        {
            FormPrint(this);
            MessageBox.Show("パラメータの量が多くて収まらない場合はCSV出力してEXCELで印刷することをお勧めします。");
        }

        //フォーム印書
        internal void FormPrint(Form frm)
        {
            //フォームのイメージを取得する
            Graphics mygraphics = frm.CreateGraphics();
            memoryImage = new Bitmap(frm.ClientRectangle.Width, frm.ClientRectangle.Height, mygraphics);
            Graphics memoryGraphics = Graphics.FromImage(memoryImage);
            IntPtr dc1 = mygraphics.GetHdc();
            IntPtr dc2 = memoryGraphics.GetHdc();
            BitBlt(dc2, 0, 0, frm.ClientRectangle.Width, frm.ClientRectangle.Height, dc1, 0, 0, 13369376);
            mygraphics.ReleaseHdc(dc1);
            memoryGraphics.ReleaseHdc(dc2);
            //フォームのイメージを印刷する
            System.Drawing.Printing.PrintDocument PrintDocument1 = new System.Drawing.Printing.PrintDocument();
            System.Drawing.Printing.PrinterSettings ps = new System.Drawing.Printing.PrinterSettings();
            ps.DefaultPageSettings.Landscape = true;
            PrintDocument1.PrinterSettings = ps;
            PrintDocument1.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(PrintDocument1_PrintPage);
            PrintDocument1.Print();
            //printPreviewDialog1.Document = printDocument1;
            //printPreviewDialog1.ShowDialog();
        }
        [System.Runtime.InteropServices.DllImport("gdi32.dll")]
        private static extern bool BitBlt(IntPtr hdcDest,
             int nXDest, int nYDest, int nWidth, int nHeight,
             IntPtr hdcSrc, int nXSrc, int nYSrc, int dwRop);
        private Bitmap memoryImage;

        //印書イベントハンドラ
        private void PrintDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            e.Graphics.DrawImage(memoryImage, 0, 0);
        }

        private void btnFromCSV_Click(object sender, EventArgs e)
        {
             DialogResult ans = MessageBox.Show("メモリー上のパラメータを消してCSV形式パラメータファイル(見出し行無し)をメモリーに読み込みますか？", "確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
             if (ans == DialogResult.Yes)
             {
                 //行クリア
                 dataSet1.Tables["フォルダ順序"].Rows.Clear();
                 //入力
                 openFileDialog1.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
                 DialogResult result = openFileDialog1.ShowDialog();
                 if (result == System.Windows.Forms.DialogResult.OK)
                 {
                     string[] lines = File.ReadAllLines(openFileDialog1.FileName, Encoding.GetEncoding("Shift_JIS"));
                     //移す
                     foreach (string line in lines)
                     {
                         DataRow dr = dataSet1.Tables["フォルダ順序"].NewRow();
                         int fromi = 0;
                         int toi = 0;
                         string[] fields = line.Split(',');
                         int realfieldcount = fields.Length;
                         for (int i = fields.Length - 1; i >= 0; i--)
                         {
                             if (fields[i] == "")
                             {
                                 realfieldcount--;
                             }
                             else
                             {
                                 break;
                             }
                         }
                         int maxcolumn = realfieldcount;
                         if (maxcolumn > dataSet1.Tables["フォルダ順序"].Columns.Count)
                         {
                             maxcolumn = dataSet1.Tables["フォルダ順序"].Columns.Count;
                         }
                         for (int i = 0; i < maxcolumn; i++)
                         {
                             dr[toi++] = fields[fromi].Substring(0, 1) == "'" ? fields[fromi].Substring(1) : fields[fromi];
                             fromi++;
                         }
                         dataSet1.Tables["フォルダ順序"].Rows.Add(dr);
                     }
                 }
                 MessageBox.Show("CSVファイルからパラメータをメモリー上に取り込みました。");
             }
        }

        private void cboxオプション_SelectedIndexChanged(object sender, EventArgs e) {

        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e) {

        }

    }
}