﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IWshRuntimeLibrary;
using System.IO;

//パラメータなしで実行したときのメニュー


namespace 電子文書toNextFolder
{
    public partial class Form1 : Form
    {
        Folder folder1;
        public Form1()
        {
            InitializeComponent();
            lblVersion.Text = Program.version;
        }

        //右クリックコンテキスト登録
        private void button2_Click(object sender, EventArgs e)
        {
            try {
                Microsoft.Win32.RegistryKey key1 = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey("*", true);
                if(key1 != null) {
                    key1 = key1.CreateSubKey(@"shell\♪文書を次フォルダへ移す\command");
                    key1.SetValue("", Application.ExecutablePath + @" ""%1""");
                    key1.Close();
                    key1 = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey("*", true);
                    key1 = key1.CreateSubKey(@"shell\♪（フォルダを選択して）文書を移す\command");
                    key1.SetValue("", Application.ExecutablePath + @"  -select  ""%1""");
                    key1.Close();
                }
                else {
                    MessageBox.Show("レジストリに「*」キーが見つかりません");
                    return;
                }
                key1 = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey("folder", true);
                if(key1 != null) {
                    key1 = key1.CreateSubKey(@"shell\♪文書を次フォルダへ移す\command");
                    key1.SetValue("", Application.ExecutablePath + @" ""%1""");
                    key1.Close();
                    key1 = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey("folder", true);
                    key1 = key1.CreateSubKey(@"shell\♪（フォルダを選択して）文書を移す\command");
                    key1.SetValue("", Application.ExecutablePath + @"  -select  ""%1""");
                    key1.Close();
                }
                else {
                    MessageBox.Show("レジストリに「Folder」キーが見つかりません");
                    return;
                }
                MessageBox.Show("エクスプローラの右クリックに”♪文書を次フォルダへ移す”と”♪（フォルダを選択して）文書を移す”を登録しました。");
            }
            catch(System.UnauthorizedAccessException ex) {
                MessageBox.Show("管理者モードである必要があります。" + Environment.NewLine + "右クリックから「別のユーザとして実行」を選び、管理者アカウントで実行して下さい。" + Environment.NewLine + ex.Message);
            }
            catch(Exception ex) {
                MessageBox.Show("エラー発生" + Environment.NewLine + ex.Message);
            }
        }

        //「送る」へショートカットを入れる Windows Script Host Object Model (COM)
        private void btnRegistration_Click(object sender, EventArgs e)
        {
			WshShell wshell = new WshShell();
            string linkPath = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.SendTo), "-文書を次フォルダへ移す.lnk");
			IWshShortcut link = (IWshShortcut)wshell.CreateShortcut( linkPath );
			link.TargetPath = Application.ExecutablePath;
			link.Save();
            MessageBox.Show("右クリックの「送る」に”-文書を次フォルダへ移す”のショートカットを登録しました。");
        }

        //移動指示パラメーター保守
        private void btnParameter_Click(object sender, EventArgs e)
        {
            string serverName;//dummy
            int serverPort;//dummy
            Folder.構成入手(out serverName, out serverPort);//cashedcommonnparameterより入手
            folder1 = new Folder();
            folder1.ShowDialog();
        }

        //閉じる
        private void button1_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e) {
            if(((TabControl)sender).SelectedTab.Text == "ライセンス") {
                textBox1.Text = 文書を次のフォルダへ移す.Properties.Resources.LISENCE;
                this.Width *= 2;
                this.Height *= 2;
            }
            else {
                this.Width /= 2;
                this.Height /= 2;
            }
        }

    }
}