﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Diagnostics;
using System.IO;

namespace 電子文書toNextFolder {
    static class Program {
        /// <summary>
        /// 文書名で右クリック、または送るから選択した場合の処理
        /// </summary>
        static Folder folder1;
        static Microsoft.VisualBasic.Devices.Keyboard k = new Microsoft.VisualBasic.Devices.Keyboard();
        static public bool selectMode;
        public static string version;
        static bool newMode;
        static bool 対象はフォルダ;
        [STAThread]
        static void Main(String[] args) {

            if(k.CtrlKeyDown) {
                //選択モード
                selectMode = true;
            }
            Folder.構成入手(out serverName, out serverPort);//cashedcommonnparameterより入手
            TextWriterTraceListener trace = new TextWriterTraceListener(Path.Combine(Folder.parameterFolder, "TransToolTraceFile.txt"));
            Debug.Listeners.Add(trace);
            Debug.AutoFlush = true;
            version = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString(); ;
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            if(args.Length == 0) {
                //コンテキスト登録、パラメータ保守
                Application.Run(new Form1());
            }
            else {
                //移動
                folder1 = new Folder();
                System.IO.StreamWriter strm = null;
                System.Threading.Mutex objMutex = null;
                int argumentindex = 0;
                if(args.Length > 1 && args[0].ToString() == "-select") {
                    //メニューで移動先を選択するモード
                    argumentindex = 1;
                    selectMode = true;
                }
                for(; argumentindex < args.Length; argumentindex++)//コンテキストメニュー時は１個しか無い
                {
                    int backspacecount = 0;
                    string dockind = "";
                    string 入力fullPath = "";           //C:\ＡＡＡ\ＢＢＢ１\ccc\(ddd|eee.xls)
                    string from格納フォルダ = "";       //C:\ＡＡＡ\ＢＢＢ１
                    string to格納フォルダ = "";         //C:\ＡＡＡ\ＢＢＢ２
                    string fromパス = "";               //C:\ＡＡＡ\ＢＢＢ１\ccc,
                    string from格納フォルダより下 = ""; //ccc\(ddd|eee.xls)
                    string 格納フォルダ直下名 = "";     //ccc
                    string toパス = "";                 //C:\ＡＡＡ\ＢＢＢ２\ccc
                    string 複写元パス = "";             //C:\ＡＡＡ\ＢＢＢ１\ccc-n
                    string 複写先パス = "";             //C:\ＡＡＡ\ＢＢＢ２\ccc-n
                    string 重複調整後格納フォルダ直下名 = "";//ccc-n
                    string 重複対応後のfromパス;        //C:\ＡＡＡ\ＢＢＢ１\ccc-n
                    入力fullPath = args[argumentindex];
                    if(入力fullPath.Contains("~")) {
                        //８.３ dos形式を変換
                        入力fullPath = getLongPath(入力fullPath.ToString()); //C:\ＡＡＡ\ＢＢＢ１\ccc\ddd[\eee.xls]|C:\ＡＡＡ\ＢＢＢ１\ccc.xls
                    }
                    bool fileIsSelected = false;
                    if(File.Exists(入力fullPath)) {
                        //ファイル選択の場合
                        fileIsSelected = true;
                    }
                    //移動元特定
                    from格納フォルダ = folder1.getFromfolder(入力fullPath); //C:\ＡＡＡ\ＢＢＢ１
                    if(from格納フォルダ.Equals(入力fullPath, System.StringComparison.OrdinalIgnoreCase)) {
                        //格納フォルダそのもの
                        MessageBox.Show("これは回覧出来ないフォルダーです。", "移動エラー", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);
                        return;
                    }
                    if(from格納フォルダ == "") {
                        //格納フォルダ外の新規文書
                        DialogResult ans = MessageBox.Show("この文書は、文書回覧用の格納フォルダの外にあるので、新規回覧文書と見なし、格納先の選択メニューを表示します。\rまた、移動ではなく複写します。\r" + Environment.NewLine + 入力fullPath, "新規文書", MessageBoxButtons.OKCancel, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);
                        if(ans == DialogResult.OK) {
                            //格納するフォルダを決定
                            to格納フォルダ = folder1.getStartFolder(入力fullPath);  //C:\ＡＡＡ\ＢＢＢ２
                            if(to格納フォルダ == "" ||to格納フォルダ=="/CANCEL") {
                                //格納しない
                                return;
                            }
                            toパス = to格納フォルダ + "\\" + 入力fullPath.Split('\\')[入力fullPath.Split('\\').Length - 1]; //C:\ＡＡＡ\ＢＢＢ２\ddd｜C:\ＡＡＡ\ＢＢＢ２\eee.xls
                            fromパス = 入力fullPath;
                            if(!File.Exists(fromパス)) {
                                対象はフォルダ = true;
                            }
                            from格納フォルダ = 入力fullPath.Substring(0, 入力fullPath.LastIndexOf('\\'));
                            格納フォルダ直下名 = 入力fullPath.Substring(入力fullPath.LastIndexOf('\\') + 1);
                            newMode = true;
                        }
                        else {
                            return;
                        }
                    }
                    else {
                        //格納フォルダ内の文書
                        if(入力fullPath.StartsWith(from格納フォルダ, StringComparison.OrdinalIgnoreCase)) {
                            from格納フォルダより下 = 入力fullPath.Substring(from格納フォルダ.Length + 1); //ccc\ddd[\eee.xls]|ccc.xls
                        }
                        else {
                            System.Diagnostics.Debug.Fail("フォルダ名処理で内部矛盾を発見", 入力fullPath + " " + from格納フォルダ);
                        }
                        if(from格納フォルダより下.Contains("\\")) {
                            格納フォルダ直下名 = from格納フォルダより下.Remove(from格納フォルダより下.IndexOf("\\")); //ccc|ccc.xls
                        }
                        else {
                            格納フォルダ直下名 = from格納フォルダより下; //ccc
                        }
                        fromパス = from格納フォルダ + "\\" + 格納フォルダ直下名; //C:\ＡＡＡ\ＢＢＢ１\ccc[.xls]
                        //fromパスは正しく更新したものか？
                        if(File.Exists(fromパス)) {
                            対象はフォルダ = false;
                            if(ファイルの更新時刻遅すぎ(fromパス)) {
                                return;
                            }
                        }
                        else {
                            対象はフォルダ = true;
                            if(フォルダ下のファイルの更新時刻遅すぎ(fromパス)) {
                                return;
                            }
                        }

                        to格納フォルダ = folder1.getTofolder(入力fullPath); //C:\ＡＡＡ\ＢＢＢ２
                        if(to格納フォルダ == "") {
                            //見つからず
                            MessageBox.Show("回覧先の判断がつきません(フォルダ移動先パラメータは該当先フォルダが見当たりません)。" + Environment.NewLine + 入力fullPath, "移動エラー", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);
                            return;
                        }
                        if(to格納フォルダ == "/END") {
                            //終点
                            return;
                        }
                        if(to格納フォルダ == "/CANCEL") {
                            //キャンセル
                            return;
                        }
                        dockind = folder1.getDocumentKind();
                        //複数選択が意味を持たない場合はその中の1個のみ通す
                        backspacecount = from格納フォルダより下.Split('\\').Length - 1;
                        if(backspacecount != 0)
                        {
                            objMutex = new System.Threading.Mutex(false, "TRANS");
                            if(objMutex.WaitOne(0, false) == false) {
                                return;
                            }
                        }
                        toパス = to格納フォルダ + "\\" + 格納フォルダ直下名; //C:\ＡＡＡ\ＢＢＢ２\ccc[.xls]
                    }

                    //移動先の名前重複チェック
                    int duplicateCount = 1;
                    if(対象はフォルダ) {
                        //フォルダ
                        while(System.IO.Directory.Exists(toパス + "\\")) {
                            duplicateCount++;
                            if(System.Text.RegularExpressions.Regex.IsMatch(toパス, ".*(-[0-9]{1,3})$")) {
                                string num = toパス.Substring(toパス.LastIndexOf('-') + 1);
                                int num2 = int.Parse(num) + 1;
                                toパス = toパス.Remove(toパス.LastIndexOf('-') + 1) + num2.ToString();//C:\ＡＡＡ\ＢＢＢ２\ccc-n
                            }
                            else {
                                toパス = toパス + "-1";//C:\ＡＡＡ\ＢＢＢ２\ccc-1
                            }
                        }
                    }
                    else {
                        //ファイル
                        while(System.IO.File.Exists(toパス)) {
                            duplicateCount++;
                            if(System.Text.RegularExpressions.Regex.IsMatch(toパス, ".*(-[0-9]{1,3})" + Path.GetExtension(toパス) +  "$")) {
                                string num = Path.GetFileNameWithoutExtension(toパス).Substring(Path.GetFileNameWithoutExtension(toパス).LastIndexOf('-') + 1);
                                int num2 = int.Parse(num) + 1;
                                toパス = toパス.Remove(toパス.LastIndexOf('-') + 1) + num2.ToString() + Path.GetExtension(toパス); //C:\ＡＡＡ\ＢＢＢ２\ccc-n.xls
                            }
                            else {
                                toパス = Path.Combine( Path.GetDirectoryName(toパス), Path.GetFileNameWithoutExtension(toパス) + "-1") + Path.GetExtension(toパス); //C:\ＡＡＡ\ＢＢＢ２\ccc-1.xls
                            }
                        }
                    }
                    複写先パス = toパス;
                    if(duplicateCount > 1) {
                        MessageBox.Show(格納フォルダ直下名 + "は、回覧先に名前の同じものがあるので、末尾を" + 複写先パス + "に変えた後格納します。", "警告", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);
                    }
                    重複調整後格納フォルダ直下名 = 複写先パス.Substring(toパス.LastIndexOf('\\') + 1); //ccc-n[.xls]
                    if(fileIsSelected) {
                        //選択がファイルの場合、選択を解除する
                        for(int m = 0; m < backspacecount; m++) {
                            System.Windows.Forms.SendKeys.SendWait("{BACKSPACE}");
                        }
                    }
                    else {
                        //選択がフォルダの場合も同じように
                        for(int j = 0; j < backspacecount; j++) {
                            System.Windows.Forms.SendKeys.SendWait("{BACKSPACE}");
                        }
                    }
                    System.IO.Directory.SetCurrentDirectory(System.AppDomain.CurrentDomain.BaseDirectory); //カレントディレクトリを移動元フォルダからづらす
                    if(格納フォルダ直下名 != 重複調整後格納フォルダ直下名) {
                        //名前を変更する
                        重複対応後のfromパス = from格納フォルダ + "\\" + 重複調整後格納フォルダ直下名;//C:\ＡＡＡ\ＢＢＢ１\ccc-n[.xls]
                        try {
                            if(対象はフォルダ) {
                                System.IO.Directory.Move(fromパス + "\\", 重複対応後のfromパス + "\\");  //名前変更
                            }
                            else {
                                System.IO.File.Move(fromパス, 重複対応後のfromパス); //名前変更   
                            }
                        }
                        catch(Exception ex) {
                            MessageBox.Show("エラー発生（" + ex.Message + "）。" + Environment.NewLine
                                + "from:" + fromパス + Environment.NewLine
                                + "  to:" + 重複対応後のfromパス + Environment.NewLine
                                + "閉じられていないものが含まれている可能性があります。Excelやフォルダ等を閉じて再度回覧して下さい。", "名前変更エラー", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);
                            return;
                        }
                        複写元パス = 重複対応後のfromパス; //C:\ＡＡＡ\ＢＢＢ１\ccc-n[.xls]
                    }
                    else {
                        //名前そのまま
                        複写元パス = fromパス; //C:\ＡＡＡ\ＢＢＢ１\ccc[.xls]
                    }
                    //確認ＭＳＧ
                    if(folder1.chk確認msg.Checked == false) {
                        DialogResult ans = MessageBox.Show(String.Format(
                              "文書種類 = {1}{0}{0}回覧文書 = {2}{0}{0}FROM = {3}{0}{0}TO = {4}{0}", Environment.NewLine, folder1.getDocumentKind(), 重複調整後格納フォルダ直下名, from格納フォルダ, to格納フォルダ)
                             , "確認", MessageBoxButtons.OKCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1, MessageBoxOptions.RightAlign | MessageBoxOptions.DefaultDesktopOnly);
                        if(ans == DialogResult.Cancel) return;
                    }
                    //移動実行
                    const int 最大試行回数 = 10;
                    const int 待ちミリ秒数 = 500;
                    int 何回目 = 0;
                    for(; ; ) {
                        try {
                            if(!対象はフォルダ) {
                                //ファイルの場合
                                if(newMode) {
                                    File.Copy(複写元パス, 複写先パス);
                                }
                                else {
                                    File.Move(複写元パス, 複写先パス);
                                }
                            }
                            else {
                                //フォルダの場合
                                Debug.Assert(Directory.Exists(複写元パス), 複写元パス + " が見つからない");
                                Debug.Assert(Directory.Exists(to格納フォルダ), to格納フォルダ + " が見つからない");
                                if(newMode) {
                                    directoryCopy(複写元パス, 複写先パス);
                                }
                                else {
                                    Directory.Move(複写元パス + "\\", 複写先パス + "\\");
                                }
                            }
                            break;
                        }
                        catch(Exception ex) {

                            MessageBox.Show(ex.Message);

                            if(何回目 >= 最大試行回数) {
                                DialogResult ans = MessageBox.Show(ex.Message + Environment.NewLine + Environment.NewLine
                                    + "FROM : " + 複写元パス + Environment.NewLine
                                    + "  TO : " + 複写先パス + Environment.NewLine + Environment.NewLine
                                    + "♪回覧元に閉じられていないものが含まれている可能性があります。" + Environment.NewLine
                                    + "再試行しますのでExcel等を閉じて、又は暫く待った後ＯＫを押して下さい。", "回覧エラー発生。再試行確認", MessageBoxButtons.OKCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);
                                if(ans == DialogResult.Cancel) {
                                    return;
                                }
                                何回目 = 0;
                            }
                            else {
                                何回目++;
                                System.Threading.Thread.Sleep(待ちミリ秒数);
                            }
                        }
                    }
                    complete c = null;
                    if(c == null) c = new complete(重複調整後格納フォルダ直下名);
                    c.ShowDialog();    //完了メッセージ
                    if(backspacecount != 0)//複数選択が許されない場合
                    {
                        objMutex.ReleaseMutex();
                        objMutex.Close();
                    }
                    ////クリップボード
                    //try {
                    //    Clipboard.SetText(" " + 重複調整後格納フォルダ直下名 + Environment.NewLine + Environment.NewLine + " <" + to格納フォルダ + ">");//パスをクリップボードへ
                    //}
                    //catch(Exception ex) {
                    //    Debug.Print("Clipboard.SetText error : {0}", ex.Message);
                    //}
                    //ログ書き込み
                    for(int i = 0; i < 100; i++) {
                        try {
                            fs = new FileStream(Path.Combine(Folder.parameterFolder, "文書移動ログ.txt"), FileMode.Append, FileAccess.Write, FileShare.None);
                            sw = new StreamWriter(fs, System.Text.Encoding.GetEncoding("shift_JIS"));
                            sw.WriteLine("DateTime={0:yyMMdd HH:mm:ss},文書={3},From={1},To={2}", DateTime.Now, from格納フォルダ, to格納フォルダ, 重複調整後格納フォルダ直下名);
                            sw.Close();
                            i = 999;
                        }
                        catch {
                            //Debug.Print("sw.WriteLine error : {0}", ex.StackTrace);
                            System.Threading.Thread.Sleep(100);
                        }
                    }
                    //サーバにログ送信
                    try {
                        udpsend("putLog", 重複調整後格納フォルダ直下名, to格納フォルダ);
                    }
                    catch(Exception ex) {
                        Debug.Print("udpsend error : {0}", ex.Message);
                    }
                    //
                    if(backspacecount != 0 && args.Length > 1)//「送る」の場合は文書フォルダの中身を複数選択しても無視する
                    {
                        break;//終了
                    }
                }
                //try {
                //    if(sw != null) sw..Close();
                //}
                //catch(Exception ex) {
                //    Debug.Print("strm.Close() error : {0}", ex.Message);
                //}
                return;
            }
        }
        static FileStream fs;
        static StreamWriter sw;

        private static bool ファイルの更新時刻遅すぎ(string filePath) {
            if(folder1.更新秒数updown.Value != 0) {
                //チェック指示あり
                if(File.GetLastWriteTime(filePath).AddSeconds((double)folder1.更新秒数updown.Value) < DateTime.Now) {
                    //遅すぎる
                    int 秒差 = (int)((DateTime.Now - File.GetLastWriteTime(filePath)).TotalSeconds);
                    DialogResult ans = MessageBox.Show(string.Format("{1}の更新時刻は{0}{2} ( {4} 秒前 )です。ファイルを回覧して良いですか？", Environment.NewLine, filePath, File.GetLastWriteTime(filePath), folder1.更新秒数updown.Value, 秒差), "確認", MessageBoxButtons.YesNo, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2, MessageBoxOptions.DefaultDesktopOnly);
                    if(ans == DialogResult.No) {
                        //中止
                        return true;
                    }
                }
            }
            return false;
        }

        private static bool フォルダ下のファイルの更新時刻遅すぎ(string folderPath)//２段階下まで確認(ショートカット含む)
        {
            if(folder1.更新秒数updown.Value != 0) {
                DateTime lasttime = DateTime.MinValue;
                DateTime writetime = DateTime.MinValue;
                foreach(string file1 in System.IO.Directory.GetFiles(folderPath)) {
                    writetime = File.GetLastWriteTime(file1);
                    if(writetime.AddSeconds((double)folder1.更新秒数updown.Value) > DateTime.Now) {
                        return false; ;
                    }
                    if(lasttime < writetime) { lasttime = writetime; }
                }
                foreach(string dir1 in System.IO.Directory.GetDirectories(folderPath)) {
                    foreach(string file2 in System.IO.Directory.GetFiles(dir1)) {
                        writetime =File.GetLastWriteTime(file2);
                        if(writetime.AddSeconds((double)folder1.更新秒数updown.Value) > DateTime.Now) {
                            return false;
                        }
                        if(lasttime < writetime) { lasttime = writetime; }
                    }
                }
                if(writetime == DateTime.MinValue) {
                    DialogResult ans = MessageBox.Show("このフォルダも１段下のフォルダもファイルが入っていませんが、回覧して良いですか？", "確認", MessageBoxButtons.YesNo, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2, MessageBoxOptions.DefaultDesktopOnly);
                    if(ans == DialogResult.No) {
                        //中止
                        return true;
                    }
                }
                else {
                    int 秒差 = (int)(DateTime.Now - lasttime).TotalSeconds;
                    DialogResult ans = MessageBox.Show(string.Format("{1}の更新時間は{0} {2} ( {4}秒前 ) です。回覧しても良いですか？", Environment.NewLine, folderPath, lasttime.ToString("MM/dd HH:mm:ss"), folder1.更新秒数updown.Value, 秒差), "確認", MessageBoxButtons.YesNo, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2, MessageBoxOptions.DefaultDesktopOnly);
                    if(ans == DialogResult.No) {
                        //中止
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        static string serverName;
        static int serverPort;
        static void udpsend(params string[] text)  //送信
       {
            if(serverName.Trim() != "") {
                string 氏名 = Environment.UserName.ToString();
                ADuser.getUserInfo(氏名, "name", ref 氏名);
                氏名 = 氏名.Replace(" ", "");
                UdpClient udp = new UdpClient();
                byte[] bytes = System.Text.Encoding.UTF8.GetBytes(DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + 氏名 + "|TRANS|" + version + "|" + string.Join("|", text));
                udp.Connect(serverName, serverPort);
                udp.Send(bytes, bytes.Length);
            }
        }

        // 短いファイル名から長いファイル名を取得する
        public static string getLongPath(string path) {
            //Debug.Print("path={0}", path);
            string root = System.IO.Path.GetPathRoot(path);// C:\ または \\servername\sherename
            string[] folders;
            if(path[root.Length] == '\\') {
                folders = path.Substring(root.Length + 1).Split(System.IO.Path.DirectorySeparatorChar);
            }
            else {
                folders = path.Substring(root.Length).Split(System.IO.Path.DirectorySeparatorChar);
            }
            string res = root;
            foreach(string name in folders) {
                System.IO.DirectoryInfo di = new DirectoryInfo(res);
                System.IO.FileSystemInfo[] fsi = di.GetFileSystemInfos(name);
                if(fsi.Length == 1) {
                    res = fsi[0].FullName;//だんだん長くなってゆく
                }
                else {
                    System.Diagnostics.Debug.Fail("error happen at getLongPath()", "short path = " + path);
                }
            }
            return res;
        }

        //ディレクトリ複写
        private static void directoryCopy(string sourceDirName, string destDirName) {
            DirectoryInfo dir = new DirectoryInfo(sourceDirName);
            DirectoryInfo[] subDirs = dir.GetDirectories();
            DirectoryInfo newdir = new DirectoryInfo(destDirName);
            if(!dir.Exists) {
                throw new DirectoryNotFoundException("Source directory does not exist or could not be found: " + sourceDirName);
            }
            if(!newdir.Exists) {
                newdir.Create();
            }
            FileInfo[] files = dir.GetFiles();
            foreach(FileInfo file in files) {
                //string temppath = Path.Combine(destDirName, file.Name);
                file.CopyTo(Path.Combine(destDirName, file.Name), false);
            }
            foreach(DirectoryInfo subdir in subDirs) {
                string temppath = Path.Combine(destDirName, subdir.Name);
                directoryCopy(subdir.FullName, temppath);//回帰
            }
            newdir.LastWriteTime = dir.LastWriteTime;
            newdir.CreationTime = dir.CreationTime;
        }
    }
}