package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.Blob;
import java.sql.Clob;

public class RapideMetaLoader{
	
	private String database = null;

	public static void main(String args[]){
		try {
			if (args.length > 0){
				RapideMetaLoader RapideMetaLoader = new RapideMetaLoader(args[0]);
				RapideMetaLoader.metaLoad();
			} else {
				RapideMetaLoader RapideMetaLoader = new RapideMetaLoader(null);
				RapideMetaLoader.metaLoad();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	RapideMetaLoader(String _database) {
		super();
		database = _database;
	}


	private void metaLoad(){
		Connection conn = null;
		PreparedStatement stmt = null;
		BufferedReader br = null;
		File folder = null;
		File subFolder = null;
		String strLine = null;
		String strMltLine = null;
		String tbName 	= null;
		String viewName 	= null;
		String procName 	= null;
		String [] flName = null;
		File [] inFiles = null;
		int tb_count = 0;
		String [] sqlLine = null;

		CmnProps cp = null;
		CmnAccessObjects dao = null;
		
		try {
			cp = new CmnProps();
			cp.setProperty(database);
			
			if (cp.dbType > cp.DB_TYPE_MYSQL || cp.dbType <0){
				throw new Exception("f[^x[XΏۊOłB[" + cp.DB_TYPE_NAME[cp.dbType] + "]");
			}
			if(cp.inFolder != null){
				folder = new File(cp.inFolder);
			} else {
				if (database != null){
					folder = new File(cp.DEFAULT_IN_FOLDER + "/DDL_" + database.toUpperCase());
				} else {
					folder = new File(cp.DEFAULT_IN_FOLDER + "/DDL_" + cp.DB_TYPE_NAME[cp.dbType].toUpperCase());
				}
			}
			CmnUtils.infoPrint("-->͌tH_='" + folder + "'");
			CmnUtils.infoPrint("^f[^[hJn܂B");

			// Connect
			dao = new CmnAccessObjects(cp);
			conn = dao.connect();

			if(cp.isDrop){
				executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.DROP_FK], cp, true, false);
				executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.DROP_VIEW], cp, true, false);
				executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PROCEDURE], cp, true, false);
				executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SYNONYM], cp, true, false);
				executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SEQUENCE], cp, true, false);
				executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.DROP_TABLE], cp, true, false);
			}
			subFolder = new File(folder + "/TABLES");
			inFiles = subFolder.listFiles();
			tb_count = 0;
			if(inFiles != null) {
				for(int k=0;k<inFiles.length;k++){
					flName = CmnUtils.splitDot(inFiles[k].getName());
					tbName = flName[0];
					executeSqlFile(dao, stmt, subFolder + "/" + inFiles[k].getName(), cp, false, false);
					CmnUtils.infoPrint(String.format("%1$-42s","[TABLE] " + tbName) + " ^f[^[h܂B");
				}
			}
			executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY], cp, false, false);
			executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY], cp, false, false);
			executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX], cp, false, false);
			subFolder = new File(folder + "/VIEWS");
			inFiles = subFolder.listFiles();
			int view_count = 0;
			if(inFiles != null) {
				for(int k=0;k<inFiles.length;k++){
					flName = CmnUtils.splitDot(inFiles[k].getName());
					viewName = flName[0];
					executeSqlFile(dao, stmt, subFolder + "/" + inFiles[k].getName(), cp, false, false);
					CmnUtils.infoPrint(String.format("%1$-42s","[VIEW] " + viewName) + " ^f[^[h܂B");
				}
			}
			subFolder = new File(folder + "/PROCEDURES");
			inFiles = subFolder.listFiles();
			int proc_count = 0;
			if(inFiles != null) {
				for(int k=0;k<inFiles.length;k++){
					flName = CmnUtils.splitDot(inFiles[k].getName());
					procName = flName[0];
					executeSqlFile(dao, stmt, subFolder + "/" + inFiles[k].getName(), cp, false, true);
					CmnUtils.infoPrint(String.format("%1$-42s","[PROCEDURE] " + procName) + " ^f[^[h܂B");
				}
			}
			executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SYNONYM], cp, false, false);
			executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SEQUENCE], cp, false, false);
			executeSqlFile(dao, stmt, folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_FK], cp, false, false);

			CmnUtils.infoPrint("^f[^[hI܂B");

		} catch(SQLException se) {
			try{
				CmnUtils.errorPrint(se.toString());
				se.printStackTrace();
				se = se.getNextException();
				if(se != null) {
					System.out.println(se.getMessage());
				}
				dao.rollback();
			} catch (Exception see) {}
		} catch (Exception e) {			
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
				dao.rollback();
			} catch (Exception ee) {}
		} finally{
			try{
				dao.disconnect();
				if(stmt != null){
					stmt.close();
					stmt=null;
				}
				if(br!=null){
					br.close();
					br=null;
				}
			} catch (Exception e) {}
		}
	}
	
	private void executeSqlFile(CmnAccessObjects _dao, PreparedStatement _stmt, String _infile, CmnProps _cp, boolean _isResume, boolean _isReplace) throws Exception{
		BufferedReader br = null;
		String strLine = null;
		String strMltLine = "";
		String [] sqlLine = null;

		File infile = new File(_infile);
		if (infile.exists()){
			br = new BufferedReader(new InputStreamReader(new FileInputStream(_infile), _cp.fileEncoding));
			while((strLine=br.readLine()) != null){
				if (_cp.dbType == _cp.DB_TYPE_SQLSERVER){
					if(!strLine.equals("GO")){
						strMltLine += _cp.inColLineSeparator + strLine;
					}
				} else {
					strMltLine += _cp.inColLineSeparator + strLine;
				}
			}
			if(_isReplace){
				if(!strMltLine.equals("")){
					try {
						if (_cp.dbType == _cp.DB_TYPE_ORACLE){
							_stmt = _dao.prepareSql(strMltLine.replaceAll("\r",""));
						} else {
							_stmt = _dao.prepareSql(strMltLine);
						}
						_stmt.executeUpdate();
						if(_stmt != null){
							_stmt.close();
							_stmt=null;
						}
					} catch (Exception e) {
						if(!_isResume){
							throw e;
						}
					}
				}
			} else {
				if (_cp.dbType == _cp.DB_TYPE_MYSQL){
					sqlLine = CmnUtils.split(strMltLine, _cp.SQL_TERMINATOR[_cp.dbType]);
				} else {
					sqlLine = CmnUtils.split(strMltLine, _cp.SQL_TERMINATOR2[_cp.dbType]);
				}
				for(int l = 0;l<sqlLine.length;l++){
					if(!sqlLine[l].equals("")){
						try {
							if (_cp.dbType == _cp.DB_TYPE_ORACLE){
								_stmt = _dao.prepareSql(sqlLine[l].replaceAll("\r",""));
							} else {
								_stmt = _dao.prepareSql(sqlLine[l]);
							}
							_stmt.executeUpdate();
							if(_stmt != null){
								_stmt.close();
								_stmt=null;
							}
						} catch (Exception e) {
							if(!_isResume){
								throw e;
							}
						}
					}
				}
			}
		}
	}

}

