package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.Blob;
import java.sql.Clob;

public class RapideMetaUnloader{

	private static final int CONTENTS = 0;
	private static final int CREATE = 1;
	private static final int DROP = 2;
	private static final int TRUNCATE = 3;

	private static final int WK_FILE = 0;
	private static final int R_CREATE_PKEY = 1;
	private static final int R_CREATE_UKEY = 2;
	private static final int R_CREATE_INDEX = 3;
	private static final int W_CREATE_PKEY = 0;
	private static final int W_CREATE_UKEY = 1;
	private static final int W_CREATE_INDEX = 2;
	private static final int W_DROP_PKEY = 3;
	private static final int W_DROP_UKEY = 4;
	private static final int W_DROP_INDEX = 5;

	private static final int LINE = 0;
	private static final int TBL_CONTENTS = 1;
	private static final int TBL_COMMENTS = 2;
	private static final int IDX_CONTENTS_1 = 1;
	private static final int IDX_CONTENTS_2 = 2;
	private static final int IDX_CONTENTS_3 = 3;

	private static final int COL01 = 0;
	private static final int COL02 = 1;
	private static final int COL03 = 2;
	private static final int COL04 = 3;
	private static final int COL05 = 4;
	private static final int COL06 = 5;
	private static final int COL07 = 6;
	private static final int COL08 = 7;
	private static final int COL09 = 8;
	private static final int COL10 = 9;
	private static final int COL11 = 10;
	private static final int COL12 = 11;

	private String database = null;
	private String phyfileExtension = "phy";

	public static void main(String args[]){
		try {
			if (args.length > 0){
				RapideMetaUnloader RapideMetaUnloader = new RapideMetaUnloader(args[0]);
				RapideMetaUnloader.metaUnload();
			} else {
				RapideMetaUnloader RapideMetaUnloader = new RapideMetaUnloader(null);
				RapideMetaUnloader.metaUnload();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	RapideMetaUnloader(String _database) {
		super();
		database = _database;
	}


	private void metaUnload(){
		Connection conn = null;
		PreparedStatement stmt = null;
		BufferedReader [] br = new BufferedReader[4];
		PrintWriter [] pw = new PrintWriter[6];
		File folder = null;
		File subFolder = null;
		String strLine = null;
		String strLine2 = null;
		String [][] strSplit = new String[4][];
		String strContents = null;
		ArrayList<String> alData = null;
		ArrayList<String> alData2 = null;
		int columnCount = 0;
		String tableName = null;
		String tableCmnt = null;
		String colName = null;
		String colCmnt = null;
		String colType = null;
		String colLen = null;
		String colPrec = null;
		String colScale = null;
		String colNoN = null;
		String colDflt = null;
		String indexName = null;
		String indexType = null;
		String constraintType = null;
		String colPos = null;
		String seqName = null;
		String minVal = null;
		String maxVal = null;
		String incSz = null;
		String cycFg = null;
		String odFg = null;
		String cacheSz = null;
		String lstNo = null;
		String synmOwner = null;
		String synmName = null;
		String tbOwner = null;
		String tbName = null;
		String dbLnk = null;
		String userName = null;
		String passWord = null;
		String host = null;
		String created = null;
		String acStat = null;
		String defTbsp = null;
		String tmpTbsp = null;
		String grntee = null;
		String grntor = null;
		String grntrl = null;
		String prvs = null;
		String grntabl = null;
		String hrchy = null;

		String objName = null;
		String objTyp = null;
		String pctFree = null;
		String pctUsed = null;
		String iniTrns = null;
		String freeLst = null;
		String flstGrp = null;
		String bufPool = null;
		String tblSpace = null;
		String logging = null;
		String segByts = null;

		String fkName = null;
		String fkCol = null;
		String fkColPos = null;
		String rtbName = null;
		String rfkName = null;
		String rfkCol = null;
		String rfkColPos = null;

		CmnProps cp = null;
		CmnAccessObjects dao = null;
		
		try {
			cp = new CmnProps();
			cp.setProperty(database);
			
			if (cp.dbType > cp.DB_TYPE_MYSQL || cp.dbType <0){
				throw new Exception("f[^x[XΏۊOłB[" + cp.DB_TYPE_NAME[cp.dbType] + "]");
			}
			if(cp.outFolder != null){
				folder = new File(cp.outFolder);
			} else {
				if(database != null){
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/" + cp.metaFolder + "_" + database.toUpperCase() + "_" + CmnUtils.getYmdhm());
				} else {
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/" + cp.metaFolder + "_" + cp.DB_TYPE_NAME[cp.dbType].toUpperCase() + "_" + CmnUtils.getYmdhm());
				}
				folder.mkdir();
			}

			CmnUtils.infoPrint("-->o͐tH_='" + folder + "'");
			CmnUtils.infoPrint("^f[^A[hJn܂B");

			// Connect
			dao = new CmnAccessObjects(cp);
			conn = dao.connect();
			// Def tsv Writing start
			for(int i=0;i<cp.meta_sql[cp.dbType].length;i++){
				if(!cp.meta_sql[cp.dbType][i].equals("")){
					dao.select(cp.meta_sql[cp.dbType][i]);
					CmnUtils.writeSeparator(folder + "/" + cp.WK_FILE_NAME[i] + "_" + database +"." + cp.fileExtension, dao.getColumnCount(), dao.getArrayList(), cp.delimiter);
				} else {
					CmnUtils.emptyFile(folder + "/" + cp.WK_FILE_NAME[i] + "_" + database +"." + cp.fileExtension);
				}
			}
			// Def tsv Writing end

			// Table Contents start
			br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_TABLE] + "_" + database + "." + cp.fileExtension));
			subFolder = new File(folder + "/TABLES");
			subFolder.mkdir();
			pw[CREATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_TABLE]))));
			pw[DROP] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_TABLE]))));
			pw[TRUNCATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.TRUNCATE_TABLE]))));

			tableName = "";
			tableCmnt = "";
			colName = "";
			colCmnt = "";
			colType = "";
			colLen = "";
			colPrec = "";
			colScale = "";
			colNoN = "";
			colDflt = "";

			StringBuffer sbTbCnts = new StringBuffer();
			StringBuffer sbTbCmnt = new StringBuffer();
			while((strLine=br[WK_FILE].readLine()) != null){
				if(!strLine.equals("")){
					strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
					if (!tableName.equals("")){
						sbTbCnts.append("    " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
						sbTbCnts.append(" " + colType);
						if(!colCmnt.equals(""))sbTbCmnt.append(commentOnColumn(cp, tableName, colName, colCmnt, cp.TYPE_TABLE));
						if(!colCmnt.equals(""))sbTbCmnt.append(cp.lineSeparator);
						if(CmnUtils.isColPrec(colType, colPrec)){
							sbTbCnts.append("(" + colPrec);
							if (!CmnUtils.isEmpty(colScale) && !colScale.equals("0"))sbTbCnts.append("," + colScale);
							sbTbCnts.append(")");
						} else if (CmnUtils.isColLength(colType)){
							if(colLen.equals("-1")){
								sbTbCnts.append("(max)");
							} else {
								sbTbCnts.append("(" + CmnUtils.getColLength(colType, colLen) + ")");
							}
						}
						if (!CmnUtils.isEmpty(colDflt)){
							if(CmnUtils.split(strLine, cp.SQL_COMMENT_MARK[cp.dbType]).length > 0){
								String [] colDfltAry = CmnUtils.split(colDflt, cp.SQL_COMMENT_MARK[cp.dbType]);
								if (cp.dbType == cp.DB_TYPE_MYSQL && !CmnUtils.isReserved(colDfltAry[0].trim())){
									sbTbCnts.append(" DEFAULT '" + colDfltAry[0].trim() + "'");
								} else {
									sbTbCnts.append(" DEFAULT " + colDfltAry[0].trim());
								}
							} else {
								if (cp.dbType == cp.DB_TYPE_MYSQL && !CmnUtils.isReserved(colDflt.trim())){
									sbTbCnts.append(" DEFAULT " + colDflt.trim() + "'");
								} else {
									sbTbCnts.append(" DEFAULT " + colDflt.trim());
								}
							}
						}
						if (!CmnUtils.isEmpty(colNoN)){
							sbTbCnts.append(" NOT NULL");
						} else {
							sbTbCnts.append(" NULL");
						}
						if (!strSplit[LINE][COL01].equals(tableName)){
							pw[CREATE].println(cp.SQL_PREFIX[cp.dbType] + "TABLES/" + tableName + ".sql");
							pw[DROP].print("DROP TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tableName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.DROP_OPTION[cp.dbType] + cp.SQL_TERMINATOR[cp.dbType]);
							pw[TRUNCATE].print("TRUNCATE TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tableName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
							sbTbCnts.append(cp.lineSeparator);
							sbTbCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
							sbTbCnts.append(cp.lineSeparator);
							pw[CONTENTS] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + tableName + ".sql"))));
							strSplit[TBL_CONTENTS] = CmnUtils.split(sbTbCnts.toString(), cp.lineSeparator);
							for(int i=0;i<strSplit[TBL_CONTENTS].length;i++)if(!strSplit[TBL_CONTENTS][i].trim().equals(""))pw[CONTENTS].println(strSplit[TBL_CONTENTS][i]);
							strSplit[TBL_COMMENTS] = CmnUtils.split(sbTbCmnt.toString(), cp.lineSeparator);
							for(int i=0;i<strSplit[TBL_COMMENTS].length;i++)if(!strSplit[TBL_COMMENTS][i].trim().equals(""))pw[CONTENTS].println(strSplit[TBL_COMMENTS][i]);
							pw[CONTENTS].close();
							pw[CONTENTS] = null;
							CmnUtils.infoPrint(String.format("%1$-42s","[TABLE] " + tableName) + " ^f[^A[h܂B");
							sbTbCnts = new StringBuffer();
							sbTbCmnt = new StringBuffer();
							sbTbCnts.append("CREATE TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
							sbTbCnts.append(cp.lineSeparator);
							sbTbCnts.append("(");
							sbTbCnts.append(cp.lineSeparator);
							if(!CmnUtils.isEmpty(strSplit[LINE][COL02]))sbTbCmnt.append(commentOnTable(cp, strSplit[LINE][COL01], strSplit[LINE][COL02], cp.TYPE_TABLE));
							if(!CmnUtils.isEmpty(strSplit[LINE][COL02]))sbTbCmnt.append(cp.lineSeparator);
						} else {
							sbTbCnts.append(",");
							sbTbCnts.append(cp.lineSeparator);
						}
					}
					else {
						sbTbCnts.append("CREATE TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
						sbTbCnts.append(cp.lineSeparator);
						sbTbCnts.append("(");
						sbTbCnts.append(cp.lineSeparator);
						if(!CmnUtils.isEmpty(strSplit[LINE][COL02]))sbTbCmnt.append(commentOnTable(cp, strSplit[LINE][COL01], strSplit[LINE][COL02], cp.TYPE_TABLE));
						if(!CmnUtils.isEmpty(strSplit[LINE][COL02]))sbTbCmnt.append(cp.lineSeparator);
					}
					for(int i=0;i<strSplit[LINE].length;i++)CmnUtils.debugPrint("'" + strSplit[LINE][i] + "'");

					tableName = strSplit[LINE][COL01];
					tableCmnt = strSplit[LINE][COL02];
					colName = strSplit[LINE][COL03];
					colCmnt = strSplit[LINE][COL04];
					colType = strSplit[LINE][COL05];
					colLen = strSplit[LINE][COL06];
					colPrec = strSplit[LINE][COL07];
					colScale = strSplit[LINE][COL08];
					colNoN = strSplit[LINE][COL09];
					colDflt = strSplit[LINE][COL10];
				}
			}

			if (!tableName.equals("")){
				sbTbCnts.append("    " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
				sbTbCnts.append(" " + colType);
				if(!colCmnt.equals("")){
					sbTbCmnt.append(commentOnColumn(cp, tableName, colName, colCmnt, cp.TYPE_TABLE));
					sbTbCmnt.append(cp.lineSeparator);
				}
				if(CmnUtils.isColPrec(colType, colPrec)){
					sbTbCnts.append("(" + colPrec);
					if (!CmnUtils.isEmpty(colScale) && !CmnUtils.isEmpty(colScale))sbTbCnts.append("," + colScale);
					sbTbCnts.append(")");
				} else if (CmnUtils.isColLength(colType)){
					if(colLen.equals("-1")){
						sbTbCnts.append("(max)");
					} else {
						sbTbCnts.append("(" + CmnUtils.getColLength(colType, colLen) + ")");
					}
				}
				if (!CmnUtils.isEmpty(colDflt)){
					if (cp.dbType == cp.DB_TYPE_MYSQL && !CmnUtils.isReserved(colDflt.trim())){
						sbTbCnts.append(" DEFAULT '" + colDflt.trim() + "'");
					} else {
						sbTbCnts.append(" DEFAULT " + colDflt.trim());
					}
				}
				if (!CmnUtils.isEmpty(colNoN)){
					sbTbCnts.append(" NOT NULL");
				} else {
					sbTbCnts.append(" NULL");
				}
				pw[CREATE].println(cp.SQL_PREFIX[cp.dbType] + "TABLES/" + tableName + ".sql");
				pw[DROP].print("DROP TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tableName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.DROP_OPTION[cp.dbType] + cp.SQL_TERMINATOR[cp.dbType]);
				pw[TRUNCATE].print("TRUNCATE TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tableName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				sbTbCnts.append(cp.lineSeparator);
				sbTbCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
				sbTbCnts.append(cp.lineSeparator);
				pw[CONTENTS] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + tableName + ".sql"))));
				strSplit[TBL_CONTENTS] = CmnUtils.split(sbTbCnts.toString(), cp.lineSeparator);
				for(int i=0;i<strSplit[TBL_CONTENTS].length;i++)if(!strSplit[TBL_CONTENTS][i].trim().equals(""))pw[CONTENTS].println(strSplit[TBL_CONTENTS][i]);
				strSplit[TBL_COMMENTS] = CmnUtils.split(sbTbCmnt.toString(), cp.lineSeparator);
				for(int i=0;i<strSplit[TBL_COMMENTS].length;i++)if(!strSplit[TBL_COMMENTS][i].trim().equals(""))pw[CONTENTS].println(strSplit[TBL_COMMENTS][i]);
				pw[CONTENTS].close();
				pw[CONTENTS] = null;
				CmnUtils.infoPrint(String.format("%1$-42s","[TABLE] " + tableName) + " ^f[^A[h܂B");
			}
			for(int i=0;i<pw.length;i++){
				if(pw[i]!=null){
					pw[i].close();
					pw[i]=null;
				}
			}
			br[WK_FILE].close();
			br[WK_FILE] = null;
			// Table Contents end

			// Index Contents start
			br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_INDEX] + "_" + database + "." + cp.fileExtension));
			pw[W_CREATE_PKEY] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]))));
			pw[W_CREATE_UKEY] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]))));
			pw[W_CREATE_INDEX] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]))));
			pw[W_DROP_PKEY] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PKEY]))));
			pw[W_DROP_UKEY] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_UKEY]))));
			pw[W_DROP_INDEX] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_INDEX]))));

			//Initial Process
			tableName = "";
			indexName = "";
			indexType = "";
			constraintType = "";
			colName = "";
			colPos = "";
			StringBuffer sbIxCnts = new StringBuffer();
			StringBuffer sbIx2Cnts = new StringBuffer();
			StringBuffer sbIx3Cnts = new StringBuffer();

			//Loop Process
			while((strLine=br[WK_FILE].readLine()) != null){
				if(!strLine.equals("")){
					strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
					//Not 1st Line Process
					if (!indexName.equals("")){
						if (!strSplit[LINE][COL02].equals(indexName) || !strSplit[LINE][COL01].equals(tableName)){
							//Post Process
							if (colPos.equals("1")){
								sbIxCnts.append(cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
							} else {
								sbIxCnts.append(", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
							}
							sbIxCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
							sbIxCnts.append(cp.lineSeparator);
							if (constraintType.equals("U"))sbIx2Cnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
							sbIx2Cnts.append(cp.lineSeparator);
							sbIx3Cnts.append(cp.lineSeparator);

							//Write Buffer
							if (constraintType.equals("P")){
								strSplit[IDX_CONTENTS_1] = CmnUtils.split(sbIxCnts.toString(), cp.lineSeparator);
								for(int i=0;i<strSplit[IDX_CONTENTS_1].length;i++)if(!strSplit[IDX_CONTENTS_1][i].trim().equals(""))pw[W_CREATE_PKEY].println(strSplit[IDX_CONTENTS_1][i]);
								strSplit[IDX_CONTENTS_2] = CmnUtils.split(sbIx2Cnts.toString(), cp.lineSeparator);
								for(int i=0;i<strSplit[IDX_CONTENTS_2].length;i++)if(!strSplit[IDX_CONTENTS_2][i].trim().equals(""))pw[W_DROP_PKEY].println(strSplit[IDX_CONTENTS_2][i]);
							} else if (constraintType.equals("U")){
								strSplit[IDX_CONTENTS_1] = CmnUtils.split(sbIxCnts.toString(), cp.lineSeparator);
								for(int i=0;i<strSplit[IDX_CONTENTS_1].length;i++)if(!strSplit[IDX_CONTENTS_1][i].trim().equals(""))pw[W_CREATE_UKEY].println(strSplit[IDX_CONTENTS_1][i]);
								strSplit[IDX_CONTENTS_2] = CmnUtils.split(sbIx2Cnts.toString(), cp.lineSeparator);
								for(int i=0;i<strSplit[IDX_CONTENTS_2].length;i++)if(!strSplit[IDX_CONTENTS_2][i].trim().equals(""))pw[W_DROP_UKEY].println(strSplit[IDX_CONTENTS_2][i]);
							} else {
								strSplit[IDX_CONTENTS_1] = CmnUtils.split(sbIxCnts.toString(), cp.lineSeparator);
								for(int i=0;i<strSplit[IDX_CONTENTS_1].length;i++)if(!strSplit[IDX_CONTENTS_1][i].trim().equals(""))pw[W_CREATE_INDEX].println(strSplit[IDX_CONTENTS_1][i]);
							}
							strSplit[IDX_CONTENTS_3] = CmnUtils.split(sbIx3Cnts.toString(), cp.lineSeparator);
							for(int i=0;i<strSplit[IDX_CONTENTS_3].length;i++)if(!strSplit[IDX_CONTENTS_3][i].trim().equals(""))pw[W_DROP_INDEX].println(strSplit[IDX_CONTENTS_3][i]);

							//Initial Process
							sbIxCnts = new StringBuffer();
							sbIx2Cnts = new StringBuffer();
							sbIx3Cnts = new StringBuffer();

							//Index Changed Process
							if (strSplit[LINE][COL04].equals("P")){
								if (cp.dbType == cp.DB_TYPE_MYSQL){
									sbIxCnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT PRIMARY KEY(");
									sbIx2Cnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP PRIMARY KEY" + cp.SQL_TERMINATOR[cp.dbType]);
								} else {
									sbIxCnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " PRIMARY KEY(");
									sbIx2Cnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
								}
							} else if (strSplit[LINE][COL04].equals("U")){
								sbIxCnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " UNIQUE(");
								sbIx2Cnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP UNIQUE(");
							} else {
								if (cp.dbType == cp.DB_TYPE_MYSQL && !strSplit[LINE][COL03].equals("") && !strSplit[LINE][COL03].equals("BTREE")){
									sbIxCnts.append("CREATE " + strSplit[LINE][COL03] + " INDEX " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ON " + strSplit[LINE][COL01] + "(");
								} else {
									sbIxCnts.append("CREATE INDEX " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ON " + strSplit[LINE][COL01] + "(");
								}
							}
							sbIx3Cnts.append("DROP INDEX " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
						} else if (strSplit[LINE][COL02].equals(indexName) && strSplit[LINE][COL01].equals(tableName)){
							if (colPos.equals("1")){
								sbIxCnts.append(cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
							} else {
								sbIxCnts.append(", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
							}
						}
					}

					//1st Line Process
					else {
						if (strSplit[LINE][COL04].equals("P")){
							if (cp.dbType == cp.DB_TYPE_MYSQL){
								sbIxCnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT  PRIMARY KEY(");
								sbIx2Cnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP PRIMARY KEY" + cp.SQL_TERMINATOR[cp.dbType]);
							} else {
								sbIxCnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " PRIMARY KEY(");
								sbIx2Cnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
							}
						} else if (strSplit[LINE][COL04].equals("U")){
							sbIxCnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " UNIQUE(");
							sbIx2Cnts.append("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP UNIQUE(");
						} else {
							if (cp.dbType == cp.DB_TYPE_MYSQL && !strSplit[LINE][COL03].equals("") && !strSplit[LINE][COL03].equals("BTREE")){
								sbIxCnts.append("CREATE " + strSplit[LINE][COL03] + " INDEX " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ON " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ "(");
							} else {
								sbIxCnts.append("CREATE INDEX " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ON " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ "(");
							}
						}
						sbIx3Cnts.append("DROP INDEX " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL02] + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
					}
					for(int i=0;i<strSplit[LINE].length;i++)CmnUtils.debugPrint("'" + strSplit[LINE][i] + "'");

					tableName = strSplit[LINE][COL01];
					indexName = strSplit[LINE][COL02];
					indexType = strSplit[LINE][COL03];
					constraintType = strSplit[LINE][COL04];
					colName = strSplit[LINE][COL05];
					colPos = strSplit[LINE][COL06];
				}
			}
			if (!indexName.equals("")){
				//Post Process
				if (colPos.equals("1")){
					sbIxCnts.append(cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
					if (constraintType.equals("U"))sbIx2Cnts.append(cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
				} else {
					sbIxCnts.append(", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
					if (constraintType.equals("U"))sbIx2Cnts.append(", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ colName + cp.DB_SQL_QUOTEDE[cp.dbType]);
				}
				sbIxCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
				sbIxCnts.append(cp.lineSeparator);
				if (constraintType.equals("U"))sbIx2Cnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
				sbIx2Cnts.append(cp.lineSeparator);
				sbIx3Cnts.append(cp.lineSeparator);

				//Write Buffer
				if (constraintType.equals("P")){
					strSplit[IDX_CONTENTS_1] = CmnUtils.split(sbIxCnts.toString(), cp.lineSeparator);
					for(int i=0;i<strSplit[IDX_CONTENTS_1].length;i++)if(!strSplit[IDX_CONTENTS_1][i].trim().equals(""))pw[W_CREATE_PKEY].println(strSplit[IDX_CONTENTS_1][i]);
					strSplit[IDX_CONTENTS_2] = CmnUtils.split(sbIx2Cnts.toString(), cp.lineSeparator);
					for(int i=0;i<strSplit[IDX_CONTENTS_2].length;i++)if(!strSplit[IDX_CONTENTS_2][i].trim().equals(""))pw[W_DROP_PKEY].println(strSplit[IDX_CONTENTS_2][i]);
				} else if (constraintType.equals("U")){
					strSplit[IDX_CONTENTS_1] = CmnUtils.split(sbIxCnts.toString(), cp.lineSeparator);
					for(int i=0;i<strSplit[IDX_CONTENTS_1].length;i++)if(!strSplit[IDX_CONTENTS_1][i].trim().equals(""))pw[W_CREATE_UKEY].println(strSplit[IDX_CONTENTS_1][i]);
					strSplit[IDX_CONTENTS_2] = CmnUtils.split(sbIx2Cnts.toString(), cp.lineSeparator);
					for(int i=0;i<strSplit[IDX_CONTENTS_2].length;i++)if(!strSplit[IDX_CONTENTS_2][i].trim().equals(""))pw[W_DROP_UKEY].println(strSplit[IDX_CONTENTS_2][i]);
				} else {
					strSplit[IDX_CONTENTS_1] = CmnUtils.split(sbIxCnts.toString(), cp.lineSeparator);
					for(int i=0;i<strSplit[IDX_CONTENTS_1].length;i++)if(!strSplit[IDX_CONTENTS_1][i].trim().equals(""))pw[W_CREATE_INDEX].println(strSplit[IDX_CONTENTS_1][i]);
				}
				strSplit[IDX_CONTENTS_3] = CmnUtils.split(sbIx3Cnts.toString(), cp.lineSeparator);
				for(int i=0;i<strSplit[IDX_CONTENTS_3].length;i++)if(!strSplit[IDX_CONTENTS_3][i].trim().equals(""))pw[W_DROP_INDEX].println(strSplit[IDX_CONTENTS_3][i]);
			}

			//Close Buffer
			for(int i=0;i<pw.length;i++){
				if(pw[i]!=null){
					pw[i].close();
					pw[i]=null;
				}
			}
			br[WK_FILE].close();
			br[WK_FILE] = null;
			// Index Contents end

			// View Contents start
			br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_VIEW] + "_" + database + "." + cp.fileExtension));
			subFolder = new File(folder + "/VIEWS");
			subFolder.mkdir();
			pw[CREATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_VIEW]))));
			pw[DROP] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_VIEW]))));
			while((strLine=br[WK_FILE].readLine()) != null){
				strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
				CmnUtils.debugPrint("'" + strSplit[LINE][COL01] + "'");
				pw[CREATE].println(cp.SQL_PREFIX[cp.dbType] + "VIEWS/" + strSplit[LINE][COL01] + ".sql");
				pw[DROP].print("DROP VIEW " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				if (strSplit[LINE].length>1)CmnUtils.debugPrint("'" + strSplit[LINE][COL02] + "'");
				pw[CONTENTS] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + strSplit[LINE][COL01] + ".sql"))));
				
				stmt = dao.prepareSql(cp.sql_view_column_and_comment[cp.dbType]);
				stmt.setString(1,strSplit[LINE][COL01]);
				dao.executeSql();
				alData = dao.getArrayList();
				columnCount = dao.getColumnCount();
				if (cp.dbType == cp.DB_TYPE_ORACLE || cp.dbType == cp.DB_TYPE_MYSQL){
					pw[CONTENTS].println("/* " + strSplit[LINE][COL01] + " */");
					if (cp.dbType == cp.DB_TYPE_ORACLE){
						pw[CONTENTS].println("CREATE OR REPLACE VIEW " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
					} else {
						pw[CONTENTS].println("CREATE VIEW " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
					}
					pw[CONTENTS].println("(");
					for(int i=0;i<alData.size();i++){
						if ((i+1) % columnCount == 1){
							if (i == 0){
								if (!alData.get(i+1).trim().equals("")){
									pw[CONTENTS].println("    " + cp.DB_SQL_QUOTEDS[cp.dbType]+ alData.get(i) + cp.DB_SQL_QUOTEDE[cp.dbType]+ "    -- " + alData.get(i+1));
								} else {
									pw[CONTENTS].println("    " + cp.DB_SQL_QUOTEDS[cp.dbType]+ alData.get(i) + cp.DB_SQL_QUOTEDE[cp.dbType]);
								}
							} else {
								if (!alData.get(i+1).trim().equals("")){
									pw[CONTENTS].println("    ," + cp.DB_SQL_QUOTEDS[cp.dbType]+ alData.get(i) + cp.DB_SQL_QUOTEDE[cp.dbType]+ "    -- " + alData.get(i+1));
								} else {
									pw[CONTENTS].println("    ," + cp.DB_SQL_QUOTEDS[cp.dbType]+ alData.get(i) + cp.DB_SQL_QUOTEDE[cp.dbType]);
								}
							}
						}
					}
					pw[CONTENTS].println(")");
					pw[CONTENTS].println("AS");
				}
				stmt = dao.prepareSql(cp.sql_view_text[cp.dbType]);
				stmt.setString(1,strSplit[LINE][COL01]);
				dao.executeSql();
				alData2 = dao.getArrayList();
				strContents = alData2.get(0).trim();
				strSplit[1] = CmnUtils.split(strContents, cp.lineSeparator);
				for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[CONTENTS].println(strSplit[1][i].replaceAll("\"\"","\"").replaceAll(Pattern.quote(cp.user.toUpperCase() + "."),"").replaceAll(Pattern.quote(cp.user.toLowerCase() + "."),""));
				pw[CONTENTS].print(cp.SQL_TERMINATOR[cp.dbType]);

				if (!strSplit[LINE][COL02].trim().equals(""))pw[CONTENTS].print(commentOnTable(cp, strSplit[LINE][COL01], strSplit[LINE][COL02], cp.TYPE_VIEW));
				for(int i=0;i<alData.size();i++){
					if ((i+1) % columnCount == 0){
						if (!alData.get(i).trim().equals(""))pw[CONTENTS].print(commentOnColumn(cp, strSplit[LINE][COL01], alData.get(i-1), alData.get(i), cp.TYPE_VIEW));
					}
				}
				pw[CONTENTS].close();
				pw[CONTENTS] = null;
				CmnUtils.infoPrint(String.format("%1$-42s", "[VIEW] " + strSplit[LINE][COL01]) + " ^f[^A[h܂B");
			}
			for(int i=0;i<pw.length;i++){
				if(pw[i]!=null){
					pw[i].close();
					pw[i]=null;
				}
			}
			br[WK_FILE].close();
			br[WK_FILE] = null;
			// View Contents end

			// Procedure Contents start
			br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_PROCEDURE] + "_" + database + "." + cp.fileExtension));
			subFolder = new File(folder + "/PROCEDURES");
			subFolder.mkdir();
			pw[CREATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PROCEDURE]))));
			pw[DROP] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PROCEDURE]))));
			while((strLine=br[WK_FILE].readLine()) != null){
				strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
				CmnUtils.debugPrint("'" + strSplit[LINE][COL01] + "'");
				pw[CREATE].println(cp.SQL_PREFIX[cp.dbType] + "PROCEDURES/" + strSplit[LINE][COL01] + ".sql");
				pw[DROP].print("DROP " + strSplit[LINE][COL02] + " " + cp.DB_SQL_QUOTEDS[cp.dbType] + strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType] + cp.SQL_TERMINATOR[cp.dbType]);
				if (strSplit[LINE].length>1)CmnUtils.debugPrint("'" + strSplit[LINE][COL02] + "'");
				pw[CONTENTS] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + strSplit[LINE][COL01] + ".sql"))));
				if (cp.dbType == cp.DB_TYPE_ORACLE){
					pw[CONTENTS].println("/* " + strSplit[LINE][COL01] + " */");
					pw[CONTENTS].print("CREATE OR REPLACE ");
				}
				if (cp.dbType == cp.DB_TYPE_MYSQL){
					if(strSplit[LINE][COL02].equals("TRIGGER")){
						stmt = dao.prepareSql("show create trigger " + cp.DB_SQL_QUOTEDS[cp.dbType] + strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
					} else if (strSplit[LINE][COL02].equals("PROCEDURE")){
						stmt = dao.prepareSql("show create procedure " + cp.DB_SQL_QUOTEDS[cp.dbType] + strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
					} else if (strSplit[LINE][COL02].equals("FUNCTION")){
						stmt = dao.prepareSql("show create function " + cp.DB_SQL_QUOTEDS[cp.dbType] + strSplit[LINE][COL01] + cp.DB_SQL_QUOTEDE[cp.dbType]);
					}
				} else {
					stmt = dao.prepareSql(cp.sql_proc[cp.dbType]);
					stmt.setString(1,strSplit[LINE][COL02]);
					stmt.setString(2,strSplit[LINE][COL01]);
				}
				dao.executeSql();
				alData = dao.getArrayList();
				boolean mysql_s_flag = false;
				boolean mysql_e_flag = false;
				for(int i=0;i<alData.size();i++){
					strContents = alData.get(i);
					if (cp.dbType == cp.DB_TYPE_MYSQL){
						if(!mysql_s_flag){
							String [] spcDiv = CmnUtils.split(strContents," ");
							if(spcDiv.length >0 && spcDiv[0].toUpperCase().equals("CREATE")){
								mysql_s_flag = true;
								for(int j=0;j<spcDiv.length;j++){
									if(j==0){
										pw[CONTENTS].print(spcDiv[j]);
									} else if(j!=1) {
										pw[CONTENTS].print(" " + spcDiv[j]);
									}
								}
							}
						} else if(mysql_s_flag && !mysql_e_flag){
							String [] spcDiv = CmnUtils.split(strContents," ");
							if(spcDiv.length >0 && CmnUtils.isCharacterSet(spcDiv[0])){
								mysql_e_flag = true;
								pw[CONTENTS].println("");
							} else {
								for(int j=0;j<spcDiv.length;j++){
									if(j==0){
										pw[CONTENTS].print(spcDiv[j]);
									} else {
										pw[CONTENTS].print(" " + spcDiv[j]);
									}
								}
							}
						}
					} else {
						if(!strContents.equals(""))pw[CONTENTS].println(strContents.replaceAll("\"\"","\"").replaceAll(Pattern.quote(cp.user.toUpperCase() + "."),"").replaceAll(Pattern.quote(cp.user.toLowerCase() + "."),""));
					}
				}
				
				if (cp.dbType == cp.DB_TYPE_SQLSERVER){
					pw[CONTENTS].print(cp.SQL_TERMINATOR[cp.dbType]);
				}
				pw[CONTENTS].close();
				pw[CONTENTS] = null;
				CmnUtils.infoPrint(String.format("%1$-42s","[PROCEDURE] " + strSplit[LINE][COL01]) + " ^f[^A[h܂B");
			}
			for(int i=0;i<pw.length;i++){
				if(pw[i]!=null){
					pw[i].close();
					pw[i]=null;
				}
			}
			br[WK_FILE].close();
			br[WK_FILE] = null;
			// Procedure Contents end

			// Sequence Contents start
			br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_SEQ] + "_" + database + "." + cp.fileExtension));
			pw[CREATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SEQUENCE]))));
			pw[DROP] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SEQUENCE]))));

			while((strLine=br[WK_FILE].readLine()) != null){
				strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
				seqName = strSplit[LINE][COL01];
				minVal = strSplit[LINE][COL02];
				maxVal = strSplit[LINE][COL03];
				incSz = strSplit[LINE][COL04];
				cycFg = strSplit[LINE][COL05];
				odFg = strSplit[LINE][COL06];
				cacheSz = strSplit[LINE][COL07];
				if(cacheSz.equals("0"))cacheSz="10";
				lstNo = strSplit[LINE][COL08];
				pw[CREATE].print("CREATE SEQUENCE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ seqName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " MINVALUE " + minVal + " MAXVALUE " + maxVal + " INCREMENT BY " + incSz + " START WITH " + lstNo);
				if (cp.dbType == cp.DB_TYPE_ORACLE){
					pw[CREATE].print(" CACHE " + cacheSz);
					if (odFg.equals("N")){
						pw[CREATE].print(" NOORDER");
					} else {
						pw[CREATE].print(" ORDER");
					}
					if (cycFg.equals("N")){
						pw[CREATE].print(" NOCYCLE");
					} else {
						pw[CREATE].print(" CYCLE");
					}
				} else if (cp.dbType == cp.DB_TYPE_SQLSERVER){
					if (cacheSz.equals("")){
						pw[CREATE].print(" NO CACHE");
					} else {
						pw[CREATE].print(" CACHE " + cacheSz);
					}
					if (cycFg.equals("N")){
						pw[CREATE].print(" NO CYCLE");
					} else {
						pw[CREATE].print(" CYCLE");
					}
				}
				pw[CREATE].print(cp.SQL_TERMINATOR[cp.dbType]);
				pw[DROP].print("DROP SEQUENCE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ seqName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				for(int i=0;i<strSplit[LINE].length;i++)CmnUtils.debugPrint("'" + strSplit[LINE][i] + "'");
			}
			for(int i=0;i<pw.length;i++){
				if(pw[i]!=null){
					pw[i].close();
					pw[i]=null;
				}
			}
			br[WK_FILE].close();
			br[WK_FILE] = null;
			// Sequence Contents end

			// Synonym Contents start
			br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_SYNONYM] + "_" + database + "." + cp.fileExtension));
			pw[CREATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SYNONYM]))));
			pw[DROP] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SYNONYM]))));

			while((strLine=br[WK_FILE].readLine()) != null){
				strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
				synmName = strSplit[LINE][COL01];
				tbOwner = strSplit[LINE][COL02];
				tbName = strSplit[LINE][COL03];
				dbLnk = strSplit[LINE][COL04];
				
				pw[CREATE].print("CREATE SYNONYM " + cp.DB_SQL_QUOTEDS[cp.dbType]+ synmName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " FOR ");
				if(cp.dbType == cp.DB_TYPE_ORACLE){
					if(!dbLnk.equals("")){
						pw[CREATE].print(cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ "@" + cp.DB_SQL_QUOTEDS[cp.dbType]+ dbLnk + cp.DB_SQL_QUOTEDS[cp.dbType]);
					} else {
						pw[CREATE].print(cp.DB_SQL_QUOTEDS[cp.dbType]+ tbOwner + cp.DB_SQL_QUOTEDE[cp.dbType]+ "." + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]);
					}
				} else if(cp.dbType == cp.DB_TYPE_SQLSERVER){
					pw[CREATE].print(tbName);
				}
				pw[CREATE].print(cp.SQL_TERMINATOR[cp.dbType]);
				pw[DROP].print("DROP SYNONYM " + cp.DB_SQL_QUOTEDS[cp.dbType]+ synmName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				for(int i=0;i<strSplit[LINE].length;i++)CmnUtils.debugPrint("'" + strSplit[LINE][i] + "'");
			}
			for(int i=0;i<pw.length;i++){
				if(pw[i]!=null){
					pw[i].close();
					pw[i]=null;
				}
			}
			br[WK_FILE].close();
			br[WK_FILE] = null;
			// Synonym Contents end

			// Fk Contents start
			File tsvFile = new File(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_FK] + "_" + database + "." + cp.fileExtension);
			if (tsvFile.length() > 0) {
				br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_FK] + "_" + database + "." + cp.fileExtension));
				pw[CREATE] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_FK]))));
				pw[DROP] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_FK]))));
				tbName = "";
				fkName = "";
				fkCol = "";
				fkColPos = "";
				rtbName = "";
				rfkCol = "";
				rfkColPos = "";
				
				while((strLine=br[WK_FILE].readLine()) != null){
					strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
					if(!fkName.equals(strSplit[LINE][COL02]) && !fkName.equals("")){
						pw[CREATE].print("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " FOREIGN KEY (" + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkCol + cp.DB_SQL_QUOTEDE[cp.dbType]+ ") REFERENCES " + cp.DB_SQL_QUOTEDS[cp.dbType]+ rtbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " (" + cp.DB_SQL_QUOTEDS[cp.dbType]+ rfkCol + cp.DB_SQL_QUOTEDE[cp.dbType]+ ")" + cp.SQL_TERMINATOR[cp.dbType]);
						if(cp.dbType == cp.DB_TYPE_MYSQL){
							pw[DROP].print("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP FOREIGN KEY " + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[DROP].print("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
						}
						for(int i=0;i<strSplit[LINE].length;i++)CmnUtils.debugPrint("'" + strSplit[LINE][i] + "'");
						tbName = strSplit[LINE][COL01];
						fkName = strSplit[LINE][COL02];
						fkCol = strSplit[LINE][COL03];
						fkColPos = strSplit[LINE][COL04];
						rtbName = strSplit[LINE][COL05];
						rfkCol = strSplit[LINE][COL06];
						rfkColPos = strSplit[LINE][COL07];
					} else {
						if(fkName.equals("")){
							tbName = strSplit[LINE][COL01];
							fkName = strSplit[LINE][COL02];
							fkCol = strSplit[LINE][COL03];
							fkColPos = strSplit[LINE][COL04];
							rtbName = strSplit[LINE][COL05];
							rfkCol = strSplit[LINE][COL06];
							rfkColPos = strSplit[LINE][COL07];
						} else {
							if (
								(cp.dbType == cp.DB_TYPE_ORACLE && strSplit[LINE][COL04].equals(strSplit[LINE][COL07])) ||
								 cp.dbType != cp.DB_TYPE_ORACLE
							) {
								fkCol = fkCol + cp.DB_SQL_QUOTEDE[cp.dbType]+ ", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL03];
								rfkCol = rfkCol + cp.DB_SQL_QUOTEDE[cp.dbType]+ ", " + cp.DB_SQL_QUOTEDS[cp.dbType]+ strSplit[LINE][COL06];
							}
						}
					}
					
				}
				pw[CREATE].print("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " ADD CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " FOREIGN KEY (" + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkCol + cp.DB_SQL_QUOTEDE[cp.dbType]+ ") REFERENCES " + cp.DB_SQL_QUOTEDS[cp.dbType]+ rtbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " (" + cp.DB_SQL_QUOTEDS[cp.dbType]+ rfkCol + cp.DB_SQL_QUOTEDE[cp.dbType]+ ")" + cp.SQL_TERMINATOR[cp.dbType]);
				if(cp.dbType == cp.DB_TYPE_MYSQL){
					pw[DROP].print("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP FOREIGN KEY " + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				} else {
					pw[DROP].print("ALTER TABLE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tbName + cp.DB_SQL_QUOTEDE[cp.dbType]+ " DROP CONSTRAINT " + cp.DB_SQL_QUOTEDS[cp.dbType]+ fkName + cp.DB_SQL_QUOTEDE[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				}
					for(int i=0;i<pw.length;i++){
					if(pw[i]!=null){
						pw[i].close();
						pw[i]=null;
					}
				}
				br[WK_FILE].close();
				br[WK_FILE] = null;
			}
			// Fk Contents end

			// Rhysical Contents start
			if(cp.isPhysical && cp.dbType == cp.DB_TYPE_ORACLE){
				// physical index setting
				br[WK_FILE] = new BufferedReader(new FileReader(folder + "/" + cp.WK_FILE_NAME[cp.TYPE_OBJ] + "_" + database + "." + cp.fileExtension));
				br[R_CREATE_PKEY] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]));
				br[R_CREATE_UKEY] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]));
				br[R_CREATE_INDEX] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]));
				pw[W_CREATE_PKEY] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY] + "." + phyfileExtension))));
				pw[W_CREATE_UKEY] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY] + "." + phyfileExtension))));
				pw[W_CREATE_INDEX] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX] + "." + phyfileExtension))));
				alData = new ArrayList<String>();
				int rowNo;
				String [] rowData;
				while((strLine=br[WK_FILE].readLine()) != null){
					strSplit[LINE] = CmnUtils.split(strLine, cp.delimiter);
					for(int i=0;i<strSplit[LINE].length;i++)alData.add(strSplit[LINE][i]);
				}
				while((strLine=br[R_CREATE_PKEY].readLine()) != null){
					strSplit[LINE] = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[LINE][COL06].replaceAll("\"",""));
					if (rowNo != -1){
						rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						CmnUtils.debugPrint(strSplit[LINE][COL06] + ":" + rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[COL01];
						objName = rowData[COL02];
						objTyp = rowData[COL03];
						pctFree = rowData[COL04];
						pctUsed = rowData[COL05];
						iniTrns = rowData[COL06];
						freeLst = rowData[COL07];
						flstGrp = rowData[COL08];
						bufPool = rowData[COL09];
						tblSpace = rowData[COL10];
						logging = rowData[COL11];
						segByts = rowData[COL12];
						pw[W_CREATE_PKEY].print(strLine.replace(';',' '));
						pw[W_CREATE_PKEY].print("USING INDEX PCTFREE " + pctFree);
						pw[W_CREATE_PKEY].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[W_CREATE_PKEY].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[W_CREATE_PKEY].print(" FREELIST GROUPS " + flstGrp);
						pw[W_CREATE_PKEY].print(" BUFFER_POOL " + bufPool + ")");
						pw[W_CREATE_PKEY].print(" TABLESPACE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tblSpace + cp.DB_SQL_QUOTEDE[cp.dbType]);
						if(logging.equals("NO")){
							pw[W_CREATE_PKEY].print(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[W_CREATE_PKEY].print(cp.SQL_TERMINATOR[cp.dbType]);
						}
					} else {
						pw[W_CREATE_PKEY].println(strLine);
						CmnUtils.errorPrint(strSplit[LINE][COL06] + ",UNUSABLE INDEX");
					}
				}
				while((strLine=br[R_CREATE_UKEY].readLine()) != null){
					strSplit[LINE] = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[LINE][COL06].replaceAll("\"",""));
					if (rowNo != -1){
						rowData = rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						CmnUtils.debugPrint(strSplit[LINE][COL06] + ":" + rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[COL01];
						objName = rowData[COL02];
						objTyp = rowData[COL03];
						pctFree = rowData[COL04];
						pctUsed = rowData[COL05];
						iniTrns = rowData[COL06];
						freeLst = rowData[COL07];
						flstGrp = rowData[COL08];
						bufPool = rowData[COL09];
						tblSpace = rowData[COL10];
						logging = rowData[COL11];
						segByts = rowData[COL12];
						pw[W_CREATE_UKEY].print(strLine.replace(';',' '));
						pw[W_CREATE_UKEY].print("USING INDEX PCTFREE " + pctFree);
						pw[W_CREATE_UKEY].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[W_CREATE_UKEY].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[W_CREATE_UKEY].print(" FREELIST GROUPS " + flstGrp);
						pw[W_CREATE_UKEY].print(" BUFFER_POOL " + bufPool + ")");
						pw[W_CREATE_UKEY].print(" TABLESPACE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tblSpace + cp.DB_SQL_QUOTEDE[cp.dbType]);
						if(logging.equals("NO")){
							pw[W_CREATE_UKEY].print(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[W_CREATE_UKEY].print(cp.SQL_TERMINATOR[cp.dbType]);
						}
					} else {
						pw[W_CREATE_UKEY].println(strLine);
						CmnUtils.errorPrint(strSplit[LINE][COL06] + ",UNUSABLE INDEX");
					}
				}
				while((strLine=br[R_CREATE_INDEX].readLine()) != null){
					strSplit[LINE] = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[LINE][COL03].replaceAll("\"",""));
					CmnUtils.debugPrint("rowNo=" + rowNo);
					if (rowNo != -1){
						rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[COL01];
						objName = rowData[COL02];
						objTyp = rowData[COL03];
						pctFree = rowData[COL04];
						pctUsed = rowData[COL05];
						iniTrns = rowData[COL06];
						freeLst = rowData[COL07];
						flstGrp = rowData[COL08];
						bufPool = rowData[COL09];
						tblSpace = rowData[COL10];
						logging = rowData[COL11];
						segByts = rowData[COL12];
						pw[W_CREATE_INDEX].print(strLine.replace(';',' '));
						pw[W_CREATE_INDEX].print("PCTFREE " + pctFree);
						pw[W_CREATE_INDEX].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[W_CREATE_INDEX].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[W_CREATE_INDEX].print(" FREELIST GROUPS " + flstGrp);
						pw[W_CREATE_INDEX].print(" BUFFER_POOL " + bufPool + ")");
						pw[W_CREATE_INDEX].print(" TABLESPACE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tblSpace + cp.DB_SQL_QUOTEDE[cp.dbType]);
						if(logging.equals("NO")){
							pw[W_CREATE_INDEX].print(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[W_CREATE_INDEX].print(cp.SQL_TERMINATOR[cp.dbType]);
						}
					} else {
						pw[W_CREATE_INDEX].println(strLine);
						CmnUtils.errorPrint(strSplit[LINE][COL03] + ",UNUSABLE INDEX");
					}
				}
				for(int i=0;i<pw.length;i++){
					if(pw[i]!=null){
						pw[i].close();
						pw[i]=null;
					}
				}
				for(int i=0;i<br.length;i++){
					if(br[i]!=null){
						br[i].close();
						br[i]=null;
					}
				}
				
				File [] fmFl = new File[3];
				File [] toFl = new File[3];
				
				fmFl[W_CREATE_PKEY] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY] + "." + phyfileExtension);
				fmFl[W_CREATE_UKEY] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY] + "." + phyfileExtension);
				fmFl[W_CREATE_INDEX] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX] + "." + phyfileExtension);
				toFl[W_CREATE_PKEY] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]);
				toFl[W_CREATE_UKEY] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]);
				toFl[W_CREATE_INDEX] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]);
				for(int i=0;i<toFl.length;i++){
					CmnUtils.debugPrint(fmFl[i].toString() + ">" + toFl[i].toString());
					toFl[i].delete();
					fmFl[i].renameTo(toFl[i]);
				}
				
				// physical table setting
				File tbDir = new File(folder + "/TABLES");
				File [] tbFiles = tbDir.listFiles();
				File tb = null;
				File oTb = null;
				for(int i=0;i<tbFiles.length;i++){
					tb = tbFiles[i];
					tbName = tb.getName().replaceAll(".sql","");
					oTb = new File(tb + "." + phyfileExtension);
					CmnUtils.debugPrint(tbName);
					br[WK_FILE] = new BufferedReader(new FileReader(tb));
					pw[CONTENTS] = new PrintWriter(new BufferedWriter(new FileWriter(oTb)));
					while((strLine=br[WK_FILE].readLine()) != null){
						if(strLine.equals(");")){
							rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, tbName);
							if (rowNo != -1){
								rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
								CmnUtils.debugPrint(tbName + ":" + rowNo);
								//for(int j=0;j<rowData.length;i++)CmnUtils.debugPrint(rowData[j]);
								tbName = rowData[COL01];
								objName = rowData[COL02];
								objTyp = rowData[COL03];
								pctFree = rowData[COL04];
								pctUsed = rowData[COL05];
								iniTrns = rowData[COL06];
								freeLst = rowData[COL07];
								flstGrp = rowData[COL08];
								bufPool = rowData[COL09];
								tblSpace = rowData[COL10];
								logging = rowData[COL11];
								segByts = rowData[COL12];
								pw[CONTENTS].print(") PCTFREE " + pctFree);
								if(!pctUsed.equals(""))pw[CONTENTS].print(" PCTUSED " + pctUsed);
								pw[CONTENTS].print(" INITRANS " + iniTrns + " STORAGE(");
								if(!freeLst.equals(""))pw[CONTENTS].print(" FREELISTS " + freeLst);
								if(!flstGrp.equals(""))pw[CONTENTS].print(" FREELIST GROUPS " + flstGrp);
								pw[CONTENTS].print(" BUFFER_POOL " + bufPool + ")");
								pw[CONTENTS].print(" TABLESPACE " + cp.DB_SQL_QUOTEDS[cp.dbType]+ tblSpace + cp.DB_SQL_QUOTEDE[cp.dbType]);
								if(logging.equals("NO")){
									pw[CONTENTS].print(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
								} else {
									pw[CONTENTS].print(cp.SQL_TERMINATOR[cp.dbType]);
								}
							} else {
								pw[CONTENTS].print(")" + cp.SQL_TERMINATOR[cp.dbType]);
							}
						} else {
							pw[CONTENTS].println(strLine);
						}
					}
					pw[CONTENTS].close();
					pw[CONTENTS]=null;
					br[WK_FILE].close();
					br[WK_FILE]=null;
					tb.delete();
					oTb.renameTo(tb);
				}
			}
			// Rhysical Contents end

			// Remove work file
			File fl= null;
			for(int i=0;i<cp.meta_sql[cp.dbType].length;i++){
				fl= new File(folder + "/" + cp.WK_FILE_NAME[i] + "_" + database + "." + cp.fileExtension);
				CmnUtils.debugPrint(fl.toString());
				fl.delete();
			}

			// disconnect database
			dao.disconnect();
			CmnUtils.infoPrint("^f[^A[hI܂B");

		} catch(SQLException se) {
			try{
				CmnUtils.errorPrint(se.toString());
				se.printStackTrace();
				se = se.getNextException();
				if(se != null) {
					System.out.println(se.getMessage());
				}
				dao.rollback();
			} catch (Exception see) {}
		} catch (Exception e) {			
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
				dao.rollback();
			} catch (Exception ee) {}
		} finally{
			try{
				for(int i=0;i<6;i++){
					if(pw[i]!=null){
						pw[i].close();
						pw[i]=null;
					}
				}
				for(int i=0;i<4;i++){
					if(br[i]!=null){
						br[i].close();
						br[i]=null;
					}
				}
			} catch (Exception e) {}
		}
	}
	
	private String commentOnTable(CmnProps _cp, String _tableName, String _tableCmnt, int _type) throws Exception{
		String retVal = "";
		if(!_tableCmnt.equals("")){
			if(_cp.dbType == _cp.DB_TYPE_ORACLE){
				retVal = "COMMENT ON TABLE " + _cp.DB_SQL_QUOTEDS[_cp.dbType]+ _tableName + _cp.DB_SQL_QUOTEDE[_cp.dbType]+ " IS '" + _tableCmnt.replaceAll("'","''") + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
			} else if(_cp.dbType == _cp.DB_TYPE_SQLSERVER){
				if(_type == _cp.TYPE_TABLE){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _tableCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'table',@level1name=N'" + _tableName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				} else if(_type == _cp.TYPE_VIEW){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _tableCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'view',@level1name=N'" + _tableName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				}
			}
		}
		return retVal;
	}
	private String commentOnColumn(CmnProps _cp, String _tableName, String _colName, String _colCmnt, int _type) throws Exception{
		String retVal = "";
		if(!_colCmnt.equals("")){
			if(_cp.dbType == _cp.DB_TYPE_ORACLE){
				retVal = "COMMENT ON COLUMN " + _cp.DB_SQL_QUOTEDS[_cp.dbType]+ _tableName + _cp.DB_SQL_QUOTEDE[_cp.dbType]+ "." + _cp.DB_SQL_QUOTEDS[_cp.dbType]+ _colName + _cp.DB_SQL_QUOTEDE[_cp.dbType]+ " IS '" + _colCmnt.replaceAll("'","''") + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
			} else if(_cp.dbType == _cp.DB_TYPE_SQLSERVER){
				if(_type == _cp.TYPE_TABLE){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _colCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'table',@level1name=N'" + _tableName + "',@level2type=N'column',@level2name=N'" + _colName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				} else if(_type == _cp.TYPE_VIEW){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _colCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'view',@level1name=N'" + _tableName + "',@level2type=N'column',@level2name=N'" + _colName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				}
			}
		}
		return retVal;
	}
}

