<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class Calendar {

  public static function getWeekday($weekday) {
    $rtn = '';
    switch($weekday) {
      case 0:
        $rtn = '日';
        break;
      case 1:
        $rtn = '月';
        break;
      case 2:
        $rtn = '火';
        break;
      case 3:
        $rtn = '水';
        break;
      case 4:
        $rtn = '木';
        break;
      case 5:
        $rtn = '金';
        break;
      case 6:
        $rtn = '土';
        break;
    }
    return $rtn;
  }

  public static function getLastDay($yyyy, $mm) {
    $day = 31;
    while (!checkdate($mm, $day, $yyyy)) {
      $day--;
    }
    return $day;
  }

  public static function getNextMonth($next) {
    $nextMonth = mktime(0, 0, 0, date('m'), date('d'),  date('y')) + (60*60*24*31)*$next;
    return date('Y', $nextMonth). date('m', $nextMonth);
  }

}
?>
