<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class AdminController extends BaseController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }

  public function selectpage() {
    $result = $this->result;

    $title = new Title();
    $findOptions = array();
    $conditions = array('');
    $conditions[0] .= 'logtype = ?';
    array_push($conditions, Config::NORMAL_ACCESS);
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND title LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions['condition'] = $conditions;
    $findOptions['order'] = 'title ASC';
    $result->set('titleData', $title->findAll($findOptions));
    return $result;
  }

  public function doselectpage() {
    $result = $this->result;

    $selectPage = $this->request->get('select');
    if (is_null($selectPage)) {
      $this->session->delete('selectPage');
      $this->session->delete('selectTitle');
    } else {
      $this->session->set('selectPage', $selectPage);
      $title = new Title();
      $titleResult = $title->find(array('condition' => array('url = ?', $selectPage)));
      $this->session->set('selectTitle', $titleResult['title']);
    }
    $result->setNextController('research');
    $result->setNextAction('time');
    return $result;
  }

  public function resetpage() {
    $result = $this->result;

    $title = new Title();
    $title->destroy();
    $result->setNextController('admin');
    $result->setNextAction('selectpage');
    return $result;
  }

  public function selectuid() {
    $result = $this->result;

    $alias = new Alias();
    $findOptions = array();
    if (!is_null($this->request->get('search'))) {
      $conditions = array('');
      $conditions[0] .= ' name LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
      $findOptions['condition'] = $conditions;
    }
    $findOptions['order'] = 'name ASC';
    $result->set('aliasData', $alias->findAll($findOptions));
    return $result;
  }

  public function doselectuid() {
    $result = $this->result;

    $selectUid = $this->request->get('select');
    if (is_null($selectUid)) {
      $this->session->delete('selectUid');
      $this->session->delete('selectName');
    } else {
      $this->session->set('selectUid', $selectUid);
      $alias = new Alias();
      $aliasResult = $alias->find(array('condition' => array('uid = ?', $selectUid)));
      $this->session->set('selectName', $aliasResult['name']);
    }
    $result->setNextController('research');
    $result->setNextAction('time');
    return $result;
  }

  public function aliaslist() {
    $result = $this->result;

    $alias = new Alias();
    $findOptions = array();
    if (!is_null($this->request->get('search'))) {
      $conditions = array('');
      $conditions[0] .= 'name LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
      $findOptions['condition'] = $conditions;
    }
    $findOptions['order'] = 'name ASC';
    $aliasData = $alias->findAll($findOptions);
    $result->set('aliasData', $aliasData);
    return $result;
  }

  public function domainlist() {
    $result = $this->result;

    $domain = new Domain();
    $findOptions = array();
    if (!is_null($this->request->get('search'))) {
      $conditions = array('');
      $conditions[0] .= 'domain LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
      $findOptions['condition'] = $conditions;
    }
    $findOptions['order'] = 'domain ASC';
    $domainData = $domain->findAll($findOptions);
    $result->set('domainData', $domainData);
    return $result;
  }

  public function aliasedit() {
    $result = $this->result;

    $this->checkRequest('select');
    if (!$this->checkPost()) {
      if (isset($_SERVER['HTTP_REFERER'])) $this->session->set('redirect', $_SERVER['HTTP_REFERER']);
      return $result;
    }

    $select = $this->request->get('select');
    $name = $this->request->get('name');

    if (trim($select) == '') {
      $this->message->setMessage('訪問者IDが選択されていません。');
      return $result;
    } 

    if (trim($name) == '') {
      $this->message->setMessage('訪問者名を入力してください。');
      return $result;
    } 

    if (RaUtil::strLen($select) > 50) {
      $this->message->setMessage('訪問者IDは50文字以内です。');
      return $result;
    } 

    if (RaUtil::strLen($name) > 50) {
      $this->message->setMessage('訪問者名は50文字以内で入力してください。');
      return $result;
    } 

    $alias = new Alias();
    $alias->find(array('condition' => array('uid = ?', $select)));
    $alias->setValue('uid', $select);
    $alias->setValue('name', $name);
    $alias->save();

    if (SystemUtil::checkPhpMemoryLimit()) {
      $aliasData = $alias->findAll(array('order' => 'name ASC'));
      $this->session->set('aliasData', $aliasData);
    }

    $redirect = $this->session->get('redirect');
    if (!is_null($redirect)) {
      $result->setRedirect($redirect);
      $this->session->delete('redirect');
    } else {
      $result->setNextController('admin');
      $result->setNextAction('aliaslist');
    }
    return $result;
  }

  public function aliasdelete() {
    $result = $this->result;

    $delete = $this->request->get('delete');
    if (is_array($delete)) {
      foreach($delete as $id) {
        $alias = new Alias();
        $alias->find(array('condition' => array('id = ?', $id)));
        if ($alias->getValue('uid') == $this->session->get('selectUid')) {
          $this->session->delete('selectUid');
          $this->session->delete('selectName');
        }
        $alias->delete();
        $alias = null;
      }
    }

    if (SystemUtil::checkPhpMemoryLimit()) {
      $alias = new Alias();
      $aliasData = $alias->findAll(array('order' => 'name ASC'));
      $this->session->set('aliasData', $aliasData);
    }

    $result->setNextController('admin');
    $result->setNextAction('aliaslist');
    return $result;
  }

  public function domainedit() {
    $result = $this->result;

    $this->checkRequest('select');
    if (!$this->checkPost()) {
      if (isset($_SERVER['HTTP_REFERER'])) $this->session->set('redirect', $_SERVER['HTTP_REFERER']);
      return $result;
    }

    $select = $this->request->get('select');
    $name = $this->request->get('name');

    if (trim($select) == '') {
      $this->message->setMessage('ドメインが選択されていません。');
      return $result;
    } 

    if (trim($name) == '') {
      $this->message->setMessage('ドメイン名を入力してください。');
      return $result;
    } 

    if (RaUtil::strLen($select) > 100) {
      $this->message->setMessage('ドメインは100文字以内です。');
      return $result;
    } 

    if (RaUtil::strLen($name) > 30) {
      $this->message->setMessage('ドメイン名は30文字以内で入力してください。');
      return $result;
    } 

    $domain = new Domain();
    $domain->find(array('condition' => array('domain = ?', $select)));
    $domain->setValue('domain', $select);
    $domain->setValue('name', $name);
    $domain->save();

    if (SystemUtil::checkPhpMemoryLimit()) {
      $domainData = $domain->findAll(array('order' => 'name ASC'));
      $this->session->set('domainData', $domainData);
    }

    $redirect = $this->session->get('redirect');
    if (!is_null($redirect)) {
      $result->setRedirect($redirect);
      $this->session->delete('redirect');
    } else {
      $result->setNextController('admin');
      $result->setNextAction('domainlist');
    }
    return $result;
  }

  public function domaindelete() {
    $result = $this->result;

    $delete = $this->request->get('delete');
    if (is_array($delete)) {
      foreach($delete as $id) {
        $domain = new Domain();
        $domain->find(array('condition' => array('id = ?', $id)));
        $domain->delete();
        $domain = null;
      }
    }

    if (SystemUtil::checkPhpMemoryLimit()) {
      $domain = new Domain();
      $domainData = $domain->findAll(array('order' => 'name ASC'));
      $this->session->set('domainData', $domainData);
    }

    $result->setNextController('admin');
    $result->setNextAction('domainlist');
    return $result;
  }

  public function tag() {
    $result = $this->result;
    return $result;
  }

  public function phpcode() {
    $result = $this->result;
    return $result;
  }

  public function setting() {
    $result = $this->result;

    if (!$this->checkPost()) {
      return $result;
    }

    $sitename = $this->request->get('sitename');
    $url = $this->request->get('url');
    if (trim($sitename) == '') {
      $this->message->setMessage('サイト名を入力してください。');
      return $result;
    } 
    if (RaUtil::strLen($sitename) > 100) {
      $this->message->setMessage('サイト名は100文字以内で入力してください。');
      return $result;
    } 
    if (trim($url) == '') {
      $this->message->setMessage('URLを入力してください。');
      return $result;
    } 
    if (!Track::checkUrl($url)) {
      $this->message->setMessage('URLは、&quot;http://〜&quot;、&quot;https://〜&quot;の形で正しく入力してください。');
      return $result;
    } 
    if (RaUtil::strLen($url) > 100) {
      $this->message->setMessage('URLは100文字以内で入力してください。');
      return $result;
    } 

    $pswd = $this->request->get('pswd');
    $pswdConfirm = $this->request->get('pswd_confirm');
    if ((!is_null($pswd) && trim($pswd) != '') || (!is_null($pswdConfirm) && trim($pswdConfirm) != '')) {
      if ($pswd != $pswdConfirm) {
        $this->message->setMessage('パスワードの入力を確認してください。');
        return $result;
      } 
      if (RaUtil::strLen($pswd) > 100) {
        $this->message->setMessage('パスワードは100文字以内で入力してください。');
        return $result;
      } 
    }

    $id = $this->session->get('login');
    $site = new Site();
    $site->find(array('condition' => array('id = ?', $id)));
    if (!is_null($pswd) && trim($pswd) != '') $site->setValue('pswd', md5($pswd));
    $site->setValue('sitename', $sitename);
    $site->setValue('url', $url);
    $site->setValue('oksecond', $this->request->get('oksecond'));
    $site->setValue('againsecond', $this->request->get('againsecond'));
    $site->setValue('dispview', $this->request->get('dispview'));
    if ($this->request->get('nocrawler') == Config::ON) {
      $site->setValue('nocrawler', Config::ON);
    } else {
      $site->setValue('nocrawler', Config::OFF);
    }
    $site->setValue('filter', $this->request->get('filter'));
    $site->save();

    if (is_writable(SETTING_DIR)) {
      if (!$this->defineSiteurl($url)) {
        $this->message->setMessage('サイト設定に失敗しました。<br />'. '「setting」ディレクトリのアクセス権（パーミッション）を確認してください。<br />'. SETTING_DIR);
        return $result;
      }
    }

    if ($this->request->get('nocount') == Config::ON) {
      Track::setCookie(Config::getCookieKeyAdminNocount(), Config::ON, Config::COOKIE_ENABLE_DAYS, '/');
    } else {
      Track::clearCookie(Config::getCookieKeyAdminNocount(), '/');
    }
    
    $site = new Site();
    $siteData = $site->find(array('condition' => array('id = ?', $id)));
    $this->session->set('siteData', $siteData);

    return $result;
  }

  public function deletelog() {
    $result = $this->result;

    $existLog = array();
    $existLogDataSize = array();

    if ($this->checkPost() && !$this->checkRedirect()) {
      $delete = $this->request->get('delete');
      if (is_array($delete)) {
        foreach($delete as $yyyymm) {
          array_push($existLog, $yyyymm);
          $log = new Log(true, $yyyymm);
          array_push($existLogDataSize, $log->getDataSize());
        }
      }
      if (count($existLog) > 0) {
        $this->session->set('existLog', $existLog);
        $this->session->set('existLogDataSize', $existLogDataSize);
        $result->setNextController('admin');
        $result->setNextAction('deletelog_confirm');
        $this->message->setMessage('選択したログファイルを削除してもよろしいですか？');
        return $result;
      } else {
        $this->message->setMessage('ログファイルを選択してください。');
      }
    }

    $siteData = $this->session->get('siteData');
    $createYyyyMm = str_replace('-', '', substr($siteData['created_on'], 0, 7));
    $next = 0;
    $month = 1;
    $logDataSize = 0;
    while(true) {
      try {
        $yyyymm = Calendar::getNextMonth($next);
        if ($yyyymm < $createYyyyMm) break;
        $log = new Log(true, $yyyymm);
        $logDataSize = $log->getDataSize();
        $log = null;
        array_push($existLog, $yyyymm);
        array_push($existLogDataSize, $logDataSize);
        $next--;
        $month++;
      } catch (Exception $exception) {
        if ($exception->getCode() == RaModel::TABLE_NOTFOUND_ERR_CODE) {
          $next--;
          $month++;
          continue;
        } else {
          throw $exception;
        }
      }
    }

    $result->set('existLog', $existLog);
    $result->set('existLogDataSize', $existLogDataSize);

    return $result;
  }

  public function deletelog_confirm() {
    $result = $this->result;

    if ($this->checkPost() && !$this->checkRedirect()) {
      $existLog = $this->session->get('existLog');
      if (is_array($existLog)) {
        foreach($existLog as $yyyymm) {
          $log = new Log(true, $yyyymm);
          $log->drop();
        }
      }
      $this->session->delete('existLog');
      $this->session->delete('existLogDataSize');
      $result->setNextController('admin');
      $result->setNextAction('deletelog');
    }
    return $result;
  }

  public function uninstall() {
    $result = $this->result;

    if (!$this->checkPost()) {
      return $result;
    }

    $pswd = $this->request->get('pswd');
    if (trim($pswd) == '') {
      $this->message->setMessage('パスワードを入力してください。');
      return $result;
    } 

    $site = new Site();
    $siteData = $site->find(array('condition' => array('pswd = ?', md5($pswd))));
    if (is_null($siteData['id'])) {
      $this->message->setMessage('パスワードの入力に誤りがあります。');
      return $result;
    }

    $result->setNextController('admin');
    $result->setNextAction('douninstall');

    return $result;
  }

  public function douninstall() {
    $result = $this->result;
    $session = $this->session;

    if (!$this->checkPost()) {
      $result->setNextController('admin');
      $result->setNextAction('uninstall');
      return $result;
    }
    if ($this->checkRedirect()) {
      return $result;
    }

    if (!is_writable(SETTING_DIR)) {
      $this->message->setMessage('「setting」ディレクトリのアクセス権（パーミッション）を書き込み可能にしてください。<br />'. SETTING_DIR);
      return $result;
    }

    $siteData = $session->get('siteData');
    $createYyyyMm = str_replace('-', '', substr($siteData['created_on'], 0, 7));
    $next = 1;
    $month = 1;
    $logDataSize = 0;
    while(true) {
      try {
        $yyyymm = Calendar::getNextMonth($next);
        if ($yyyymm < $createYyyyMm) break;
        $log = new Log(true, $yyyymm);
        $log->drop();
        $log = null;
        $next--;
        $month++;
      } catch (Exception $exception) {
        if ($exception->getCode() == RaModel::TABLE_NOTFOUND_ERR_CODE) {
          $next--;
          $month++;
          continue;
        } else {
          throw $exception;
        }
      }
    }

    $alias = new Alias();
    $alias->drop();
    $domain = new Domain();
    $domain->drop();
    $site = new Site();
    $site->drop();
    $title = new Title();
    $title->drop();
    $system = new System();
    $system->drop();

    if (!File::deleteFile(SETTING_DATABASE_FILE)) {
      $this->message->setMessage('データベース接続設定の削除に失敗しました。<br />'. '「setting」ディレクトリのアクセス権（パーミッション）を確認してください。<br />'. SETTING_DIR);
      return $result;
    }
    if (!File::deleteFile(SETTING_SITEURL_FILE)) {
      $this->message->setMessage('サイト設定の削除に失敗しました。<br />'. '「setting」ディレクトリのアクセス権（パーミッション）を確認してください。<br />'. SETTING_DIR);
      return $result;
    }
    if (!File::deleteFile(SETTING_INSTALL_COMPLETE_FILE)) {
      $this->message->setMessage('インストール設定の削除に失敗しました。<br />'. '「setting」ディレクトリのアクセス権（パーミッション）を確認してください。<br />'. SETTING_DIR);
      return $result;
    }
    if (!File::deleteFile(SETTING_PATH_FILE)) {
      $this->message->setMessage('環境設定の削除に失敗しました。<br />'. '「setting」ディレクトリのアクセス権（パーミッション）を確認してください。<br />'. SETTING_DIR);
      return $result;
    }

    Track::clearCookie(Config::COOKIE_LOGINID);
    Track::clearCookie(Config::COOKIE_LOGINKEY);
    Track::clearCookie(Config::getCookieKeyAdminNocount(), '/');

    $this->message->setMessage('アンインストールを完了しました。ご利用ありがとうございました。<br />'. 'インストール時にアップロードしたファイルは、ご自身で削除してください。');
    $result->setNextController('error');
    $result->setNextAction('error');
    $this->session->destroy();

    return $result;
  }

}
?>
