<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class AdminHelper extends BaseHelper {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result=null, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }
  
  public function titleCount() {
    $titleData = $this->result->get('titleData');
    print $this->getFormatNumber(count($titleData));
  }

  public function aliasCount() {
    $aliasData = $this->result->get('aliasData');
    print $this->getFormatNumber(count($aliasData));
  }

  public function domainCount() {
    $domainData = $this->result->get('domainData');
    print $this->getFormatNumber(count($domainData));
  }

  public function existLogCount() {
    $existLog = $this->result->get('existLog');
    print $this->getFormatNumber(count($existLog));
  }

  public function selectExistLogCount() {
    $existLog = $this->session->get('existLog');
    print $this->getFormatNumber(count($existLog));
  }

  public function siteName() {
    $siteData = $this->session->get('siteData');
    print !is_null($this->request->get('sitename')) ? $this->request->get('sitename') : $siteData['sitename'];
  }

  public function url() {
    $siteData = $this->session->get('siteData');
    $url = !is_null($this->request->get('url')) ? $this->request->get('url') : $siteData['url'];
    if (is_writable(SETTING_DIR)) {
      $html = '<input class="text" id="url" maxlength="100" name="url" type="text" value="'. $url. '" />';
    } else {
      $html = '<input class="readonly" id="url" maxlength="100" name="url" type="text" value="'. $url. '" readonly="readonly" />';
      $html .= '<div class="cautioncolor">URLを変更する場合は、一時的に「setting」ディレクトリのアクセス権（パーミッション）を書き込み可能にしてください。</div>';
    }

    print $html;
  }

  public function filter() {
    $siteData = $this->session->get('siteData');
    print !is_null($this->request->get('filter')) ? $this->request->get('filter') : $siteData['filter'];
  }

  public function noCount() {
    if ($_SERVER['REQUEST_METHOD'] == 'GET') $nocount = isset($_COOKIE[Config::getCookieKeyAdminNocount()]) ? Config::ON : Config::OFF;
    if ($_SERVER['REQUEST_METHOD'] == 'POST') $nocount = $this->request->get('nocount') == Config::ON ? Config::ON : Config::OFF;
    print $nocount == Config::ON ? 'checked="checked"' : '';
  }

  public function noCrawler() {
    $siteData = $this->session->get('siteData');
    if ($_SERVER['REQUEST_METHOD'] == 'GET') $nocrawler = $siteData['nocrawler'] == Config::ON ? Config::ON : Config::OFF;
    if ($_SERVER['REQUEST_METHOD'] == 'POST') $nocrawler = $this->request->get('nocrawler') == Config::ON ? Config::ON : Config::OFF;
    print $nocrawler == Config::ON ? 'checked="checked"' : '';
  }

  public function resultTitleTag() {
    $titleData = $this->result->get('titleData');
    $selectPage = $this->session->get('selectPage');
    $selectTitle = $this->session->get('selectTitle');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $clsName = 'noselect';
    if ($selectPage == '') $clsName = 'select';
    
    $html = '';

    $html .= '<a class="'. $clsName. '" href="'.$this->getIndexUrl('admin', 'doselectpage'). '">'. Config::NOSELECT_PAGE. '</a>';
    if (is_array($titleData)) {
      $i = 0;
      $pageCount = 1;
      foreach ($titleData as $data) {
        if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
          $clsName = 'noselect';
          if (strcasecmp($data['url'], $selectPage) == 0) $clsName = 'select';
          $html .= '<a class="'. $clsName. '" href="'. $this->getIndexUrl('admin', 'doselectpage', '&amp;select='. $this->urlEncode($data['url'])). '" title="'. $data['url']. '">'.  $this->escapeHtml($data['title']). '</a>';
          if ($i == $siteData['dispview']) {
            break;
          }
          ++$i;
        }
        ++$pageCount;
      }
    }

    print $html;
  }

  public function resultAliasTag() {
    $aliasData = $this->result->get('aliasData');
    $selectUid = $this->session->get('selectUid');
    $selectTitle = $this->session->get('selectTitle');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $clsName = 'noselect';
    if ($selectUid == '') $clsName = 'select';
    
    $html = '';

    $html .= '<a class="'. $clsName. '" href="'. $this->getIndexUrl('admin', 'doselectuid'). '">'. Config::NOSELECT_UID. '</a>';
    if (is_array($aliasData)) {
      $i = 0;
      $pageCount = 1;
      foreach ($aliasData as $data) {
        if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
          $clsName = 'noselect';
          if (strcasecmp($data['uid'], $selectUid) == 0) $clsName = 'select';
          $html .= '<a class="'. $clsName. '" href="'. $this->getIndexUrl('admin', 'doselectuid', '&amp;select='. $this->urlEncode($data['uid'])). '" title="'. $data['uid']. '">'.  $this->escapeHtml($data['name']). '</a>';
          if ($i == $siteData['dispview']) {
            break;
          }
          ++$i;
        }
        ++$pageCount;
      }
    }

    print $html;
  }

  public function pageTag() {
    $pageCount = null;
    $action = $this->action;
    switch ($action) {
      case 'selectpage':
        $pageCount = count($this->result->get('titleData'));
        break;
      case 'selectuid':
      case 'aliaslist':
        $pageCount = count($this->result->get('aliasData'));
        break;
      case 'domainlist':
        $pageCount = count($this->result->get('domainData'));
        break;
    }
    parent::pageTag($pageCount);
  }

  public function resultAliasListTag() {
    $action = $this->action;
    $siteData = $this->session->get('siteData');
    $aliasData = $this->result->get('aliasData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i = 0;
    $pageCount = 1;
    foreach ($aliasData as $data) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $html .= '<tr>';
        $html .= '<td class="tdcol1_alias"><input type="checkbox" class="checkbox" name="delete[]" value="'. $data['id']. '" /></td>';
        $html .= '<td class="tdcol2_alias"><a href="'. $this->getIndexUrl('research', 'uid_detail', '&amp;select='. $data['uid']). '">'. $this->escapeHtml($data['uid']). '</a></td>';
        $html .= '<td class="tdcol3_alias"><a href="'. $this->getIndexUrl('research', 'uid_detail', '&amp;select='. $data['uid']). '">'. $this->escapeHtml($data['name']). '</a></td>';
        $html .= '<td class="tdcol4_alias"><a href="'. $this->getIndexUrl('admin', 'aliasedit', '&amp;select='. $data['uid']). '">設定</a></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultDomainListTag() {
    $action = $this->action;
    $siteData = $this->session->get('siteData');
    $domainData = $this->result->get("domainData");
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i = 0;
    $pageCount = 1;
    foreach ($domainData as $data) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $html .= '<tr>';
        $html .= '<td class="tdcol1_alias"><input type="checkbox" class="checkbox" name="delete[]" value="'. $data['id']. '" /></td>';
        $html .= '<td class="tdcol2_alias"><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $data['domain']). '">'. $this->escapeHtml($data['domain']). '</a></td>';
        $html .= '<td class="tdcol3_alias"><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $data['domain']). '">'. $this->escapeHtml($data['name']). '</a></td>';
        $html .= '<td class="tdcol4_alias"><a href="'. $this->getIndexUrl('admin', 'domainedit', '&amp;select='. $data['domain']). '">設定</a></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultExistLogListTag($confirm=false) {
    $existLog = $confirm ? $this->session->get('existLog') : $this->result->get('existLog');
    $existLogDataSize = $confirm ? $this->session->get('existLogDataSize') : $this->result->get('existLogDataSize');

    $html = '';

    foreach ($existLog as $key => $log) {
      $html .= '<tr>';
      $html .= '<td class="tdcol1_existlog">';
      if (!$confirm) {
        $html .= '<input type="checkbox" class="checkbox" name="delete[]" value="'. $log. '" />';
      } else {
        $html .= '◯';
      }
      $html .= '</td>';
      $html .= '<td class="tdcol2_existlog">'. $this->escapeHtml(substr($log, 0, 4)). '年'. $this->getZeroSuppress(substr($log, 4)). '月分'. '</td>';
      $html .= '<td class="tdcol3_existlog">'. $this->getFormatDataSize($existLogDataSize[$key]). '</td>';
      $html .= '</tr>';
    }

    print $html;
  }

  public function selectOptionTag($optionList, $column) {
    $siteData = $this->session->get('siteData');
    $inputValue = !is_null($this->request->get($column)) ? $this->request->get($column) : $siteData[$column] ;
    $html = '';
    foreach ($optionList as $key => $value) {
      if ($key == $inputValue) {
        $html .= '<option value="'. $key. '" selected="selected">'. $value. '</option>';
      } else {
        $html .= '<option value="'. $key. '">'. $value. '</option>';
      }
    }
    print $html;
  }

}
?>
