<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Request
 */
class RaRequest {
/* ------------------------------------------------------------------------ */

/* -- Private Property -- */
  /**
   * request
   * @var array
   */
  private $_request = array();
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * Constructer
   */
  public function __construct() {
    /**
     * Do Not urldecode
     * because =>
     *  http://jp2.php.net/manual/en/function.urldecode.php
     *  Warning
     *  The superglobals $_GET and $_REQUEST  are already decoded. 
     *  Using urldecode() on an element in $_GET or $_REQUEST could have unexpected and dangerous results. 
     */
    if( is_array($_GET) ) {
      foreach( $_GET as $key => $value) {
        $this->_request[$key] = $value;
      }
    }
    if( is_array($_POST) ) {
      foreach( $_POST as $key => $value) {
        $this->_request[$key] = $value;
      }
    }
  }

  /**
   * get
   * @param string $key Request Key
   * @return string $value Request Value
   */
  public function get($key) {
    return isset($this->_request[$key]) ? $this->_request[$key] : null;
  }
/* ------------------------------------------------------------------------ */

}
?>
