/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IConfigurationConstants {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private PluginEntry pluginEntry;

    public PluginParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    public synchronized PluginEntry parse(File pluginFile) throws SAXException, IOException {
        PluginEntry pluginEntry;
        block5: {
            FileInputStream in = null;
            try {
                in = new FileInputStream(pluginFile);
                pluginEntry = this.parse(in, "plugins/" + pluginFile.getParentFile().getName() + "/");
                Object var3_4 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (in == null) break block6;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return pluginEntry;
    }

    public synchronized PluginEntry parse(InputStream in, String bundleUrl) throws SAXException, IOException {
        try {
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setURL(bundleUrl);
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (ParseCompleteException parseCompleteException) {}
        return this.pluginEntry;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag = localName.trim();
        if (tag.equalsIgnoreCase("plugin")) {
            this.pluginEntry.isFragment(false);
            this.processPlugin(attributes);
            return;
        }
        if (tag.equalsIgnoreCase("fragment")) {
            this.pluginEntry.isFragment(true);
            this.processPlugin(attributes);
            return;
        }
    }

    private void processPlugin(Attributes attributes) throws ParseCompleteException {
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        if (id == null || id.trim().length() == 0) {
            id = "_no_id_";
        }
        this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(id, version));
        throw new ParseCompleteException("");
    }

    private class ParseCompleteException
    extends SAXException {
        public ParseCompleteException(String arg0) {
            super(arg0);
        }
    }
}

