/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.dialogs;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BeanEditorDialog
extends TitleAreaDialog {
    public static int OK = 0;
    public static int CANCEL = 1;
    private String title;
    private String message;
    private Object bean;
    private PropertyValidator validator;
    private PropertyDecorator decorator;
    private PropertySorter sorter;
    private Map propDescToFieldMap;
    static /* synthetic */ Class class$0;

    public BeanEditorDialog(Shell parentShell, String title, String message, Object bean, PropertyValidator validator, PropertyDecorator decorator, PropertySorter sorter) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.bean = bean;
        this.validator = validator;
        this.decorator = decorator;
        this.sorter = sorter;
        this.propDescToFieldMap = new HashMap();
    }

    private void validate(Map propMap) {
        String errmsg = null;
        if (this.validator != null) {
            errmsg = this.validator.validate(propMap);
        }
        this.setErrorMessage(errmsg);
        this.getButton(0).setEnabled(errmsg == null);
    }

    private Map createPropertyNameToValueMap() {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        Iterator ite = this.propDescToFieldMap.entrySet().iterator();
        while (ite.hasNext()) {
            try {
                Map.Entry entry = ite.next();
                PropertyDescriptor propdesc = (PropertyDescriptor)entry.getKey();
                Field field = (Field)entry.getValue();
                ret.put(propdesc.getName(), field.getValue());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return ret;
    }

    private void updateBeanProperties() {
        Iterator ite = this.propDescToFieldMap.entrySet().iterator();
        while (ite.hasNext()) {
            try {
                Map.Entry entry = ite.next();
                PropertyDescriptor propdesc = (PropertyDescriptor)entry.getKey();
                Field field = (Field)entry.getValue();
                PropertyUtils.setSimpleProperty((Object)this.bean, (String)propdesc.getName(), (Object)field.getValue());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        this.validate(this.createPropertyNameToValueMap());
        return ret;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite component = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(component, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        PropertyDescriptor[] propdescs = PropertyUtils.getPropertyDescriptors((Object)this.bean);
        if (this.sorter != null) {
            Arrays.sort(propdescs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    PropertyDescriptor pd1 = (PropertyDescriptor)o1;
                    PropertyDescriptor pd2 = (PropertyDescriptor)o2;
                    return BeanEditorDialog.this.sorter.compare(pd1.getName(), pd2.getName());
                }
            });
        }
        int i = 0;
        while (i < propdescs.length) {
            PropertyDescriptor propdesc = propdescs[i];
            if (PropertyUtils.isWriteable((Object)this.bean, (String)propdesc.getName())) {
                Class<?> clazz = propdesc.getPropertyType();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    Field field = this.addStringField(container, propdesc);
                    this.propDescToFieldMap.put(propdesc, field);
                }
            }
            ++i;
        }
        return container;
    }

    protected Field addStringField(Composite container, PropertyDescriptor propDesc) {
        try {
            Label label = new Label(container, 0);
            String labelText = null;
            if (this.decorator != null) {
                labelText = this.decorator.decorateLabelText(propDesc.getName());
            }
            labelText = StringUtils.isBlank(labelText) ? "&" + StringUtils.capitalize((String)propDesc.getName()) + ":" : labelText;
            label.setText(labelText);
            final Text text = new Text(container, 2052);
            text.setLayoutData((Object)new GridData(768));
            String initValue = StringUtils.defaultString((String)((String)PropertyUtils.getProperty((Object)this.bean, (String)propDesc.getName())));
            text.setText(initValue);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BeanEditorDialog.this.validate(BeanEditorDialog.this.createPropertyNameToValueMap());
                }
            });
            return new Field(){

                public Object getValue() {
                    return text.getText();
                }
            };
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected void okPressed() {
        this.updateBeanProperties();
        super.okPressed();
    }

    public static interface PropertyValidator {
        public String validate(Map var1);
    }

    public static interface PropertyDecorator {
        public String decorateLabelText(String var1);
    }

    public static interface PropertySorter {
        public int compare(String var1, String var2);
    }

    protected static interface Field {
        public Object getValue();
    }
}

