#include <cstdio>
#include <cmath>
extern "C" {
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
}
#include "udp_socket.h"
#include "player_command.h"

#include "psx_pad.h"

#define MAXMESG 8192

void ps_pad(player_command& pc, psx_pad& pad, double body_angle)
{
  if (pad.buttons() & psx_pad::BUTTON_CROSS) {
    pc.kick(100, 0);
    return;
  }else if (pad.buttons() & psx_pad::BUTTON_CIRCLE) {
    pc.kick(40, 0);
    return;
  }else if (pad.buttons() & psx_pad::BUTTON_TRIANGLE) {
    pc.kick(20, 0);
    return;
  }
  double x = pad.left_x();
  double y = pad.left_y();
  if (sqrt(x*x+y*y) / 128 > 0.5) {
    double angle = atan2(y, x) * 180 / M_PI;
    double diff=angle - body_angle;
    while (diff > 180){
      diff -= 360;
    }
    while (diff < -180){
      diff += 360;
    }

    printf("%f %f %f %f\n", x, y, angle, diff);
    if (fabs(diff) > 20) {
      if (fabs(diff) > 90) {
	diff /= 2;
      }
      pc.turn(diff);
      return;
    }
  }
  {
    double pow = (sqrt(x*x+y*y)/128);
    double max = 45;
    if (pad.buttons() & psx_pad::BUTTON_L1){
      max = 100;
    }
    pc.dash(pow * max);
  }
  /*
  if (data[3] & 0x80) {
    pc.turn(-40);
  } else if (data[3] & 0x40) {
    pc.dash(-100);
  } else if (data[3] & 0x20) {
    pc.turn(+40);
  } else if (data[3] & 0x10) {
    pc.dash(100);
  }
  */
}


double body_angle(std::string& str, player_command& pc)
{
#if 0
  try {
    fullstate_info info(str);
    std::vector<player_object>::iterator it_players = info.players().begin();
    for (; it_players != info.players().end(); it_players++) {
      player_object* player = it_players;
      if (pc.side == player->side && pc.number == player->number) {
	return player->body_angle.digit();
      }
    }
  } catch (parse_error e) {
    cerr << e.message() << endl
	 << "<" << e.buffer() << ">" << endl;
  }
#else
  int time;
  if (::sscanf(str.c_str(), "(fullstate %d", &time) == 1) {
    char p_name[16];
    sprintf(p_name, "(%c_%d", pc.side, pc.number);
    char *p = ::strstr(str.c_str(), p_name);
    printf("[[%s]]\n", p_name);
    if (p != NULL) {
      char side;
      int unum;
      double x, y, vx, vy, body_ang, neck_ang, stamina, effort, recovery;
      printf("[%s]\n", p);
      int n = ::sscanf(p, "(%c_%d %lf %lf %lf %lf %lf %lf %lf %lf %lf)",
		       &side, &unum, &x, &y, &vx, &vy,
		       &body_ang, &neck_ang, 
		       &stamina, &effort, &recovery);
      if (n == 11) {
	return body_ang;
      }
    }
  }
#endif
  return 500;
}

void message_loop(player_command& pc, psx_pad& pad)
{
  double body_ang=0;
  udp_socket& sock=pc.socket();
  fd_set	readfds;
  int		max_fd, n, ret ;

  while(1){
    timeval timeout;
    timeout.tv_sec = 0;
    timeout.tv_usec = 1000;

    FD_ZERO(&readfds) ;

    FD_SET(sock.fd(), &readfds) ;
    max_fd = sock.fd();

    FD_SET(pad.socket().fd(), &readfds) ;
    max_fd = (max_fd < pad.socket().fd())? pad.socket().fd(): max_fd;
    
    if((ret = ::select(max_fd + 1, &readfds, NULL, NULL, &timeout)) < 0){
      perror("select") ;
      break ;
    } else if (ret != 0) {
      string str;
      if(FD_ISSET(sock.fd(), &readfds)){
	n = sock.recv(str) ;
	if(n == -1)
	  break ;
	else if(n > 0){
	  double ba = body_angle(str, pc);
	  cout << "BA:" << ba << endl;
	  if (::fabs(ba) < 360) {
	    body_ang = ba;
	    ps_pad(pc, pad,  body_ang);
	  }
	}
	fflush(stdout) ;
      }else if (FD_ISSET(pad.socket().fd(), &readfds)){
	pad.read();
	if (pad.buttons() & psx_pad::BUTTON_START) {
	  return;
	}
      } 
    }
  }
}

int main(int argc, char **argv)
{
  player_command pc;
  psx_pad pad;

  if(pc.socket().fd() == -1) {
    exit(1) ;
  }
  pc.init("xxx");
  if (!pad.init(pc.number)) {
    pc.bye();
    pad.bye();
    exit(1);
  }
  message_loop(pc, pad) ;
  pc.bye();
  pad.bye();
}


