#include <cstdio>
#include <iostream.h>
#include "psx_pad.h"

int psx_pad::init(int number)
{
  char buf[16];
  sprintf(buf, "(init %2d)", number);
  std::string msg(buf);

  server.send(msg);
  cerr << msg << endl;
  server.recv(msg);
  cerr << msg << endl;
  cerr.flush();

  if (msg != "(ok)") {
    server.close();
    cerr << msg << endl;
    cerr.flush();
    exit(1);
  }
  return number;
}

int psx_pad::bye()
{
  std::string cmd = "(bye)";
  server.send(cmd);
  server.close();
  return 0;
}

int psx_pad::read()
{
  static unsigned char buf[8];
  int n = this->server.recv((char*) buf, sizeof(buf)) ;
  if(n > 0){
    this->m_type    = (buf[0] & 0xf0) >> 4;
    this->m_number  = (buf[0] & 0x0f);
    this->m_buttons = (buf[1] << 8) | buf[2];
    this->m_right_x =  (char) buf[3];
    this->m_right_y =  (char) buf[4];
    this->m_left_x  =  (char) buf[5];
    this->m_left_y  =  (char) buf[6];
    printf("#%02d [TYPE:%02x] %04x %4d %4d %4d %4d\n",    
	   this->m_number, this->m_type,
	   this->m_buttons,
	   this->m_left_x, this->m_left_y,
	   this->m_right_x, this->m_right_y);
  }
  return n;
}
