#ifndef PSX_PAD_H_INCLUDED
#define PSX_PAD_H_INCLUDED

#include "udp_socket.h"

class psx_pad {
  udp_socket server;
  int m_type;
  int m_number;
  int m_buttons;
  int m_left_x;			/* -127 : 128 */
  int m_left_y;			/* -127 : 128 */
  int m_right_x;		/* -127 : 128 */
  int m_right_y;		/* -127 : 128 */
 public:
  static const int BUTTON_UP		= 0x1000;
  static const int BUTTON_RIGHT		= 0x2000;
  static const int BUTTON_DOWN		= 0x4000;
  static const int BUTTON_LEFT		= 0x8000;

  static const int BUTTON_SELECT	= 0x0100;
  static const int BUTTON_L3		= 0x0200;
  static const int BUTTON_R3		= 0x0400;
  static const int BUTTON_START		= 0x0800;

  static const int BUTTON_TRIANGLE	= 0x0010;
  static const int BUTTON_CIRCLE	= 0x0020;
  static const int BUTTON_CROSS		= 0x0040;
  static const int BUTTON_BOX		= 0x0080;

  static const int BUTTON_L2		= 0x0001;
  static const int BUTTON_R2		= 0x0002;
  static const int BUTTON_L1		= 0x0004;
  static const int BUTTON_R1		= 0x0008;

  int  number;
  psx_pad(const std::string host="localhost", int port=12000)
    :server(host, port){};
  ~psx_pad(){};
  int init(int number);
  int bye();
  int read();
  const int buttons() { return this->m_buttons; }
  const int left_x() { return this->m_left_x; }
  const int left_y() { return this->m_left_y; }
  const int right_x() { return this->m_right_x; }
  const int right_y() { return this->m_right_y; }

  udp_socket& socket(){ return this->server; }
};

#endif //PSX_PAD_H_INCLUDED
