#ifndef UDP_SOCKET_H_INCLUDED
#define UDP_SOCKET_H_INCLUDED

extern "C" {
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
}

#include <string>

class udp_socket {
 private:
  int socket_fd;
  sockaddr_in addr;

 public:
  static const int BAD_FD = -1;
  static const int BUF_SIZE = 8192;

  udp_socket(const std::string& host = "localhost", const int port = 6000);
  ~udp_socket();

  int send(const std::string & str);
  int recv(std::string& str);
  int recv(char buf[], int size);
  int fd();
  int close();
};

#endif // UDP_SOCKET_H_INCLUDED
