#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <sys/ioctl.h>

#include <string.h>
#include <sys/time.h>
#include <unistd.h>



#define PORT 12000
#define HOST "localhost"

int main(int argc, char** argv) {
  
  int sd, addrlen;
  struct sockaddr_in svaddr;
  struct sockaddr_in myaddr;
  struct hostent *hp;


  char bye[] = "(bye)";
  char buf[128];

  bzero((char *) &myaddr, sizeof(struct sockaddr_in));
  bzero((char *) &svaddr, sizeof(struct sockaddr_in));

  svaddr.sin_family           = AF_INET ;
  if ((hp = gethostbyname(HOST)) == NULL) {
    perror("gethostbyname");
    exit(1);
  }
  svaddr.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;
  svaddr.sin_port	      = htons(PORT) ;

  if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
    perror("socket");
    exit(1);
  }
  {
    int one = 1 ;
    if (ioctl(sd, FIONBIO, &one) < 0 ) {
      perror("Can't ioctl on socket");
      exit(1);
    }
  }

  myaddr.sin_family	 = AF_INET ;
  myaddr.sin_addr.s_addr = htons(INADDR_ANY);
  myaddr.sin_port	 = 0;

  if (bind(sd, (struct sockaddr*) &myaddr, sizeof(struct sockaddr_in)) == -1) {
    perror("bind");
    exit(1);
  }

  if (argc > 1) {
    sprintf(buf, "(init %s)", argv[1]);
  } else {
    sprintf(buf, "(init %s)", "1");
  }

  addrlen = sizeof(struct sockaddr_in);
  if (sendto(sd, buf, strlen(buf), 0,
	     (struct sockaddr*) &svaddr, addrlen) == -1) {
    perror("sendto init");
    exit(1);
  }
  while (1){
    int res;
    if ((res = recvfrom(sd, buf, sizeof(buf), 0, (struct sockaddr *)&svaddr, &addrlen)) > 0) {
      if (strcasecmp(buf, "(ok)") == 0){
	puts("connected.");
	break;
      } else {
	puts("connect failed.");
	exit(1);
      }
    }
  }
  {
    for (;;) {
      fd_set fdset;
      struct timeval timeout;

      FD_ZERO(&fdset);
      FD_SET(sd, &fdset);      
      timeout.tv_sec = 0;
      timeout.tv_usec = 1;
      if (select(sd + 1, &fdset, NULL, NULL, &timeout) > 0) {
	int res = recvfrom(sd, buf, sizeof(buf), 0, (struct sockaddr *)&svaddr, &addrlen);
	if (res > 0) {
	  int type = (buf[0] & 0xf0) >> 4;
	  int num  = (buf[0] & 0x0f);
	  printf("#%02d [TYPE:%02x] %02x %02x %4d %4d %4d %4d\n",
		 num, type, buf[1], buf[2], buf[3], buf[4], buf[5], buf[6]);
	  if (buf[1] & 0x9) {
	    break;
	  }
	} else {
	  if(errno == EWOULDBLOCK){
	    buf[0] = '\0' ;
	  }
	  perror("recvfrom");
	}
      }
    }
  }
  if (sendto(sd, bye, strlen(bye), 0,
	     (struct sockaddr*) &svaddr, addrlen) == -1) {
    perror("sendto bye");
    exit(1);
  }

  close(sd);

  return 0;
}
