#ifndef RCRPC_H
#define RCRPC_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define SIODEV "/dev/ttyS0"	// for Linux
//#define SIODEV "/dev/cuaa0"	// for FreeBSD

inline int rcrpc_init() {
  int fd = open(SIODEV, O_RDWR | O_NOCTTY);
  if (fd < 0) { 
    perror(SIODEV);
    exit(1);
  }

  struct termios tio;
  memset((char *)&tio, 0, sizeof(tio));
  tio.c_cflag = B115200 | CRTSCTS | CS8 | CLOCAL | CREAD;
  tio.c_iflag = IGNPAR | ICRNL;
  tio.c_oflag = 0;
  tio.c_lflag = 0;
  tio.c_cc[VMIN] = 7;
  tcflush(fd, TCIFLUSH);
  tcsetattr(fd, TCSANOW, &tio);

  return fd;
}

#endif  //RCRPC_H
