#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "serv.h"

typedef struct {
  int fd;
  struct sockaddr_in addr;
} socket_t;

static socket_t clients[12];
static socket_t server;
static socket_t server_c;

void init_serv(int port)
{
  fprintf(stderr,"server port = %d\n", port);

  {
    int i;
    for (i = 0; i < 12; i++) {
      clients[i].fd = -1;
      memset(&(clients[i].addr), 0, sizeof(struct sockaddr_in));
    }
  }

  /* server open */
  memset(&(server.addr), 0, sizeof(struct sockaddr_in));
  server.addr.sin_family	= AF_INET;
  server.addr.sin_addr.s_addr	= htonl(INADDR_ANY);
  server.addr.sin_port		= htons(port);

  if ((server.fd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
    perror("server socket");
    exit(1);
  }
  {
    int one = 1 ;
    if (ioctl(server.fd, FIONBIO, &one) < 0 ) {
      perror("Can't ioctl on socket");
      exit(1);
    }
  }

  if (bind(server.fd, (struct sockaddr *) &(server.addr),
	   sizeof(struct sockaddr_in)) == -1) {
    perror("server socket binding");
    exit(1);
  }
}

int set_socket_fdset(fd_set *fdset)
{
  int i;
  int max = server.fd;

  FD_ZERO(fdset);
  FD_SET(server.fd, fdset);
  for (i = 0; i < 12; i++) {
    if (clients[i].fd > 0) {
      FD_SET(clients[i].fd, fdset);
      if (clients[i].fd > max) {
	max = clients[i].fd;
      }
    }
  }

  return max;
}

void receive_request(fd_set* fdset)
{
  char buf[256];
  struct sockaddr_in claddr;
  int addrlen = sizeof(struct sockaddr_in);
  
  if (FD_ISSET(server.fd, fdset)) {
    int psx_num; 
    int len;
    memset(&(claddr), 0, addrlen);
    len = recvfrom(server.fd, buf, sizeof(buf), 0,
		   (struct sockaddr *)&claddr, &addrlen);
    if (len == -1) { 
      perror("recvfrom");
    }
    buf[len] = '\0';
    printf("server:%s\n", buf);

    if (sscanf(buf, "(init %d)", &psx_num) != 1) {
      perror("sscanf()");
    } else if (!(0 <= psx_num && psx_num < 12)) {
      perror("bad number(not 0-11)");
    } else if (clients[psx_num].fd > 0) {
      char error[] = "(error already used)";
      fprintf(stderr, "already used\n");
      if (sendto(server.fd, error, sizeof(error), 0,
		 (struct sockaddr *) &claddr, sizeof(claddr)) == -1) {
	perror("sendto(\"(error)\")");
      }
    } else {
      if ((clients[psx_num].fd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
	perror("client socket");
	exit(1);
      }
      {
	int one = 1 ;
	if (ioctl(clients[psx_num].fd, FIONBIO, &one) < 0 ) {
	  perror("Can't ioctl on socket");
	}
      }

      memset(&(server_c.addr), 0, sizeof(struct sockaddr_in));
      server_c.addr.sin_family		= AF_INET;
      server_c.addr.sin_addr.s_addr	= htonl(INADDR_ANY);
      server_c.addr.sin_port		= htons(0);
      if (bind(clients[psx_num].fd,
	       (struct sockaddr *) &(server_c.addr), addrlen) == -1) {
	perror("client socket binding");
	exit(1);
      }
      /* memset(&(clients[psx_num].addr), &claddr, addrlen); */
      memset(&(clients[psx_num].addr), 0, addrlen);
      clients[psx_num].addr.sin_addr.s_addr = claddr.sin_addr.s_addr;
      clients[psx_num].addr.sin_port = claddr.sin_port;
      printf("entry %d\n", psx_num);
      {
	char ok[]="(ok)";
	send_data(psx_num, ok, sizeof(ok));
      }
    }
  }
  {
    int i;
    for (i = 0; i < 12; i++) {
      if (clients[i].fd > 0 && FD_ISSET(clients[i].fd, fdset)) {
	int len = recvfrom(clients[i].fd, buf, sizeof(buf), 
			   0, (struct sockaddr*)&claddr, &addrlen);
	if (len == -1) {
	  perror("recvfrom");
	  close(clients[i].fd);
	  clients[i].fd = -1;
	  printf("unentry %d\n", i);
	}
	buf[len] = '\0';
	printf("%d:%s\n", i, buf);
	if (!strcmp(buf, "(bye)")) {
	  close(clients[i].fd);
	  clients[i].fd = -1;
	  printf("unentry %d\n", i);
	}
      }
    }
  }
}

void send_data(int psx_num, unsigned char* data, int size)
{
  if (0 <= psx_num && psx_num < 12 && clients[psx_num].fd > 0) {
    struct sockaddr_in claddr;
    memset((char *) &claddr, 0, sizeof(claddr)) ;
    claddr.sin_family		= AF_INET;
    claddr.sin_addr.s_addr	= clients[psx_num].addr.sin_addr.s_addr;
    claddr.sin_port		= clients[psx_num].addr.sin_port;
    if (sendto(clients[psx_num].fd, data, size, 0,
	       (struct sockaddr *) &claddr, sizeof(claddr)) != size) {
      perror("sendto()");
    }
  }
}
