require "test/unit"
require "ChaSen"

$KCODE="e"
class TC_ChaSen < Test::Unit::TestCase
  def setup
    @test_text = "ˤϡ"
    @test_result = "ˤ\t˥\tˤ\tư\t\t\n\t\t\t-\t\t\nEOS\n"

    @test_filename = "#{File.dirname __FILE__}/test.txt"
    @test_file = File.open(@test_filename, "wb")
    @test_file.write(@test_text)
    @test_file.close

  end

  def teardown

  end

  def test_sparse_tostr 
    assert_equal(ChaSen::sparse_tostr(@test_text), @test_result)
  end

  def test_fparse_tostr 
    @test_file = File.open(@test_filename, "rb")
    assert_equal(ChaSen::fparse_tostr(@test_file), @test_result)
    @test_file.close
  end

  def test_fparse
    @output_file = File.open("#{File.dirname __FILE__}/output.txt", "wb")
    @test_file = File.open(@test_filename, "rb")
    ChaSen::fparse(@test_file, @output_file)
    @output_file.close
    @test_file.close
    
    @output_file = File.open("#{File.dirname __FILE__}/output.txt", "rb")
    assert_equal(@output_file.read, @test_result)
    @output_file.close
  end

  def test_sparse
    @output_file = File.open("#{File.dirname __FILE__}/output.txt", "wb")
    ChaSen::sparse(@test_text, @output_file)
    @output_file.close
    @output_file = File.open("#{File.dirname __FILE__}/output.txt", "rb")
    assert_equal(@output_file.read, @test_result)
    @output_file.close
  end

end
