# = Class Loader
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: class_loader.rb 74 2008-10-12 02:17:15Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/lang/system_utils'
require 'commons/ruby/string'

module Commons
  module Lang
    
    class ClassLoader
      
      # Load the class definition file (feature).
      # Feature guess pattern:
      #   `Commons::Lang::ClassLoader' -> `commons/lang/class_loader'
      # raise:: LoadError if the class definition file is not found.
      def self.load(class_name)
        begin
          eval(class_name)
        rescue NameError
          require class_name \
              .replace_all(/([a-z0-9])([A-Z])/, '\\1_\\2') \
              .replace_all(/::/, '/') \
              .downcase
        end
      end
      
      
      # Get the absolute path of the given resource name.
      # Resource name is relative path (delimiter: '/')on $LOAD_PATH.
      # return:: the absolute path, or nil if the resource is not found.
      def self.get_resource(name)
        if name == nil || name == ''
          return nil
        end
        
        file_separator = SystemUtils.file_separator
        name = name.replace_all(/\//, file_separator)
        matched_path = $LOAD_PATH.find {|path|
          FileTest.exist?(path + file_separator + name)
        }
        
        return matched_path == nil ? nil : matched_path + file_separator + name
      end
      
    end
    
  end
end
