# = No Operation Logger
# 
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: no_op_log.rb 77 2008-10-12 12:07:49Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/logging/log'

module Commons
  module Logging
    module Impl

      class NoOpLog
        include Commons::Logging::Log
        
        def initialize(name = nil)
          # do nothing.
        end
        
        
        def log(level, message, exception = nil)
          # do nothing.
        end
        
        
        def enabled_for?(level)
          return false
        end
      end

    end
  end
end
