# = Log4r::Logger
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: logger.rb 77 2008-10-12 12:07:49Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'log4r'

require 'commons'
require 'commons/lang/class_loader'

module Log4r

  # This is the extended Log4r::Logger class of rCommons.
  #
  # Example:
  #   require 'commons/ruby/log4r'
  #   
  #   module Example
  #     class Sample
  #       LOG = Log4r::Logger.get_logger(self.name)
  #       #@@log = Log4r::Logger.get_logger(self.name)  # for Ruby 1.9 or later.
  #       # ...
  #       if LOG.debug?
  #         LOG.debug('This is DEBUG log.')
  #       end
  #       LOG.info('This is INFO log.')
  #       # ...
  #     end
  #   end  
  class Logger
    DEFAULT_XML_CONFIGURATION_FILE = 'log4r.xml'
    
    DEFAULT_YAML_CONFIGURATION_FILE = 'log4r.yaml'
    
    @@current_configuration_file = nil
    
    
    def self.static_initialize
      # 1. ENV
      config = ENV[Commons::LOG4R_CONF_PROPERTY]
      # 2. Commons::ENV
      if config == nil
        config = Commons::ENV[Commons::LOG4R_CONF_PROPERTY]
      end
      # 3. Default XML configuration file
      if config == nil
        config = Commons::Lang::ClassLoader.get_resource(DEFAULT_XML_CONFIGURATION_FILE)
      end
      # 4. Default YAML configuration file
      if config == nil
        config = Commons::Lang::ClassLoader.get_resource(DEFAULT_YAML_CONFIGURATION_FILE)
      end
      
      if config != nil
        case config[config.rindex('.') .. -1]
          when '.xml'
            require 'log4r/configurator'
            Configurator.load_xml_file(config)
            @@current_configuration_file = config
          when '.yaml', '.yml'
            require 'log4r/yamlconfigurator'
            YamlConfigurator.load_yaml_file(config)
            @@current_configuration_file = config
          else
            # do nothing.
        end
      end
    end
    class << self
      protected :static_initialize
    end
    self.static_initialize
    
    
    def self.get_logger(name)
      if Logger[name] == nil
        logger = Logger.new(name)
        if logger.additive
          logger.trace = logger.parent.trace  # inherit trace flag
        end
        return logger
      else
        return Logger[name]
      end
    end
    
  end
  
end
