/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class PlaceAmbulanceCentreTool
extends ShapeTool {
    public PlaceAmbulanceCentreTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place ambulance centre";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addAmbulanceCentre(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddAmbulanceCentreEdit(shape.getID()));
    }

    private class AddAmbulanceCentreEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddAmbulanceCentreEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceAmbulanceCentreTool.this.editor.getScenario().removeAmbulanceCentre(this.id);
            PlaceAmbulanceCentreTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceAmbulanceCentreTool.this.editor.getScenario().addAmbulanceCentre(this.id);
            PlaceAmbulanceCentreTool.this.editor.updateOverlays();
        }
    }
}

