/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.IncrementalDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DelaunayTriangulationBuilder {
    private Collection siteCoords;
    private double tolerance = 0.0;
    private QuadEdgeSubdivision subdiv = null;

    public static CoordinateList extractUniqueCoordinates(Geometry geom) {
        if (geom == null) {
            return new CoordinateList();
        }
        Coordinate[] coords = geom.getCoordinates();
        return DelaunayTriangulationBuilder.unique(coords);
    }

    public static CoordinateList unique(Coordinate[] coords) {
        Arrays.sort(coords);
        CoordinateList coordList = new CoordinateList(coords, false);
        return coordList;
    }

    public static List toVertices(Collection coords) {
        ArrayList<Vertex> verts = new ArrayList<Vertex>();
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate coord = (Coordinate)i.next();
            verts.add(new Vertex(coord));
        }
        return verts;
    }

    public static Envelope envelope(Collection coords) {
        Envelope env = new Envelope();
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate coord = (Coordinate)i.next();
            env.expandToInclude(coord);
        }
        return env;
    }

    public void setSites(Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geom);
    }

    public void setSites(Collection coords) {
        this.siteCoords = DelaunayTriangulationBuilder.unique(CoordinateArrays.toCoordinateArray(coords));
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope siteEnv = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        List vertices = DelaunayTriangulationBuilder.toVertices(this.siteCoords);
        this.subdiv = new QuadEdgeSubdivision(siteEnv, this.tolerance);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(this.subdiv);
        triangulator.insertSites(vertices);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getEdges(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getEdges(geomFact);
    }

    public Geometry getTriangles(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getTriangles(geomFact);
    }
}

