/*
 * Decompiled with CFR 0.152.
 */
package human;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.misc.Handy;
import rescuecore2.standard.components.StandardAgent;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import sample.SampleSearch;

public class ControlledFireBrigade
extends StandardAgent<FireBrigade> {
    private static final int MAX_WATER = 15000;
    private static final int EXTINGUISH_DISTANCE = 30000;
    private static final int EXTINGUISH_POWER = 1000;
    private SampleSearch search;
    private Building target;

    public void setTarget(Building target) {
        this.target = target;
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        int distance;
        if (this.target == null) {
            Logger.info((String)"Nothing to do");
            return;
        }
        if (this.target instanceof Refuge) {
            List path = this.search.breadthFirstSearch(((FireBrigade)this.me()).getPosition(), new EntityID[]{this.target.getID()});
            if (path != null) {
                this.sendMove(time, path);
                return;
            }
            Logger.info((String)"Couldn't plan a path to refuge.");
        }
        if ((distance = ((StandardWorldModel)this.model).getDistance((StandardEntity)this.me(), (StandardEntity)this.target)) < 30000) {
            this.sendExtinguish(time, this.target.getID(), 1000);
            return;
        }
        if (!this.target.equals((Object)this.location())) {
            List<EntityID> path = this.planPathToFire();
            if (path != null) {
                this.sendMove(time, path);
                return;
            }
            Logger.info((String)"Couldn't plan a path to target.");
        }
    }

    private List<EntityID> planPathToFire() {
        Collection targets = ((StandardWorldModel)this.model).getObjectsInRange((StandardEntity)this.target, 30000);
        if (targets.isEmpty()) {
            return null;
        }
        return this.search.breadthFirstSearch(((FireBrigade)this.me()).getPosition(), (Collection)Handy.objectsToIDs((Collection)targets));
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.FIRE_BRIGADE);
    }

    protected StandardEntity location() {
        FireBrigade me = (FireBrigade)this.me();
        return me.getPosition(this.model);
    }

    protected void postConnect() {
        super.postConnect();
        this.search = new SampleSearch((StandardWorldModel)this.model);
    }

    public String toString() {
        if (this.me() == null) {
            return "Human controlled fire brigade";
        }
        return "Human controlled fire brigade " + ((FireBrigade)this.me()).getID() + " (" + ((FireBrigade)this.me()).getWater() + " water)" + (this.target == null ? " (no target)" : " target: building " + this.target.getID());
    }
}

