/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import rescuecore.Property;
import rescuecore.RescueComponent;
import rescuecore.RescueObject;
import rescuecore.debug.DebugWriter;
import rescuecore.event.MemoryListener;
import rescuecore.event.ObjectAddedEvent;
import rescuecore.event.ObjectChangedEvent;

public class DebugMemoryListener
implements MemoryListener {
    private RescueComponent component;

    public DebugMemoryListener(RescueComponent component) {
        this.component = component;
    }

    @Override
    public void objectAdded(ObjectAddedEvent event) {
        RescueObject object = event.getObject();
        int time = event.getTimestamp();
        DebugWriter.logObjectAdded(this.component, object, time);
    }

    @Override
    public void objectChanged(ObjectChangedEvent event) {
        RescueObject object = event.getObject();
        int timeStamp = event.getTimestamp();
        int property = event.getProperty();
        Property p = object.getProperty(property);
        DebugWriter.logObjectChanged(this.component, object, p, timeStamp);
    }
}

