/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public class DirectedEdge {
    private Edge edge;
    private boolean forward;
    private Line2D line;

    public DirectedEdge(Edge edge, boolean forward) {
        this.edge = edge;
        this.forward = forward;
        this.line = edge.getLine();
        if (!forward) {
            this.line = new Line2D(this.line.getEndPoint(), this.line.getOrigin());
        }
    }

    public DirectedEdge(Edge edge, Node start) {
        this.edge = edge;
        this.forward = start.equals(edge.getStart());
        this.line = edge.getLine();
        if (!this.forward) {
            this.line = new Line2D(this.line.getEndPoint(), this.line.getOrigin());
        }
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Line2D getLine() {
        return this.line;
    }

    public boolean isForward() {
        return this.forward;
    }

    public Node getStartNode() {
        return this.forward ? this.edge.getStart() : this.edge.getEnd();
    }

    public Node getEndNode() {
        return this.forward ? this.edge.getEnd() : this.edge.getStart();
    }

    public Point2D getStartCoordinates() {
        if (this.forward) {
            return this.edge.getStart().getCoordinates();
        }
        return this.edge.getEnd().getCoordinates();
    }

    public Point2D getEndCoordinates() {
        if (this.forward) {
            return this.edge.getEnd().getCoordinates();
        }
        return this.edge.getStart().getCoordinates();
    }

    public String toString() {
        return "DirectedEdge" + (this.forward ? "" : " backwards") + " along " + this.edge;
    }

    public int hashCode() {
        return this.edge.hashCode() ^ (this.forward ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o instanceof DirectedEdge) {
            DirectedEdge e = (DirectedEdge)o;
            return this.forward == e.forward && this.edge.equals(e.edge);
        }
        return false;
    }
}

