/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import maps.gml.GMLNode;
import maps.gml.GMLRoad;
import maps.gml.editor.CreateShapeTool;
import maps.gml.editor.GMLEditor;

public class CreateRoadTool
extends CreateShapeTool {
    public CreateRoadTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Create road";
    }

    @Override
    protected UndoableEdit finished(List<GMLNode> nodes) {
        GMLRoad road = this.editor.getMap().createRoadFromNodes(nodes);
        return new CreateRoadEdit(road);
    }

    private class CreateRoadEdit
    extends AbstractUndoableEdit {
        private GMLRoad road;

        public CreateRoadEdit(GMLRoad road) {
            this.road = road;
        }

        @Override
        public void undo() {
            super.undo();
            CreateRoadTool.this.editor.getMap().removeRoad(this.road);
            CreateRoadTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            CreateRoadTool.this.editor.getMap().addRoad(this.road);
            CreateRoadTool.this.editor.getViewer().repaint();
        }
    }
}

